/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl.handler;

import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.ValidatingResponseHandler;
import com.github.sardine.model.Prop;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class LockResponseHandler
extends ValidatingResponseHandler<String> {
    public String handleResponse(HttpResponse response) throws IOException {
        super.validateResponse(response);
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            StatusLine statusLine = response.getStatusLine();
            throw new SardineException("No entity found in response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return this.getToken(entity.getContent());
    }

    protected String getToken(InputStream stream) throws IOException {
        Prop prop = (Prop)SardineUtil.unmarshal(stream);
        return prop.getLockdiscovery().getActivelock().iterator().next().getLocktoken().getHref().iterator().next();
    }
}

