/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.web.BWeb;
import org.baraza.web.BWebForms;
import org.baraza.xml.BElement;

public class Bajax
extends HttpServlet {
    Logger log = Logger.getLogger(Bajax.class.getName());
    BWeb web = null;
    BDB db = null;

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        ServletContext context = this.getServletContext();
        HttpSession session = request.getSession(true);
        String xmlcnf = (String)session.getAttribute("xmlcnf");
        String ps = System.getProperty("file.separator");
        String xmlfile = context.getRealPath("WEB-INF") + ps + "configs" + ps + xmlcnf;
        String projectDir = context.getInitParameter("projectDir");
        if (projectDir != null) {
            xmlfile = projectDir + ps + "configs" + ps + xmlcnf;
        }
        String dbconfig = "java:/comp/env/jdbc/database";
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String ce = (String)e.nextElement();
            System.out.println(ce + ":" + request.getParameter(ce));
        }
        response.setContentType("text/html");
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String resp = "";
        this.web = new BWeb(dbconfig, xmlfile, context);
        this.web.init(request);
        this.db = this.web.getDB();
        String sp = request.getServletPath();
        if (sp.equals("/ajaxupdate") && "edit".equals(request.getParameter("oper"))) {
            resp = this.updateGrid(request);
        }
        System.out.println("AJAX Reached : " + request.getParameter("fnct"));
        String function = request.getParameter("ajaxfunction");
        String params = request.getParameter("ajaxparams");
        String from = request.getParameter("from");
        if (function != null && params != null) {
            resp = this.executeSQLFxn(function, params, from);
        }
        String fnct = request.getParameter("fnct");
        String id = request.getParameter("id");
        String ids = request.getParameter("ids");
        String startDate = request.getParameter("startdate");
        String startTime = request.getParameter("starttime");
        String endDate = request.getParameter("enddate");
        String endTime = request.getParameter("endtime");
        if ("formupdate".equals(fnct)) {
            BWebForms webForm = new BWebForms(this.db);
            resp = webForm.updateForm(request.getParameter("entry_form_id"), request.getParameter("json"));
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("formsubmit".equals(fnct)) {
            BWebForms webForm = new BWebForms(this.db);
            resp = webForm.submitForm(request.getParameter("entry_form_id"), request.getParameter("json"));
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("calresize".equals(fnct)) {
            resp = this.calResize(id, endDate, endTime);
        } else if ("calmove".equals(fnct)) {
            resp = this.calMove(id, startDate, startTime, endDate, endTime);
        } else if ("filter".equals(fnct)) {
            resp = this.web.getFilterWhere(request);
        } else if ("operation".equals(fnct)) {
            resp = this.calOperation(id, ids, request);
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("password".equals(fnct)) {
            resp = this.changePassword(request.getParameter("oldpass"), request.getParameter("newpass"));
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("importprocess".equals(fnct)) {
            resp = this.importProcess(this.web.getView().getAttribute("process"));
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("buy_product".equals(fnct)) {
            resp = this.buyProduct(id, request.getParameter("units"));
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("renew_product".equals(fnct)) {
            resp = this.renewProduct();
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("tableviewupdate".equals(fnct)) {
            resp = this.tableViewUpdate(request);
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("jsinsert".equals(fnct)) {
            resp = this.jsGrid(fnct, request);
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("jsupdate".equals(fnct)) {
            resp = this.jsGrid(fnct, request);
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("jsdelete".equals(fnct)) {
            resp = this.jsGrid(fnct, request);
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("attendance".equals(fnct)) {
            resp = this.attendance(request);
            response.setContentType("application/json;charset=\"utf-8\"");
        } else if ("task".equals(fnct)) {
            resp = this.tasks(request);
            response.setContentType("application/json;charset=\"utf-8\"");
        }
        this.web.close();
        out.println(resp);
    }

    public String updateGrid(HttpServletRequest request) {
        String resp = "";
        boolean hasEdit = false;
        BElement view = this.web.getView();
        String upSql = "UPDATE " + view.getAttribute("updatetable") + " SET ";
        for (BElement el : view.getElements()) {
            if (!el.getName().equals("EDITFIELD")) continue;
            if (hasEdit) {
                upSql = upSql + ", ";
            }
            upSql = upSql + el.getValue() + " = '" + request.getParameter(el.getValue()) + "'";
            hasEdit = true;
        }
        if (hasEdit) {
            String editKey = view.getAttribute("keyfield");
            String id = request.getParameter("KF");
            String autoKeyID = this.db.insAudit(view.getAttribute("updatetable"), id, "EDIT");
            if (view.getAttribute("auditid") != null) {
                upSql = upSql + ", " + view.getAttribute("auditid") + " = " + autoKeyID;
            }
            upSql = upSql + " WHERE " + editKey + " = '" + id + "'";
            resp = this.db.executeQuery(upSql);
            System.out.println("BASE GRID UPDATE : " + upSql);
        }
        resp = resp == null ? "{\"status\":\"OK\"}" : "{\"status\":\"Error\", \"msg\":\"" + resp + "\"}";
        return resp;
    }

    public String calResize(String id, String endDate, String endTime) {
        String resp = "";
        String sql = "UPDATE case_activity SET finish_time = '" + endTime + "' ";
        sql = sql + "WHERE case_activity_id = " + id;
        System.out.println(sql);
        this.web.executeQuery(sql);
        return resp;
    }

    public String calMove(String id, String startDate, String startTime, String endDate, String endTime) {
        String resp = "";
        if ("".equals(endDate)) {
            resp = this.calResize(id, endDate, endTime);
        } else {
            String sql = "UPDATE case_activity SET activity_date = '" + endDate + "', activity_time = '" + startTime;
            sql = sql + "', finish_time = '" + endTime + "' ";
            sql = sql + "WHERE case_activity_id = " + id;
            System.out.println(sql);
            this.web.executeQuery(sql);
        }
        return resp;
    }

    public String executeSQLFxn(String fxn, String prms, String from) {
        String query = "";
        query = from == null ? "SELECT " + fxn + "('" + prms + "')" : "SELECT " + fxn + "('" + prms + "') from " + from;
        System.out.println("SQL function = " + query);
        String str = "";
        if (!prms.trim().equals("")) {
            str = this.web.executeFunction(query);
        }
        return str;
    }

    public String escapeSQL(String str) {
        String escaped = str.replaceAll("'", "'");
        return escaped;
    }

    public String calOperation(String id, String ids, HttpServletRequest request) {
        String resp = this.web.setOperations(id, ids, request);
        return resp;
    }

    public String changePassword(String oldPass, String newPass) {
        String resp = "";
        String fnct = this.web.getRoot().getAttribute("password");
        if (fnct == null) {
            return "{\"success\": 0, \"message\": \"Cannot change Password\"}";
        }
        oldPass = oldPass.replaceAll("'", "''");
        newPass = newPass.replaceAll("'", "''");
        String mySql = "SELECT " + fnct + "('" + this.web.getUserID() + "', '" + oldPass + "','" + newPass + "')";
        String myoutput = this.web.executeFunction(mySql);
        resp = myoutput == null ? "{\"success\": 0, \"message\": \"Old Password Is incorrect\"}" : "{\"success\": 1, \"message\": \"Password Changed Successfully\"}";
        return resp;
    }

    public String importProcess(String sqlProcess) {
        String resp = "";
        String myoutput = null;
        if (sqlProcess != null) {
            String mysql = "SELECT " + sqlProcess + "('0', '" + this.db.getUserID() + "', '')";
            myoutput = this.web.executeFunction(mysql);
        }
        resp = myoutput == null ? "{\"success\": 0, \"message\": \"Processing has issues\"}" : "{\"success\": 1, \"message\": \"Processing Successfull\"}";
        return resp;
    }

    public String renewProduct() {
        String resp = "";
        String mysql = "SELECT COALESCE(sum(a.cr - a.dr), 0) FROM ((SELECT COALESCE(sum(receipt_amount), 0) as cr, 0::real as dr FROM product_receipts WHERE (is_paid = true) AND (org_id = " + this.db.getUserOrg() + ")) UNION (SELECT 0::real as cr, COALESCE(sum(quantity * price), 0) as dr FROM productions WHERE (org_id = " + this.db.getUserOrg() + "))) as a";
        String bals = this.db.executeFunction(mysql);
        Float bal = new Float(bals);
        String rSql = "SELECT a.product_id, a.product_name, a.details, a.annual_cost, a.expiry_date, a.sum_quantity FROM vws_productions a WHERE (a.is_renewed = false) AND (a.org_id = " + this.db.getUserOrg() + ")";
        BQuery rRs = new BQuery(this.web.getDB(), rSql);
        rRs.moveFirst();
        String productId = rRs.getString("product_id");
        Float annualCost = rRs.getFloat("annual_cost");
        Integer quantity = rRs.getInt("sum_quantity");
        rRs.close();
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1);
        DecimalFormat df = new DecimalFormat("##########.#");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String calS = sdf.format(cal.getTime());
        if (annualCost.floatValue() * (float)quantity.intValue() <= bal.floatValue()) {
            String updStr = "UPDATE productions SET is_renewed = true WHERE (is_renewed = false) AND (a.org_id = " + this.db.getUserOrg() + ") AND (product_id = " + productId + ")";
            this.db.executeQuery(updStr);
            String insSql = "INSERT INTO productions(product_id, entity_id, org_id, quantity, price, expiry_date) VALUES (" + productId + "," + this.db.getUserID() + "," + this.db.getUserOrg() + "," + quantity.toString() + "," + df.format(annualCost) + ", '" + calS + "')";
            this.db.executeQuery(insSql);
            resp = "{\"success\": 0, \"message\": \"Processing has issues\"}";
        } else {
            resp = "{\"success\": 1, \"message\": \"Your balance is " + bals + " which not sufficent for purchase\"}";
        }
        return resp;
    }

    public String buyProduct(String productId, String units) {
        String resp = "";
        String mysql = "SELECT COALESCE(sum(a.cr - a.dr), 0) FROM ((SELECT COALESCE(sum(receipt_amount), 0) as cr, 0::real as dr FROM product_receipts WHERE (is_paid = true) AND (org_id = " + this.db.getUserOrg() + ")) UNION (SELECT 0::real as cr, COALESCE(sum(quantity * price), 0) as dr FROM productions WHERE (org_id = " + this.db.getUserOrg() + "))) as a";
        String bals = this.db.executeFunction(mysql);
        System.out.println("BASE 2020 : " + bals);
        Float bal = new Float(bals);
        mysql = "SELECT product_id, product_name, is_singular, align_expiry, is_montly_bill, montly_cost, is_annual_bill, annual_cost, details FROM products WHERE product_id = " + productId;
        BQuery rs = new BQuery(this.db, mysql);
        rs.moveFirst();
        mysql = "SELECT production_id, product_id, product_name, is_renewed, quantity, price, amount, expiry_date FROM vw_productions WHERE (is_renewed = false) AND (org_id = " + this.web.getOrgID() + ") AND (product_id = " + rs.getString("product_id") + ") ORDER BY production_id desc";
        BQuery rsa = new BQuery(this.db, mysql);
        Float annualCost = rs.getFloat("annual_cost");
        Float buyUnits = new Float(units);
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1);
        if (rs.getBoolean("align_expiry").booleanValue() && rsa.moveFirst()) {
            Date expiryDate = rsa.getDate("expiry_date");
            long diff = cal.getTimeInMillis() - expiryDate.getTime();
            if (diff > 0L) {
                annualCost = Float.valueOf(annualCost.floatValue() * (float)(366L - (diff /= 86400000L)) / 366.0f);
                cal.setTime(expiryDate);
            }
            System.out.println("expiry date " + rsa.getDate("expiry_date"));
            System.out.println("expiry diff " + diff);
            System.out.println("expiry cost " + annualCost);
        }
        DecimalFormat df = new DecimalFormat("##########.#");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String calS = sdf.format(cal.getTime());
        if (annualCost.floatValue() * buyUnits.floatValue() <= bal.floatValue()) {
            String insSql = "INSERT INTO productions(product_id, entity_id, org_id, quantity, price, expiry_date) VALUES (" + productId + "," + this.db.getUserID() + "," + this.db.getUserOrg() + "," + units + "," + df.format(annualCost) + ", '" + calS + "')";
            this.db.executeQuery(insSql);
            resp = "{\"success\": 0, \"message\": \"Processing has issues\"}";
        } else {
            resp = "{\"success\": 1, \"message\": \"Your balance is " + bals + " which not sufficent for purchase\"}";
        }
        rs.close();
        rsa.close();
        return resp;
    }

    public String tableViewUpdate(HttpServletRequest request) {
        String resp = "{\"error\": false, \"message\": \"Updated records\"}";
        BElement view = this.web.getView();
        String jsonField = request.getParameter("jsonfield");
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonField));
        JsonArray jFields = jsonReader.readArray();
        for (int i = 0; i < jFields.size(); ++i) {
            JsonObject jField = jFields.getJsonObject(i);
            String upSql = "UPDATE " + view.getAttribute("updatetable") + " SET " + jField.getString("field_name") + " = '" + jField.getString("field_value") + "' WHERE " + view.getAttribute("keyfield") + " = '" + jField.getString("key_id") + "';";
            System.out.println("BASE 1025 : " + upSql);
            this.web.executeQuery(upSql);
        }
        return resp;
    }

    public String jsGrid(String fnct, HttpServletRequest request) {
        String resp = "";
        BElement view = this.web.getView();
        if (request.getParameter("viewno") == null) {
            return resp;
        }
        Integer viewNo = new Integer(request.getParameter("viewno"));
        BElement SubView = view.getElement(viewNo);
        System.out.println("viewno = " + viewNo);
        System.out.println(SubView);
        HashMap<String, String[]> reqParams = new HashMap<String, String[]>();
        Enumeration e = request.getParameterNames();
        String keyField = null;
        while (e.hasMoreElements()) {
            String elName = (String)e.nextElement();
            reqParams.put(elName, request.getParameterValues(elName));
            if (!elName.equals("keyfield")) continue;
            keyField = request.getParameter(elName);
        }
        String linkData = null;
        int vds = this.web.getViewData().size();
        if (vds > 2) {
            linkData = this.web.getViewData().get(vds - 1);
        }
        if ("jsinsert".equals(fnct)) {
            BQuery rs = new BQuery(this.db, SubView, null, null, false);
            rs.recAdd();
            if (linkData != null && SubView.getAttribute("linkfield") != null) {
                rs.updateField(SubView.getAttribute("linkfield"), linkData);
            }
            rs.updateFields(reqParams, this.web.getViewData(), request.getRemoteAddr(), linkData);
            resp = rs.getRowJSON();
            rs.close();
        } else if ("jsupdate".equals(fnct)) {
            String whereSql = SubView.getAttribute("keyfield") + " = '" + keyField + "'";
            BQuery rs = new BQuery(this.db, SubView, whereSql, null, false);
            rs.moveFirst();
            rs.recEdit();
            rs.updateFields(reqParams, this.web.getViewData(), request.getRemoteAddr(), "");
            rs.refresh();
            rs.moveFirst();
            resp = rs.getRowJSON();
            rs.close();
        } else if ("jsdelete".equals(fnct)) {
            String whereSql = SubView.getAttribute("keyfield") + " = '" + keyField + "'";
            BQuery rs = new BQuery(this.db, SubView, whereSql, null, false);
            rs.moveFirst();
            rs.recDelete();
            rs.close();
            resp = "{}";
        }
        return resp;
    }

    public String attendance(HttpServletRequest request) {
        String resp = "";
        String myOutput = null;
        System.out.println("BASE 2020 : ");
        String jsonField = request.getParameter("json");
        if (jsonField != null) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonField));
            JsonObject jObj = jsonReader.readObject();
            String mySql = "SELECT add_access_logs(" + this.db.getUserID() + "," + jObj.getString("log_type") + ",'" + jObj.getString("log_in_out") + "', '" + request.getRemoteAddr() + "', '" + jObj.getJsonNumber("lat").toString() + "," + jObj.getJsonNumber("long").toString() + "'::point);";
            System.out.println("BASE 2030 : " + mySql);
            myOutput = this.db.executeFunction(mySql);
        }
        if (myOutput == null) {
            resp = "{\"success\": 0, \"message\": \"Attendnace not added\"}";
        } else {
            String lWhere = "(log_time_out is null)";
            if (!myOutput.equals("0")) {
                lWhere = "(access_log_id = " + myOutput + ")";
            }
            BQuery alRs = new BQuery(this.db, this.web.getView().getElementByName("ATTENDANCE").getElementByName("ACCESSLOG"), lWhere, null);
            resp = alRs.getJSON();
            alRs.close();
        }
        System.out.println("BASE 3120 : " + resp);
        return resp;
    }

    public String tasks(HttpServletRequest request) {
        String resp = "";
        String myOutput = null;
        String jsonField = request.getParameter("json");
        System.out.println("BASE 2120 : " + jsonField);
        if (jsonField != null) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonField));
            JsonObject jObj = jsonReader.readObject();
            String mySql = null;
            mySql = "start".equals(jObj.getString("task")) ? "SELECT add_timesheet(" + jObj.getString("task_name") + ",true, '" + jObj.getString("task_narrative") + "');" : "SELECT add_timesheet(" + jObj.getString("timesheet_id") + ",false, '');";
            System.out.println("BASE 2130 : " + mySql);
            myOutput = this.db.executeFunction(mySql);
        }
        if (myOutput == null) {
            resp = "{\"success\": 0, \"message\": \"Task not added\"}";
        } else {
            BQuery alRs = new BQuery(this.db, this.web.getView().getElementByName("TASK").getElementByName("TIMESHEET"), null, null);
            resp = alRs.getJSON();
            alRs.close();
        }
        System.out.println("BASE 2140 : " + resp);
        return resp;
    }
}

