/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

@WebService
public class BWebService {
    Logger log = Logger.getLogger(BWebService.class.getName());
    List<String> allowedTables;

    public BWebService() {
        try {
            InitialContext initCtx = new InitialContext();
            Context context = (Context)initCtx.lookup("java:comp/env");
        }
        catch (NamingException ex) {
            System.err.println("Cannot pick on the name : " + ex);
        }
    }

    @WebMethod
    public String addWsData(String xmldata, String verification) {
        System.out.println("WEB SERVICE GET DATA : " + verification);
        System.out.println(xmldata);
        this.allowedTables = new ArrayList<String>();
        String key = "baratonElections";
        if (key.equals(verification)) {
            return this.addData(xmldata);
        }
        return "<ERROR>100</ERROR>";
    }

    @WebMethod
    public String getWsData(String xmldata, String verification) {
        System.out.println("WEB SERVICE GET DATA : " + verification);
        System.out.println(xmldata);
        this.allowedTables = new ArrayList<String>();
        this.allowedTables.add("ws_students");
        this.allowedTables.add("ws_qstudents");
        String key = "baratonElections";
        if (key.equals(verification)) {
            return this.getData(xmldata);
        }
        return "<ERROR>100</ERROR>";
    }

    String addData(String xmldata) {
        BXML xml = new BXML(xmldata, true);
        BElement root = xml.getRoot();
        String result = "0";
        BDB db = new BDB("java:/comp/env/jdbc/database");
        for (BElement el : root.getElements()) {
            if (!this.allowedTables.contains(el.getAttribute("table"))) continue;
            if (el.getName().equals("TRANSFER")) {
                result = this.getTransfer(db, el);
                continue;
            }
            if (!el.getName().equals("FUNCTION")) continue;
            result = this.getFunction(db, el);
        }
        db.close();
        return result;
    }

    String getData(String xmldata) {
        BXML xml = new BXML(xmldata, true);
        BElement root = xml.getRoot();
        StringBuffer mydata = new StringBuffer();
        mydata.append("<transaction>\n");
        BDB db = new BDB("java:/comp/env/jdbc/database");
        for (BElement el : root.getElements()) {
            if (!this.allowedTables.contains(el.getAttribute("table"))) continue;
            BQuery query = new BQuery(db, el, null, null, false);
            String result = "";
            int ColNum = query.getColumnCount();
            boolean i = true;
            boolean j = true;
            result = result + "\t<transfer name=\"" + el.getAttribute("name") + "\">\n";
            while (query.moveNext()) {
                result = result + "\t\t<record item=\"" + this.cleanData(query.getString(el.getAttribute("keyfield"))) + "\">\n";
                for (BElement ell : el.getElements()) {
                    String cname = ell.getValue();
                    result = result + "\t\t\t<" + cname + ">" + this.cleanData(query.getString(cname)) + "</" + cname + ">\n";
                }
                result = result + "\t\t</record>\n";
            }
            result = result + "\t</transfer>\n";
            mydata.append(result);
            query.close();
        }
        mydata.append("</transaction>");
        this.log.fine(mydata.toString());
        db.close();
        return mydata.toString();
    }

    String getTransfer(BDB db, BElement el) {
        String result = "2";
        String mysql = "SELECT " + el.getAttribute("keyfield") + " FROM " + el.getAttribute("table");
        mysql = mysql + " WHERE " + el.getAttribute("keyfield") + " = '" + el.getFirst().getValue() + "'";
        this.log.info("Check for duplicate record : " + mysql);
        String dataExists = db.executeFunction(mysql);
        if (dataExists == null) {
            mysql = "INSERT INTO " + el.getAttribute("table") + " (";
            String mydata = "";
            String a = "";
            for (BElement ell : el.getElements()) {
                mysql = mysql + a + ell.getName();
                mydata = ell.getValue().equals("") ? mydata + a + "null" : mydata + a + "'" + ell.getValue() + "'";
                a = ", ";
            }
            mysql = mysql + ") VALUES (" + mydata + ")";
            this.log.fine(mysql);
            result = db.executeQuery(mysql);
            if (result == null) {
                result = "0";
            }
        } else {
            result = "1";
        }
        return result;
    }

    String getFunction(BDB db, BElement el) {
        String result = "0";
        String mysql = el.getValue();
        System.out.println(mysql);
        db.executeQuery(mysql);
        return result;
    }

    String cleanData(String mydata) {
        if (mydata == null) {
            return mydata;
        }
        String sa = mydata.trim();
        sa = sa.replaceAll("&", "&amp;");
        sa = sa.replaceAll("\"", "&quot;");
        sa = sa.replaceAll("'", "&apos;");
        sa = sa.replaceAll("<", "&lt;");
        sa = sa.replaceAll(">", "&gt;");
        return sa;
    }
}

