/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.baraza.DB.BCrossTab;
import org.baraza.DB.BDB;
import org.baraza.DB.BJSONQuery;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTranslations;
import org.baraza.DB.BUser;
import org.baraza.DB.BWebBody;
import org.baraza.com.BLicense;
import org.baraza.reports.BWebReport;
import org.baraza.utils.BDateFormat;
import org.baraza.utils.BWebUtils;
import org.baraza.utils.BWebdav;
import org.baraza.utils.Bio;
import org.baraza.web.BAccordion;
import org.baraza.web.BDrillWeb;
import org.baraza.web.BWebDashboard;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;
import org.json.JSONArray;
import org.json.JSONObject;

public class BWeb {
    Logger log = Logger.getLogger(BWeb.class.getName());
    BDB db = null;
    BElement root = null;
    BElement view = null;
    HttpSession webSession = null;
    ServletContext context = null;
    BTranslations translations = null;
    List<BElement> views;
    List<String> viewKeys;
    List<String> viewData;
    Map<String, String> params;
    Map<String, String> dashboardItems;
    boolean selectAll = false;
    boolean isLicense = true;
    boolean isExpired = false;
    String[] deskTypes = new String[]{"ACCORDION", "CROSSTAB", "DASHBOARD", "DIARY", "FILES", "FILTER", "FORM", "FORMVIEW", "GRID", "JASPER", "TABLEVIEW"};
    String viewKey = null;
    String dataItem = null;
    String userID = null;
    String wheresql = null;
    String sortby = null;
    String mainPage = "index.jsp";
    String comboField = null;
    String saveMsg = "";
    String accordionJs = "";
    String pictureURL = "";
    String pictureField = "";

    public BWeb(String dbconfig, String xmlfile, ServletContext context) {
        this.context = context;
        if (xmlfile == null) {
            return;
        }
        Bio io = new Bio();
        if (!io.FileExists(xmlfile)) {
            return;
        }
        BXML xml = new BXML(xmlfile, false);
        if (xml.getDocument() == null) {
            this.log.severe("XML loading file error");
        } else {
            BElement audit;
            BElement configs;
            this.root = xml.getRoot();
            this.db = this.root.getAttribute("dbclass") != null ? new BDB(this.root) : (this.root.getAttribute("dbconfig") != null ? new BDB(this.root.getAttribute("dbconfig")) : new BDB(dbconfig));
            if (this.root.getAttribute("readonly", "false").equals("true")) {
                this.db.setReadOnly(true);
            }
            if ((configs = this.root.getElementByName("CONFIGS")) != null && (audit = configs.getElementByName("AUDIT")) != null) {
                this.db.setFullAudit(audit);
            }
            this.db.setOrgID(this.root.getAttribute("org"));
            if (context.getAttribute("translations") != null) {
                this.translations = (BTranslations)context.getAttribute("translations");
            }
        }
        if (this.db.getDB() == null) {
            this.log.severe("Login error");
        }
    }

    public void init(HttpServletRequest request) {
        String expStr;
        String[] sv;
        if (this.root == null || this.db == null) {
            return;
        }
        this.setUser(request.getRemoteAddr(), request.getRemoteUser());
        this.views = new ArrayList<BElement>();
        this.viewKeys = new ArrayList<String>();
        this.viewData = new ArrayList<String>();
        this.params = new HashMap<String, String>();
        this.dashboardItems = new HashMap<String, String>();
        this.webSession = request.getSession(true);
        this.viewKey = request.getParameter("view");
        if (this.webSession.getAttribute("loadviewkey") != null) {
            this.viewKey = (String)this.webSession.getAttribute("loadviewkey");
            this.webSession.removeAttribute("loadviewkey");
        }
        if (this.viewKey == null && this.webSession.getAttribute("viewkey") != null) {
            this.viewKey = (String)this.webSession.getAttribute("viewkey");
        }
        if (this.viewKey == null) {
            this.viewKey = this.db.getStartView();
        }
        if (this.viewKey == null) {
            this.viewKey = "1:0";
        }
        this.webSession.setAttribute("viewkey", (Object)this.viewKey);
        this.dataItem = request.getParameter("data");
        if (BWebUtils.checkInjection(this.dataItem)) {
            this.dataItem = "";
        }
        if (this.webSession.getAttribute("loaddata") != null) {
            this.dataItem = (String)this.webSession.getAttribute("loaddata");
            this.webSession.removeAttribute("loaddata");
        }
        if (this.dataItem != null) {
            this.webSession.setAttribute("d" + this.viewKey, (Object)this.dataItem);
        } else if (this.webSession.getAttribute("d" + this.viewKey) != null) {
            this.dataItem = (String)this.webSession.getAttribute("d" + this.viewKey);
        }
        if (this.root.getElementByKey(this.viewKey.split(":")[0]) == null) {
            this.viewKey = "1:0";
        }
        for (String svs : sv = this.viewKey.split(":")) {
            this.viewKeys.add(svs);
        }
        this.views.add(this.root.getElementByKey(sv[0]));
        this.viewData.add("");
        if (this.views.get(0).getAttribute("access", "role").equals("role") && this.checkRole(sv[0]) == 2) {
            this.viewKey = this.db.getStartView();
            this.setView(request, this.viewKey);
            return;
        }
        String dk = this.viewKeys.get(0) + ":";
        for (int i = 1; i < sv.length; ++i) {
            dk = dk + this.viewKeys.get(i);
            String sItems = (String)this.webSession.getAttribute("d" + dk);
            if (sItems == null) {
                sItems = "";
            }
            int subNo = Integer.valueOf(sv[i]);
            this.views.add(this.views.get(i - 1).getSub(subNo));
            this.viewData.add(sItems);
            dk = dk + ":";
        }
        this.view = this.views.get(this.views.size() - 1);
        if (this.webSession.getAttribute("mainpage") != null) {
            this.mainPage = (String)this.webSession.getAttribute("mainpage");
        } else {
            this.webSession.setAttribute("mainpage", (Object)"index.jsp");
        }
        if (this.root.getAttribute("billing", "false").equals("true") && this.db.executeFunction(expStr = "SELECT org_id FROM orgs WHERE ((expiry_date is null) or (expiry_date >= current_date)) AND (org_id = " + this.db.getUserID() + ")") == null) {
            this.isExpired = true;
        }
        this.getParams();
    }

    public void setView(HttpServletRequest request, String newview) {
        String[] sv;
        this.views = new ArrayList<BElement>();
        this.viewKeys = new ArrayList<String>();
        this.viewData = new ArrayList<String>();
        this.dashboardItems = new HashMap<String, String>();
        this.webSession = request.getSession(true);
        this.viewKey = newview;
        this.webSession.setAttribute("viewkey", (Object)this.viewKey);
        this.dataItem = request.getParameter("data");
        if (BWebUtils.checkInjection(this.dataItem)) {
            this.dataItem = "";
        }
        if (this.dataItem != null) {
            this.webSession.setAttribute("d" + this.viewKey, (Object)this.dataItem);
        } else if (this.webSession.getAttribute("d" + this.viewKey) != null) {
            this.dataItem = (String)this.webSession.getAttribute("d" + this.viewKey);
        }
        for (String svs : sv = this.viewKey.split(":")) {
            this.viewKeys.add(svs);
        }
        this.views.add(this.root.getElementByKey(this.viewKeys.get(0)));
        this.viewData.add("");
        String dk = this.viewKeys.get(0) + ":";
        for (int i = 1; i < sv.length; ++i) {
            dk = dk + this.viewKeys.get(i);
            String sItems = (String)this.webSession.getAttribute("d" + dk);
            if (sItems == null) {
                sItems = "";
            }
            int subNo = Integer.valueOf(sv[i]);
            this.views.add(this.views.get(i - 1).getSub(subNo));
            this.viewData.add(sItems);
            dk = dk + ":";
        }
        this.view = this.views.get(this.views.size() - 1);
        this.getParams();
    }

    public int checkRole(String deskKey) {
        if (this.root == null || this.db == null) {
            return 0;
        }
        if (this.db.getUser() == null) {
            return 1;
        }
        int toShow = 0;
        if (this.db.getUser().getSuperUser()) {
            toShow = 1;
        } else {
            BElement mel = this.root.getFirst();
            toShow = this.checkRole(mel, deskKey);
        }
        return toShow;
    }

    public int checkRole(BElement mel, String deskKey) {
        int toShow = 0;
        for (BElement smel : mel.getElements()) {
            if (toShow != 0) continue;
            if (smel.isLeaf()) {
                if (!deskKey.equals(smel.getValue())) continue;
                boolean hasAccess = this.checkAccess(smel.getAttribute("role"), smel.getAttribute("access"));
                if (hasAccess) {
                    return 1;
                }
                return 2;
            }
            toShow = this.checkRole(smel, deskKey);
            if (toShow == 0) continue;
            boolean hasAccess = this.checkAccess(smel.getAttribute("role"), smel.getAttribute("access"));
            if (hasAccess) {
                return toShow;
            }
            return 2;
        }
        return toShow;
    }

    public void setUser(String userIP, String userName) {
        if (this.db != null) {
            if (userName == null) {
                this.db.newUser(userIP, "root");
            } else {
                this.db.setUser(userIP, userName);
                String authTable = this.root.getAttribute("auth.table");
                if (authTable != null) {
                    String authId = this.root.getAttribute("auth.id");
                    String authName = this.root.getAttribute("auth.name");
                    this.db.setUser(authTable, authId, authName, userName);
                }
            }
            this.userID = this.db.getUserID();
        }
    }

    public void newUser(String userIP, String userName) {
        if (this.db != null) {
            if (userName == null) {
                userName = "root";
            }
            this.db.newUser(userIP, userName);
            this.userID = this.db.getUserID();
        }
    }

    public void setMainPage(String mainPage) {
        this.mainPage = mainPage;
        this.webSession.setAttribute("mainpage", (Object)mainPage);
    }

    public String getMenu() {
        if (this.root == null || this.db == null) {
            return "";
        }
        BElement mel = this.root.getFirst();
        String mymenu = "\t<ul class='page-sidebar-menu ' data-keep-expanded='false' data-auto-scroll='true' data-slide-speed='200'>\n";
        if (this.root.getAttribute("dashboard", "true").equals("true")) {
            mymenu = mymenu + "\t\t<li class='start'>\n";
            mymenu = mymenu + "\t\t\t<a href='" + this.mainPage + "?view=1:0'>\n";
            mymenu = mymenu + "\t\t\t<i class='icon-home'></i>\n";
            mymenu = mymenu + "\t\t\t<span class='title'>Dashboard</span>\n";
            mymenu = mymenu + "\t\t\t</a>\n";
            mymenu = mymenu + "\t\t</li>\n";
        }
        mymenu = mymenu + this.getSubMenu(mel, 0);
        mymenu = mymenu + "\t</ul>\n";
        return mymenu;
    }

    public String getSubMenu(BElement mel, int level) {
        String submenu = "";
        boolean toShow = true;
        for (BElement smel : mel.getElements()) {
            toShow = this.checkAccess(smel.getAttribute("role"), smel.getAttribute("access"));
            String bodypage = smel.getAttribute("page", this.mainPage);
            String blankpage = smel.getAttribute("blankpage", "");
            if (blankpage.equals("true")) {
                blankpage = " target=\"_blank\" ";
            }
            if (!toShow) continue;
            if (smel.isLeaf()) {
                String icon = smel.getAttribute("icon", "fa fa-arrow-right");
                String link = "";
                if (smel.getAttribute("xml") != null) {
                    link = "<a href=\"" + bodypage + "?xml=" + smel.getAttribute("xml") + "&view=1:0\"" + blankpage + ">";
                    link = link + " <i class='" + icon + "'></i> ";
                } else if (smel.getAttribute("url") != null) {
                    link = "<a href=\"" + smel.getAttribute("url") + "\"" + blankpage + ">";
                    link = link + " <i class='" + icon + "'></i> ";
                } else {
                    link = "<a href=\"" + bodypage + "?view=" + smel.getValue() + ":0\"" + blankpage + ">";
                    link = link + " <i class='" + icon + "'></i> ";
                }
                link = level == 0 ? link + "<span class='title'>" + smel.getAttribute("name") + "</span></a>" : link + "<span>" + smel.getAttribute("name") + "</span></a>";
                submenu = this.viewKeys.get(0).equals(smel.getValue()) ? submenu + "\t\t<li class='active'>\n" : submenu + "\t\t<li>\n";
                submenu = submenu + "\t\t\t" + link + "\n";
                submenu = submenu + "\t\t</li>\n";
                continue;
            }
            submenu = this.locateMenu(smel, this.viewKeys.get(0)) ? submenu + "\t<li class='active open'>\n" : submenu + "\t<li>\n";
            submenu = submenu + "\t\t<a href='javascript:;'>";
            submenu = submenu + "<i class='" + smel.getAttribute("icon", "icon-list") + "'></i>";
            submenu = submenu + "<span class='title'>" + smel.getAttribute("name") + "</span>";
            submenu = submenu + "<span class='arrow'></span>";
            submenu = submenu + "</a>\n";
            submenu = submenu + "\t\t<ul class='sub-menu'>\n" + this.getSubMenu(smel, level + 1) + "</ul>\n";
            submenu = submenu + "\t</li>\n";
        }
        return submenu;
    }

    public boolean locateMenu(BElement smel, String key) {
        boolean isMn = false;
        for (BElement mie : smel.getElements()) {
            if (mie.isLeaf()) {
                if (!mie.getValue().equals(key)) continue;
                return true;
            }
            isMn = this.locateMenu(mie, key);
        }
        return isMn;
    }

    public void getParams() {
        if (this.views == null) {
            return;
        }
        for (int i = 0; i < this.views.size() - 1; ++i) {
            BElement desk = this.views.get(i);
            String keyV = "";
            for (int k = 0; k <= i; ++k) {
                keyV = keyV + this.viewKeys.get(k) + ":";
            }
            String keyD = this.viewData.get(i + 1);
            this.getParams(desk, keyD);
        }
    }

    public void getParams(BElement elParam, String paramKey) {
        if (elParam == null) {
            return;
        }
        String paramStr = elParam.getAttribute("params");
        if (paramStr != null && !paramKey.equals("!new!")) {
            String paramsql = "SELECT " + paramStr;
            paramsql = paramsql + " FROM " + elParam.getAttribute("table");
            paramsql = paramsql + " WHERE (" + elParam.getAttribute("keyfield") + " = '" + paramKey + "')";
            this.params.putAll(this.db.getFieldsData(paramStr.split(","), paramsql));
        }
    }

    public String getTabs() {
        if (this.root == null || this.db == null) {
            return "";
        }
        String tabs = "";
        for (int i = 0; i < this.views.size() - 1; ++i) {
            tabs = tabs + this.getTabs(i);
        }
        return tabs;
    }

    /*
     * WARNING - void declaration
     */
    public String getTabs(Integer i) {
        BElement desk = this.views.get(i);
        String keyV = "";
        for (int k = 0; k <= i; ++k) {
            keyV = keyV + this.viewKeys.get(k) + ":";
        }
        String keyD = this.viewData.get(i + 1);
        String tabs = "\t\t<ul class='nav nav-tabs'>\n";
        Integer j = 0;
        for (BElement el : desk.getElements()) {
            String viewFilter;
            String elName = el.getName();
            if (Arrays.binarySearch(this.deskTypes, elName) < 0) continue;
            boolean show = true;
            if (keyD.equals("!new!") && !elName.equals("FORM")) {
                show = false;
            }
            if (keyD.equals("!new!") && el.getAttribute("new", "true").equals("false")) {
                show = false;
            }
            if (el.getAttribute("superuser", "false").equals("true")) {
                if (!this.db.getUser().getSuperUser()) {
                    show = false;
                }
            } else if (!this.checkAccess(el.getAttribute("role"), el.getAttribute("access"))) {
                show = false;
            }
            if ((viewFilter = el.getAttribute("viewfilter")) != null) {
                String[] viewFilters;
                for (String vfs : viewFilters = viewFilter.split(",")) {
                    String[] vf = vfs.split("=");
                    if (vf[1].equals(this.params.get(vf[0]))) continue;
                    show = false;
                }
            }
            if (show) {
                String tabName = el.getAttribute("name");
                if (el.getAttribute("tab.count") != null) {
                    void var13_19;
                    String tcVal;
                    String string = "SELECT " + el.getAttribute("tab.count") + " FROM " + el.getAttribute("table");
                    String tcWhere = null;
                    if (el.getAttribute("noorg") == null) {
                        tcWhere = this.db.getOrgWhere(null);
                    }
                    if (el.getAttribute("user") != null) {
                        tcWhere = tcWhere == null ? " WHERE " : tcWhere + " AND ";
                        tcWhere = tcWhere + el.getAttribute("user") + " = " + this.db.getUserID();
                    }
                    if (el.getAttribute("linkfield") != null) {
                        tcWhere = tcWhere == null ? " WHERE " : tcWhere + " AND ";
                        tcWhere = tcWhere + el.getAttribute("linkfield") + " = " + keyD;
                    }
                    if (el.getAttribute("where") != null) {
                        tcWhere = tcWhere == null ? " WHERE " : tcWhere + " AND ";
                        tcWhere = tcWhere + el.getAttribute("where");
                    }
                    if (tcWhere != null) {
                        String string2 = string + tcWhere;
                    }
                    if ((tcVal = this.db.executeFunction((String)var13_19)) != null) {
                        tabName = tabName + " <span class=\"badge badge-success\">" + tcVal + "</span>";
                    }
                }
                tabs = this.viewKeys.get(i + 1).equals(j.toString()) ? tabs + "\t\t\t<li class='active'>" : tabs + "\t\t\t<li>";
                tabs = tabs + "<a href='?view=" + keyV + j.toString();
                tabs = keyD.equals("!new!") && elName.equals("FORM") ? tabs + "&data=" + keyD + "'>New " + tabName + "</a></li>\n" : (elName.equals("FORM") && !el.getAttribute("edit", "true").equals("false") ? tabs + "&data=" + keyD + "'>Edit " + tabName + "</a></li>\n" : tabs + "&data=" + keyD + "'>" + tabName + "</a></li>\n");
            }
            Integer n = j;
            Integer object = j = Integer.valueOf(j + 1);
        }
        tabs = tabs + "\t\t</ul>\n";
        return tabs;
    }

    public String getButtons() {
        if (this.root == null || this.db == null) {
            return "";
        }
        String buttons = "<div class='actions'>\n";
        boolean showButtons = false;
        if (this.view.getName().equals("GRID")) {
            if (this.view.getAttribute("display", "grid").equals("grid")) {
                showButtons = true;
            }
            if (this.view.getAttribute("buttons", "noshow").equals("show")) {
                showButtons = true;
            }
        }
        if (showButtons) {
            int j = -1;
            int fv = -1;
            boolean hasForm = false;
            for (BElement el : this.view.getElements()) {
                String elName = el.getName();
                if (Arrays.binarySearch(this.deskTypes, elName) >= 0) {
                    ++j;
                }
                if (elName.equals("FORM") && el.getAttribute("new", "true").equals("true")) {
                    if (!hasForm) {
                        fv = j;
                    }
                    hasForm = true;
                }
                if (!elName.equals("ACCORDION") || !el.getAttribute("new", "true").equals("true")) continue;
                for (BElement ell : el.getElements()) {
                    if (!ell.getName().equals("FORM") || !ell.getAttribute("new", "true").equals("true")) continue;
                    if (!hasForm) {
                        fv = j;
                    }
                    hasForm = true;
                }
            }
            String did = "";
            if (this.dataItem != null) {
                did = "&data=" + this.dataItem;
            }
            boolean newShow = true;
            if (this.view.getAttribute("new.show") != null) {
                String tcVal;
                String tcSql = "SELECT " + this.view.getAttribute("new.show") + " FROM " + this.view.getAttribute("table");
                String tcWhere = null;
                if (this.view.getAttribute("noorg") == null) {
                    tcWhere = this.db.getOrgWhere(null);
                }
                if (this.view.getAttribute("user") != null) {
                    tcWhere = tcWhere == null ? " WHERE " : tcWhere + " AND ";
                    tcWhere = tcWhere + this.view.getAttribute("user") + " = " + this.db.getUserID();
                }
                if (this.view.getAttribute("linkfield") != null && this.dataItem != null) {
                    tcWhere = tcWhere == null ? " WHERE " : tcWhere + " AND ";
                    tcWhere = tcWhere + this.view.getAttribute("linkfield") + " = " + this.dataItem;
                }
                if (this.view.getAttribute("where") != null) {
                    tcWhere = tcWhere == null ? " WHERE " : tcWhere + " AND ";
                    tcWhere = tcWhere + this.view.getAttribute("where");
                }
                if (tcWhere != null) {
                    tcSql = tcSql + tcWhere;
                }
                if ((tcVal = this.db.executeFunction(tcSql)) == null) {
                    newShow = false;
                } else if (tcVal.equals("false")) {
                    newShow = false;
                }
            }
            if (hasForm && newShow) {
                String newBtn = this.view.getAttribute("new.button", "New");
                buttons = buttons + "<a class='btn blue btn-sm' title='Add New' href='?view=" + this.viewKey + ":" + String.valueOf(fv) + "&data=!new!'><i class='fa fa-plus'></i>   " + newBtn + "</a>\n";
            }
            buttons = buttons + "<a class='btn green btn-sm' href='?view=" + this.viewKey + did + "&refresh=true'><i class='fa fa-refresh'></i>   Refresh</a>\n";
            if (this.view.getAttribute("grid.export", "true").equals("true")) {
                buttons = buttons + "<a class='btn green btn-sm' target='_blank' href='grid_export?view=" + this.viewKey + did + "&action=export'><i class='fa fa-file-excel-o'></i>   Export</a>\n";
            }
            if (this.view.getAttribute("grid.print", "false").equals("true")) {
                buttons = buttons + "<a class='btn green btn-sm' target='_blank' href='b_print.jsp?view=" + this.viewKey + did + "&action=print'><i class='fa fa-print'></i>   Print</a>\n";
            }
            buttons = buttons + "<a class='btn btn-circle btn-icon-only btn-default btn-sm fullscreen' href='javascript:;' data-original-title='' title=''></a>";
        }
        if (this.view.getName().equals("CROSSTAB")) {
            String did = "";
            if (this.dataItem != null) {
                did = "&data=" + this.dataItem;
            }
            buttons = buttons + "<a class='btn green btn-sm' target='_blank' href='grid_export?view=" + this.viewKey + did + "&action=export'><i class='fa fa-file-excel-o'></i>   Export</a>\n";
        }
        if (this.view.getName().equals("ACCORDION")) {
            if (this.view.getAttribute("new", "true").equals("true") && "!new!".equals(this.dataItem)) {
                buttons = buttons + "<button class='btn btn-success i_tick icon small' name='process' value='Update'> <i class='fa  fa-save'></i> &nbsp; Save </button>\n";
            }
            if (this.view.getAttribute("edit", "true").equals("true") && !"!new!".equals(this.dataItem)) {
                buttons = buttons + "<button class='btn btn-success i_tick icon small' name='process' value='Update'> <i class='fa  fa-save'></i> &nbsp; Save </button>\n";
            }
            boolean canDel = true;
            if (this.view.getAttribute("delete", "true").equals("false")) {
                canDel = false;
            }
            if ("!new!".equals(this.dataItem)) {
                canDel = false;
            }
            if (canDel && this.view.getAttribute("delete.role") != null && !this.checkAccess(this.view.getAttribute("delete.role"), this.view.getAttribute("access"))) {
                canDel = false;
            }
            if (canDel) {
                buttons = buttons + "<button class='btn btn-danger i_cross icon small' name='process' value='Delete' onclick=\"return confirm('Are you sure you delete?')\"> <i class='fa fa-trash-o'></i> &nbsp; Delete</button>\n";
            }
        }
        if (this.view.getName().equals("TABLEVIEW") && this.view.getAttribute("updatetable") != null) {
            buttons = buttons + "<button type='button' class='btn btn-success i_tick icon small' name='btProcess' id='btProcess' value='Submit'><i class='fa  fa-save'></i> &nbsp; Submit</button>\n";
        }
        if (this.isForm()) {
            buttons = buttons + this.getFormButtons();
        }
        buttons = buttons + "</div>\n";
        return buttons;
    }

    public String getFormButtons() {
        if (this.root == null || this.db == null) {
            return "";
        }
        String buttons = "";
        if (this.view.getName().equals("FORM")) {
            String saveBtn = this.view.getAttribute("save.button", "Save");
            if (this.view.getAttribute("new", "true").equals("true") && "!new!".equals(this.dataItem)) {
                buttons = buttons + "<button class='btn btn-success i_tick icon small' name='process' value='Update'> <i class='fa  fa-save'></i> &nbsp; " + saveBtn + "</button>\n";
            }
            if (this.view.getAttribute("fornew", "false").equals("true")) {
                buttons = buttons + "<button class='btn btn-success i_tick icon small' name='process' value='Update'> <i class='fa  fa-save'></i> &nbsp; " + saveBtn + "</button>\n";
            }
            if (this.view.getAttribute("edit", "true").equals("true") && !"!new!".equals(this.dataItem)) {
                buttons = buttons + "<button class='btn btn-success i_tick icon small' name='process' value='Update'> <i class='fa  fa-save'></i> &nbsp; " + saveBtn + "</button>\n";
            }
            boolean canDel = true;
            if (this.view.getAttribute("delete", "true").equals("false")) {
                canDel = false;
            }
            if (canDel && this.view.getAttribute("delete.role") != null && !this.checkAccess(this.view.getAttribute("delete.role"), this.view.getAttribute("access"))) {
                canDel = false;
            }
            if (canDel && !"!new!".equals(this.dataItem)) {
                buttons = buttons + "<button class='btn btn-danger i_cross icon small' name='process' value='Delete' onclick=\"return confirm('Are you sure you delete?')\"> <i class='fa fa-trash-o'></i> &nbsp; Delete</button>\n";
            }
            buttons = buttons + "<a class='btn btn-circle btn-icon-only btn-default btn-sm fullscreen' href='javascript:;' data-original-title='' title=''></a>";
        }
        return buttons;
    }

    public String getFileButtons(String callPage) {
        String buttons = "";
        if (this.view.getName().equals("FILES") && this.view.getAttribute("new", "true").equals("true")) {
            buttons = "<form id='form' action='" + callPage + "' method='POST'>\n";
            buttons = buttons + "<div class='configuration k-widget k-header' style='width: 500px'>\n";
            buttons = buttons + "<label for='files'>File Upload</label>\n";
            buttons = buttons + "<div>\n<input name=\"files\" id=\"files\" type=\"file\" />\n</div>\n";
            buttons = buttons + "<p><input type=\"submit\" value=\"Submit\" class=\"k-button\" /></p>\n";
            buttons = buttons + "</div>\n";
            buttons = buttons + "</form>\n";
        }
        return buttons;
    }

    public String getFileButtons() {
        String buttons = "";
        if (this.view.getName().equals("FILES") && this.view.getAttribute("new", "true").equals("true")) {
            buttons = "<form id='form' action='.' method='POST'>\n";
            buttons = buttons + "<div class='configuration k-widget k-header' style='width: 500px'>\n";
            buttons = buttons + "<label for='files'>File Upload</label>\n";
            buttons = buttons + "<div>\n<input name=\"files\" id=\"files\" type=\"file\" />\n</div>\n";
            buttons = buttons + "<p><input type=\"submit\" value=\"Submit\" class=\"k-button\" /></p>\n";
            buttons = buttons + "</div>\n";
            buttons = buttons + "</form>\n";
        }
        return buttons;
    }

    public String getDashboard() {
        boolean hasAccess;
        if (this.root == null || this.db == null) {
            return "";
        }
        String body = "";
        String taskList = "";
        BWebDashboard webDashboard = new BWebDashboard(this.db);
        body = body + "<div class='row margin-top-5'>\n";
        for (BElement el : this.view.getElements()) {
            hasAccess = this.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
            if (!hasAccess || !el.getName().equals("TILE")) continue;
            body = body + webDashboard.getTile(el);
        }
        body = body + "</div>\n";
        body = body + "<div class='row'>\n";
        for (BElement el : this.view.getElements()) {
            hasAccess = this.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
            if (!hasAccess || !el.getName().equals("TILELIST")) continue;
            body = body + webDashboard.getTileList(el);
        }
        body = body + "</div>\n";
        for (BElement el : this.view.getElements()) {
            hasAccess = this.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
            if (!hasAccess) continue;
            if (el.getName().equals("ATTENDANCE")) {
                this.dashboardItems.put("ATTENDANCE", "true");
                String lWhere = "(log_time_out is null)";
                BQuery alRs = new BQuery(this.db, el.getElementByName("ACCESSLOG"), lWhere, null);
                this.dashboardItems.put("accessLog", alRs.getJSON());
                alRs.close();
                continue;
            }
            if (!el.getName().equals("TASK")) continue;
            this.dashboardItems.put("TASK", "true");
            BQuery tlRs = new BQuery(this.db, el.getElementByName("TASKLIST"), null, null, false);
            while (tlRs.moveNext()) {
                taskList = taskList + "\n<option value='" + tlRs.getString("task_id") + "'>" + tlRs.getString("task_name") + "</option>";
            }
            this.dashboardItems.put("taskList", taskList);
            tlRs.close();
            BQuery tsRs = new BQuery(this.db, el.getElementByName("TIMESHEET"), null, null);
            this.dashboardItems.put("timeSheet", tsRs.getJSON());
            tsRs.close();
        }
        return body;
    }

    public boolean checkAccess(String role, String access) {
        if (this.db.getUser() == null) {
            return true;
        }
        boolean hasAccess = this.db.getUser().checkAccess(role, access);
        return hasAccess;
    }

    public String getFilterWhere(HttpServletRequest request) {
        String filterName = request.getParameter("filtername");
        String filterType = request.getParameter("filtertype");
        String filterValue = request.getParameter("filtervalue");
        String filterAnd = request.getParameter("filterand");
        String filterOr = request.getParameter("filteror");
        if (filterName == null) {
            return "";
        }
        if (filterType == null) {
            return "";
        }
        if (filterValue == null) {
            return "";
        }
        if (BWebUtils.checkInjection(filterValue)) {
            return "";
        }
        if (filterAnd == null) {
            filterAnd = "false";
        }
        if (filterOr == null) {
            filterOr = "false";
        }
        boolean isField = false;
        for (BElement el : this.view.getElements()) {
            if (!filterName.equals(el.getValue())) continue;
            isField = true;
        }
        if (!isField) {
            return "";
        }
        if ("ilikelike=><<=>=".indexOf(filterType) < 0) {
            return "";
        }
        String filterSN = "F" + this.getViewKey();
        String filterSql = "";
        if (this.db.getDBType() != 1 && filterType.startsWith("ilike")) {
            filterType = "like";
        }
        filterSql = filterType.startsWith("like") ? (this.db.getDBType() == 1 ? filterSql + "(cast(" + filterName + " as varchar) " + filterType + " '%" + filterValue + "%')" : filterSql + "(lower(" + filterName + ") " + filterType + " lower('%" + filterValue + "%'))") : (filterType.startsWith("ilike") ? filterSql + "(cast(" + filterName + " as varchar) " + filterType + " '%" + filterValue + "%')" : filterSql + "(" + filterName + " " + filterType + " '" + filterValue + "')");
        if (this.webSession.getAttribute(filterSN) != null) {
            if (filterAnd.equals("true")) {
                filterSql = (String)this.webSession.getAttribute(filterSN) + " AND " + filterSql;
            } else if (filterOr.equals("true")) {
                filterSql = (String)this.webSession.getAttribute(filterSN) + " OR " + filterSql;
            }
        }
        this.webSession.setAttribute(filterSN, (Object)filterSql);
        if (this.dataItem != null) {
            this.webSession.setAttribute("K" + filterSN, (Object)this.dataItem);
        } else {
            this.webSession.setAttribute("K" + filterSN, (Object)"");
        }
        System.out.println(filterSql + " : " + filterAnd);
        return filterSql;
    }

    public Map<String, String> getWhere(HttpServletRequest request) {
        BElement flt;
        int vds;
        String filterSN;
        HashMap<String, String> whereParams = new HashMap<String, String>();
        String linkData = "";
        String linkParam = null;
        String formLinkData = "";
        this.wheresql = null;
        this.sortby = null;
        BElement sview = null;
        this.comboField = request.getParameter("field");
        if (this.comboField != null) {
            sview = this.view.getElement(this.comboField).getElement(0);
        }
        if (this.webSession.getAttribute(filterSN = "F" + this.viewKey) != null) {
            String filterKSN = "";
            if (this.webSession.getAttribute("K" + filterSN) != null) {
                filterKSN = (String)this.webSession.getAttribute("K" + filterSN);
            }
            String wDataItem = "";
            if (this.dataItem != null) {
                wDataItem = this.dataItem;
            }
            if (filterKSN.equals(wDataItem)) {
                this.wheresql = (String)this.webSession.getAttribute(filterSN);
            } else {
                this.webSession.removeAttribute(filterSN);
            }
            System.out.println("Filter Where :" + filterSN + ": " + this.wheresql);
        }
        if ((vds = this.viewKeys.size()) > 2) {
            linkData = this.viewData.get(vds - 1);
            formLinkData = this.viewData.get(vds - 2);
            if (!linkData.equals("!new!") && this.comboField == null) {
                if (this.view.getName().equals("FORM")) {
                    this.wheresql = this.wheresql != null ? this.wheresql + " AND (" : "(";
                    this.wheresql = this.wheresql + this.view.getAttribute("keyfield") + " = '" + linkData + "')";
                } else if (this.view.getAttribute("linkfield") != null) {
                    this.wheresql = this.wheresql != null ? this.wheresql + " AND (" : "(";
                    this.wheresql = this.wheresql + this.view.getAttribute("linkfield") + " = '" + linkData + "')";
                }
            }
            String paramLinkData = linkData;
            String linkParams = this.view.getAttribute("linkparams");
            if (sview != null) {
                linkParams = sview.getAttribute("linkparams");
                paramLinkData = formLinkData;
            }
            if (linkParams != null) {
                BElement fView = this.views.get(vds - 2);
                if (sview != null) {
                    fView = this.views.get(vds - 3);
                }
                String[] lp = linkParams.split("=");
                linkParam = this.params.get(lp[0].trim());
                this.wheresql = this.wheresql != null ? this.wheresql + " AND (" : "(";
                this.wheresql = linkParam == null ? this.wheresql + lp[1] + " = null)" : this.wheresql + lp[1] + " = '" + linkParam + "')";
            }
        } else if (request.getParameter("filterid") != null) {
            linkData = request.getParameter("filterid");
        } else if (request.getParameter("formlinkdata") != null) {
            formLinkData = request.getParameter("formlinkdata");
            String linkField = this.view.getAttribute("linkfield");
            String linkFnct = this.view.getAttribute("linkfnct");
            String tableFilter = null;
            if (linkField != null && formLinkData != null && this.comboField == null) {
                tableFilter = linkFnct == null ? linkField + " = '" + formLinkData + "'" : linkField + " = " + linkFnct + "('" + formLinkData + "')";
                this.wheresql = this.wheresql != null ? this.wheresql + " AND (" + tableFilter + "')" : "(" + tableFilter + "')";
            }
        }
        if (this.views.size() > 1 && (flt = this.views.get(this.views.size() - 2)).getName().equals("FILTER")) {
            for (BElement sv : flt.getElements()) {
                String myFilterField;
                String myFilter;
                if (sv.getName().equals("FILTERGRID")) {
                    myFilter = sv.getAttribute("filter", "filterid");
                    myFilterField = sv.getAttribute("filterfield", myFilter);
                    this.getFilterParam(myFilter, myFilterField, " = ");
                    continue;
                }
                if (sv.getName().equals("DRILLDOWN")) {
                    myFilter = sv.getAttribute("filter", "filterid");
                    myFilterField = sv.getAttribute("filterfield", myFilter);
                    this.getFilterParam(myFilter, myFilterField, " = ");
                    continue;
                }
                if (!sv.getName().equals("FILTERFORM")) continue;
                for (BElement ffe : sv.getElements()) {
                    String myFilter2 = ffe.getValue();
                    String myFilterField2 = ffe.getAttribute("filterfield", myFilter2);
                    String myFilterType = ffe.getAttribute("filtertype", "=");
                    this.getFilterParam(myFilter2, myFilterField2, myFilterType);
                }
            }
        }
        whereParams.put("linkData", linkData);
        whereParams.put("linkParam", linkParam);
        whereParams.put("formLinkData", formLinkData);
        whereParams.put("wheresql", this.wheresql);
        return whereParams;
    }

    public String getBody(HttpServletRequest request, String reportPath) {
        if (this.root == null || this.db == null) {
            return "";
        }
        String body = "";
        List<String> filterList = this.setFilterParams(request);
        Map<String, String> whereParams = this.getWhere(request);
        String linkData = whereParams.get("linkData");
        String linkParam = whereParams.get("linkParam");
        String formLinkData = whereParams.get("formLinkData");
        int vds = this.viewKeys.size();
        BElement sview = null;
        this.comboField = request.getParameter("field");
        if (this.comboField != null) {
            sview = this.view.getElement(this.comboField).getElement(0);
        }
        if (this.view.getName().equals("GRID")) {
            if (request.getParameter("refresh") != null) {
                this.webSession.removeAttribute("F" + this.viewKey);
            }
            body = body + "\t<div class='table-scrollable'>\n";
            body = body + "\t\t<table id='jqlist' class='table table-striped table-bordered table-hover'></table>\n";
            body = body + "\t\t<div id='jqpager'></div>\n";
            body = body + "\t</div>\n";
        } else if (this.view.getName().equals("FILES")) {
            BWebBody webbody = new BWebBody(this.db, this.view, this.wheresql, this.sortby, this.translations);
            if (this.selectAll) {
                webbody.setSelectAll();
            }
            body = body + webbody.getGrid(this.viewKeys, this.viewData, true, this.viewKey, false);
            webbody.close();
        } else if (this.view.getName().equals("FORMVIEW")) {
            BWebBody webbody = new BWebBody(this.db, this.view, this.wheresql, this.sortby, this.translations);
            if (this.selectAll) {
                webbody.setSelectAll();
            }
            body = body + webbody.getGrid(this.viewKeys, this.viewData, true, this.viewKey, false);
            webbody.close();
        } else if (this.view.getName().equals("TABLEVIEW")) {
            BWebBody webbody = new BWebBody(this.db, this.view, this.wheresql, this.sortby, this.translations);
            if (this.selectAll) {
                webbody.setSelectAll();
            }
            body = body + webbody.getGrid(this.viewKeys, this.viewData, true, this.viewKey, false);
            webbody.close();
        } else if (this.view.getName().equals("ACCORDION")) {
            BAccordion accordion = new BAccordion(this.db, this.view, this.translations);
            body = body + accordion.getAccordion(request, linkData, formLinkData, this.viewData);
            this.accordionJs = accordion.getAccordionJs();
        } else if (this.view.getName().equals("CROSSTAB")) {
            BCrossTab crossTab = new BCrossTab(this.db, this.view, this.wheresql, this.sortby);
            body = body + crossTab.getGrid(this.viewKeys, this.viewData, true, this.viewKey, false);
            crossTab.close();
        } else if (this.view.getName().equals("FORM")) {
            if (this.comboField == null) {
                BWebBody webbody = new BWebBody(this.db, this.view, this.wheresql, this.sortby, this.translations);
                if (vds > 2) {
                    if (linkData.equals("!new!")) {
                        if (this.view.getAttribute("new", "true").equals("true")) {
                            body = webbody.getForm(true, formLinkData, request);
                        }
                    } else if (this.view.getAttribute("edit", "true").equals("true")) {
                        body = body + webbody.getForm(false, formLinkData, request);
                    } else if (this.view.getAttribute("edit", "true").equals("false")) {
                        body = body + webbody.getForm(false, formLinkData, request);
                    }
                } else {
                    body = this.view.getAttribute("foredit") != null ? body + webbody.getForm(false, formLinkData, request) : body + webbody.getForm(true, formLinkData, request);
                }
                webbody.close();
            } else {
                BWebBody webbody = new BWebBody(this.db, sview, this.wheresql, this.sortby, this.translations);
                body = body + webbody.getGrid(this.viewKeys, this.viewData, true, this.viewKey, true);
                webbody.close();
            }
        } else if (this.view.getName().equals("DIARY")) {
            body = body + "<div class='portlet-body'>\n";
            body = body + "\t<div class='row'>\n";
            body = body + "\t\t<div class='col-md-12 col-sm-12'>\n";
            body = body + "\t\t\t<div id='calendar' class='as-toolbar'></div>\n";
            body = body + "\t\t</div>\n";
            body = body + "\t</div>\n";
            body = body + "</div>\n";
        } else if (this.view.getName().equals("JASPER")) {
            String[] lp;
            String lnParam;
            String linkParams;
            BWebReport report = new BWebReport(this.view, this.db.getUserID(), null, request);
            BElement flt = this.views.get(this.views.size() - 2);
            if (!flt.getName().equals("FILTER")) {
                String myFilter = this.view.getAttribute("linkfield", "filterid");
                if (linkParam != null && this.view.getAttribute("linkparams") != null) {
                    linkData = linkParam;
                }
                if (linkData != null) {
                    filterList.add(myFilter);
                }
                this.webSession.setAttribute(myFilter, (Object)linkData);
            }
            if ((linkParams = this.view.getAttribute("linkparams")) != null && (lnParam = this.params.get((lp = linkParams.split("="))[0].trim())) != null) {
                filterList.add(lp[1]);
                this.webSession.setAttribute(lp[1], (Object)lnParam);
            }
            this.webSession.setAttribute("reportfilters", filterList);
            report.setParams(this.webSession);
            body = body + report.getReport(this.db, this.db.getUser(), linkData, request, reportPath);
        } else if (this.view.getName().equals("FILTER")) {
            boolean isFirst = true;
            StringBuilder tabs = new StringBuilder();
            tabs.append("<div class='row'>\n");
            tabs.append("\t<div class='col-md-12'>\n");
            tabs.append("\t\t<div class='tabbable portlet-tabs'>\n");
            tabs.append("\t\t\t<ul class='nav nav-tabs'>\n");
            for (BElement sv : this.view.getElements()) {
                if (!sv.getName().equals("FILTERGRID") && !sv.getName().equals("DRILLDOWN") && !sv.getName().equals("FILTERFORM")) continue;
                if (isFirst) {
                    tabs.append("<li class='active'>\n");
                } else {
                    tabs.append("<li>\n");
                }
                isFirst = false;
                String tab = sv.getAttribute("name");
                tabs.append("<a href='#" + tab.replace(" ", "") + "' data-toggle='tab'>" + tab + " </a></li>\n");
            }
            tabs.append("\t\t\t</ul>\n");
            tabs.append("\t\t</div>\n");
            tabs.append("\t</div>\n");
            tabs.append("</div>\n");
            tabs.append("<div class='tab-content'>\n");
            body = body + tabs.toString();
            boolean wgf = true;
            isFirst = true;
            for (BElement sv : this.view.getElements()) {
                BWebBody webbody;
                String tab = sv.getAttribute("name", "").replace(" ", "");
                if (sv.getName().equals("FILTERGRID")) {
                    body = isFirst ? body + "<div class='tab-pane active' id='" + tab + "'>\n" : body + "<div class='tab-pane' id='" + tab + "'>\n";
                    isFirst = false;
                    webbody = new BWebBody(this.db, sv, this.wheresql, this.sortby, this.translations);
                    body = body + webbody.getGrid(this.viewKeys, this.viewData, wgf, this.viewKey, false);
                    body = body + "</div>";
                    wgf = false;
                    continue;
                }
                if (sv.getName().equals("DRILLDOWN")) {
                    body = isFirst ? body + "<div class='tab-pane active' id='" + tab + "'>\n" : body + "<div class='tab-pane' id='" + tab + "'>\n";
                    isFirst = false;
                    BDrillWeb drillweb = new BDrillWeb();
                    body = body + drillweb.getDrillDown(this.db, sv);
                    body = body + "</div>";
                    continue;
                }
                if (!sv.getName().equals("FILTERFORM")) continue;
                body = isFirst ? body + "<div class='tab-pane active' id='" + tab + "'>\n" : body + "<div class='tab-pane' id='" + tab + "'>\n";
                isFirst = false;
                webbody = new BWebBody(this.db, sv, this.wheresql, this.sortby, this.translations);
                body = body + webbody.getForm(true, formLinkData, request);
                body = body + "</div>";
            }
            body = body + "</div>\n";
            body = body + "<input type='hidden' name='view' value='" + this.viewKey + ":0'/>\n";
            body = body + "<input type='hidden' name='data' value='0'/>\n";
            body = body + "<div><input type='submit' value='Report'/></div>\n";
        }
        return body;
    }

    public String palseValue(BElement el, String myvalue) {
        String dbvalue = null;
        dbvalue = myvalue == null ? null : (el.getName().equals("COMBOBOX") ? myvalue : (el.getName().equals("COMBOLIST") ? myvalue : (el.getName().equals("TEXTDECIMAL") ? myvalue.replace(",", "") : (el.getName().equals("TEXTDATE") ? BDateFormat.parseDate(myvalue, el.getAttribute("dbformat"), this.db.getDBType()) : (el.getName().equals("TEXTTIMESTAMP") ? BDateFormat.parseTimeStamp(myvalue) : (el.getName().equals("SPINTIME") ? BDateFormat.parseTime(myvalue, el.getAttribute("type", "1")) : myvalue))))));
        return dbvalue;
    }

    public List<String> setFilterParams(HttpServletRequest request) {
        BElement flt;
        ArrayList<String> filterList = new ArrayList<String>();
        if (this.views.size() > 1 && (flt = this.views.get(this.views.size() - 2)).getName().equals("FILTER")) {
            for (BElement sv : flt.getElements()) {
                String myValue;
                String myFilter;
                if (sv.getName().equals("FILTERGRID")) {
                    myFilter = sv.getAttribute("filter", "filterid");
                    myValue = request.getParameter(myFilter);
                    filterList.add(myFilter);
                    if (myValue == null) continue;
                    this.webSession.setAttribute(myFilter, (Object)myValue);
                    continue;
                }
                if (sv.getName().equals("DRILLDOWN")) {
                    myFilter = sv.getAttribute("filter", "filterid");
                    myValue = request.getParameter(myFilter);
                    filterList.add(myFilter);
                    if (myValue == null) continue;
                    this.webSession.setAttribute(myFilter, (Object)myValue);
                    continue;
                }
                if (!sv.getName().equals("FILTERFORM")) continue;
                for (BElement ffe : sv.getElements()) {
                    String myFilter2 = ffe.getValue();
                    String myValue2 = request.getParameter(myFilter2);
                    filterList.add(myFilter2);
                    if (myValue2 != null) {
                        this.webSession.setAttribute(myFilter2, (Object)this.palseValue(ffe, myValue2));
                    }
                    System.out.println("BASE 2005 : " + myFilter2 + " : " + myValue2);
                }
            }
        }
        return filterList;
    }

    private void getFilterParam(String myFilter, String myFilterField, String myFilterType) {
        if (this.webSession.getAttribute(myFilter) != null) {
            String myValue = (String)this.webSession.getAttribute(myFilter);
            this.wheresql = this.wheresql != null ? this.wheresql + " AND (" : "(";
            this.wheresql = this.wheresql + myFilterField + " " + myFilterType + " '" + myValue + "')";
        }
    }

    public String getOperations() {
        String operations = null;
        if (this.view.getElementByName("ACTIONS") != null) {
            BElement opt = this.view.getElementByName("ACTIONS");
            operations = "";
            Integer i = 0;
            List<String> userRole = this.db.getUser().getUserRoles();
            for (BElement el : opt.getElements()) {
                boolean hasAccess = this.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
                if (hasAccess) {
                    operations = operations + "<option value='" + i.toString() + "'>" + el.getValue() + "</option>\n";
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        if (operations != null) {
            operations = "<select class='fnctcombobox form-control ' id='operation' name='operation'>" + operations + "</select>";
        }
        return operations;
    }

    public String setOperation(String actionKey, HttpServletRequest request) {
        String mystr = "";
        BElement opt = this.view.getElementByName("ACTION");
        String mysql = "SELECT " + opt.getAttribute("fnct") + "('" + actionKey + "', '" + this.db.getUserID();
        mysql = opt.getAttribute("phase") != null ? mysql + "', '" + opt.getAttribute("phase") + "')" : mysql + "', '0')";
        if (opt.getAttribute("from") != null) {
            mysql = mysql + " " + opt.getAttribute("from");
        }
        this.log.info(mysql);
        String exans = this.db.executeFunction(mysql);
        if (exans == null) {
            mystr = "<div style='color:#FF0000' font-size:14px; font-weight:bold;>" + this.db.getLastErrorMsg() + "</div><br>\n";
        } else {
            String jumpView = opt.getAttribute("jumpview");
            if (jumpView != null) {
                this.viewKey = jumpView;
                this.webSession.setAttribute("viewkey", (Object)jumpView);
                this.webSession.setAttribute("loadviewkey", (Object)jumpView);
                this.init(request);
            }
            mystr = "<div style='color:#00FF00; font-size:14px;'>" + exans + "</div>";
        }
        return mystr;
    }

    public String setOperations(String operation, String ids, HttpServletRequest request) {
        JsonObjectBuilder jshd = Json.createObjectBuilder();
        String mystr = "";
        boolean fnctError = false;
        String mysql = "";
        String[] values = ids.split(",");
        BElement aView = this.view.getElementByName("ACTIONS");
        if (values != null && aView != null) {
            int i = Integer.valueOf(operation);
            BElement el = aView.getElement(i);
            List<String> userRole = this.db.getUser().getUserRoles();
            boolean hasAccess = this.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
            if (hasAccess) {
                for (String value : values) {
                    String sqlErr;
                    boolean sqlOkay = true;
                    if (el.getAttribute("sql_table") != null && (sqlErr = this.checkSQL(el, value)) != null) {
                        sqlOkay = false;
                        fnctError = true;
                        mystr = mystr + sqlErr + "; ";
                    }
                    if (!sqlOkay) continue;
                    String autoKeyID = this.db.insAudit(el.getAttribute("fnct"), value, "FUNCTION");
                    mysql = "SELECT " + el.getAttribute("fnct") + "('" + value + "', '" + this.db.getUserID();
                    if (el.getAttribute("approval") != null) {
                        mysql = mysql + "', '" + el.getAttribute("approval");
                    }
                    mysql = el.getAttribute("phase") != null ? mysql + "', '" + el.getAttribute("phase") : mysql + "', '" + this.viewData.get(this.viewData.size() - 1);
                    if (el.getAttribute("auditid") != null) {
                        mysql = mysql + "', '" + autoKeyID;
                    }
                    mysql = mysql + "') ";
                    if (el.getAttribute("from") != null) {
                        mysql = mysql + " " + el.getAttribute("from");
                    }
                    this.log.info(mysql);
                    String exans = this.db.executeFunction(mysql);
                    if (exans == null) {
                        fnctError = true;
                    }
                    mystr = exans == null ? this.db.getLastErrorMsg() + "; " : mystr + exans + "; ";
                }
                if (fnctError) {
                    jshd.add("msg", mystr);
                    jshd.add("error", true);
                } else {
                    jshd.add("error", false);
                    String jumpView = aView.getAttribute("jumpview");
                    if (jumpView != null) {
                        this.viewKey = jumpView;
                        this.webSession.setAttribute("viewkey", (Object)jumpView);
                        this.webSession.setAttribute("loadviewkey", (Object)jumpView);
                        this.init(request);
                        jshd.add("jump", true);
                    }
                    jshd.add("msg", mystr);
                }
            } else {
                jshd.add("error", true);
                jshd.add("msg", "No access allowed for function");
            }
        }
        JsonObject jsObj = jshd.build();
        System.out.println("BASE 2030 : " + jsObj.toString());
        return jsObj.toString();
    }

    public String checkSQL(BElement el, String value) {
        String sqlErr = "";
        String appSql = "SELECT sql, message FROM " + el.getAttribute("sql_table") + " WHERE (is_condition = true) AND " + el.getAttribute("sql_where") + " = '" + value + "'";
        BQuery aRs = new BQuery(this.db, appSql);
        while (aRs.moveNext()) {
            String ansSql = this.db.executeFunction(aRs.getString("sql") + value + "'");
            if (ansSql == null) {
                sqlErr = sqlErr + aRs.getString("message") + ";";
                continue;
            }
            if (!ansSql.equals("f")) continue;
            sqlErr = sqlErr + aRs.getString("message") + ";";
        }
        if (sqlErr.equals("")) {
            sqlErr = null;
        }
        return sqlErr;
    }

    public void updateMultiPart(HttpServletRequest request, ServletContext config, String tmpPath) {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            this.updateForm(request);
            return;
        }
        int yourMaxMemorySize = 262144;
        File yourTempDirectory = new File(tmpPath);
        DiskFileItemFactory factory = new DiskFileItemFactory(yourMaxMemorySize, yourTempDirectory);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        HashMap<String, String> reqParams = new HashMap<String, String>();
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                String pictureFile;
                if (item.isFormField()) {
                    reqParams.put(item.getFieldName(), item.getString());
                    continue;
                }
                if (item.getSize() <= 0L || (pictureFile = this.savePicture(item, config)) == null) continue;
                reqParams.put(item.getFieldName(), pictureFile);
            }
            this.updateForm(request, reqParams);
        }
        catch (FileUploadException ex) {
            System.out.println("File upload exception " + (Object)((Object)ex));
        }
    }

    public String savePicture(FileItem item, ServletContext config) {
        String pictureFile = null;
        String repository = config.getInitParameter("repository_url");
        String username = config.getInitParameter("rep_username");
        String password = config.getInitParameter("rep_password");
        System.out.println("repository : " + repository);
        BWebdav webdav = new BWebdav(repository, username, password);
        String contentType = item.getContentType();
        String fieldName = item.getFieldName();
        String fileName = item.getName();
        long fs = item.getSize();
        BElement el = this.view.getElement(fieldName);
        long maxfs = Long.valueOf(el.getAttribute("maxfilesize", "4194304"));
        String ext = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            ext = fileName.substring(i + 1).toLowerCase();
        }
        if (ext == null) {
            ext = "NAI";
        }
        String pictureName = this.db.executeFunction("SELECT nextval('picture_id_seq')") + "pic." + ext;
        try {
            Object[] imageTypes = new String[]{"BMP", "GIF", "JFIF", "JPEG", "JPG", "PNG", "TIF", "TIFF"};
            ext = ext.toUpperCase().trim();
            if (Arrays.binarySearch(imageTypes, ext) >= 0 && fs < maxfs) {
                webdav.saveFile(item.getInputStream(), pictureName);
                pictureFile = pictureName;
            }
        }
        catch (IOException ex) {
            this.log.severe("File saving failed Exception " + ex);
        }
        return pictureFile;
    }

    public void updateForm(HttpServletRequest request) {
        HashMap<String, String[]> reqParams = new HashMap<String, String[]>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String elName = (String)e.nextElement();
            reqParams.put(elName, request.getParameterValues(elName));
        }
        this.updateFormData(request, reqParams);
    }

    public void updateForm(HttpServletRequest request, Map<String, String> reqParams) {
        HashMap<String, String[]> newParams = new HashMap<String, String[]>();
        for (String paramName : reqParams.keySet()) {
            String[] pArray = new String[]{reqParams.get(paramName)};
            newParams.put(paramName, pArray);
        }
        this.updateFormData(request, newParams);
    }

    public void updateFormData(HttpServletRequest request, Map<String, String[]> reqParams) {
        String linkData = null;
        String formlink = null;
        int vds = this.viewKeys.size();
        this.saveMsg = "";
        if (vds > 2) {
            linkData = this.viewData.get(vds - 1);
            formlink = linkData.equals("!new!") ? this.view.getAttribute("keyfield") + " = null" : this.view.getAttribute("keyfield") + " = '" + linkData + "'";
        }
        if (this.view.getName().equals("FORM")) {
            BQuery qForm = new BQuery(this.db, this.view, formlink, null);
            if (this.view.getAttribute("foredit") != null) {
                qForm.movePos(1);
                qForm.recEdit();
            } else if (vds < 3) {
                qForm.recAdd();
            } else if (linkData.equals("!new!")) {
                qForm.recAdd();
                if (this.view.getAttribute("linkfield") != null) {
                    qForm.updateField(this.view.getAttribute("linkfield"), this.viewData.get(vds - 2));
                }
            } else {
                qForm.movePos(1);
                qForm.recEdit();
            }
            HashMap inputParams = new HashMap();
            if (this.view.getAttribute("inputparams") != null) {
                String[] paramArr;
                for (String param : paramArr = this.view.getAttribute("inputparams").toLowerCase().split(",")) {
                    String[] pItems = param.split("=");
                    if (pItems.length != 2) continue;
                    qForm.updateField(pItems[0].trim(), this.params.get(pItems[1].trim()));
                }
            }
            this.saveMsg = qForm.updateFields(reqParams, this.viewData, request.getRemoteAddr(), linkData);
            if ("".equals(this.saveMsg)) {
                String jumpView = this.view.getAttribute("jumpview");
                BElement fView = this.view.getElementByName("FORMVIEW");
                this.dataItem = qForm.getKeyField();
                this.viewData.set(vds - 1, this.dataItem);
                String postFnct = this.view.getAttribute("post_fnct");
                if (postFnct != null) {
                    String upsql = "SELECT " + postFnct + "('" + this.dataItem + "') ";
                    if (this.db.getDBType() == 2) {
                        upsql = upsql + " FROM dual";
                    }
                    this.db.executeQuery(upsql);
                }
                if (jumpView != null) {
                    this.saveMsg = "<div class='Metronic-alerts alert alert-success fade in'>\n";
                    this.saveMsg = this.saveMsg + "\t\t<button aria-hidden='true' data-dismiss='alert' class='close' type='button'></button>\n";
                    this.saveMsg = this.saveMsg + this.view.getAttribute("save.msg", "The record has been updated.") + "\n</div>\n";
                    this.viewKey = jumpView;
                    this.webSession.setAttribute("viewkey", (Object)jumpView);
                    this.webSession.setAttribute("loadviewkey", (Object)jumpView);
                    this.webSession.setAttribute("loaddata", (Object)this.dataItem);
                    this.init(request);
                } else if (fView != null) {
                    this.view = fView;
                    this.views.add(fView);
                    this.viewData.add(this.dataItem);
                    this.viewKeys.add("0");
                    this.viewKey = this.viewKey + ":0";
                } else {
                    this.saveMsg = "<div class='Metronic-alerts alert alert-success fade in'>\n";
                    this.saveMsg = this.saveMsg + "\t\t<button aria-hidden='true' data-dismiss='alert' class='close' type='button'></button>\n";
                    this.saveMsg = this.saveMsg + this.view.getAttribute("save.msg", "The record has been updated.") + "\n</div>\n";
                    if (vds > 2) {
                        this.dataItem = this.viewData.get(vds - 2);
                        this.view = this.views.get(vds - 2);
                        this.views.remove(vds - 1);
                        this.viewData.remove(vds - 1);
                        this.viewKeys.remove(vds - 1);
                        this.viewKey = this.viewKey.substring(0, this.viewKey.lastIndexOf(":"));
                        this.webSession.setAttribute("viewkey", (Object)this.viewKey);
                    }
                }
            } else {
                String tmsg = this.saveMsg;
                this.saveMsg = "<div class='Metronic-alerts alert alert-danger fade in'>\n";
                this.saveMsg = this.saveMsg + "\t\t<button aria-hidden='true' data-dismiss='alert' class='close' type='button'></button>\n";
                this.saveMsg = this.saveMsg + tmsg + "\n</div>\n";
            }
            qForm.close();
        } else if (this.view.getName().equals("ACCORDION")) {
            BElement accdView = this.view.getElement(0);
            System.out.println("Reached ACCORDION " + vds + " : " + formlink);
            BQuery qAccd = new BQuery(this.db, accdView, formlink, null);
            if (vds < 2) {
                qAccd.recAdd();
            } else if (linkData == null) {
                if (qAccd.moveFirst()) {
                    qAccd.recEdit();
                }
            } else if (linkData.equals("!new!")) {
                qAccd.recAdd();
                if (accdView.getAttribute("linkfield") != null) {
                    qAccd.updateField(accdView.getAttribute("linkfield"), this.viewData.get(vds - 2));
                }
            } else if (qAccd.moveFirst()) {
                qAccd.recEdit();
            }
            this.saveMsg = qAccd.updateFields(reqParams, this.viewData, request.getRemoteAddr(), linkData);
            this.dataItem = qAccd.getKeyField();
            this.viewData.set(vds - 1, this.dataItem);
            this.webSession.setAttribute("loaddata", (Object)this.dataItem);
            qAccd.close();
        }
    }

    public void deleteForm(HttpServletRequest request) {
        String linkData = null;
        String formlink = null;
        int vds = this.viewKeys.size();
        this.saveMsg = "";
        BElement fView = this.view;
        if (this.view.getName().equals("ACCORDION")) {
            fView = this.view.getElementByName("FORM");
        }
        if (fView == null) {
            return;
        }
        if (vds > 2 && !(linkData = this.viewData.get(vds - 1)).equals("!new!")) {
            formlink = fView.getAttribute("keyfield") + " = '" + linkData + "'";
        }
        if (fView.getName().equals("FORM") && !linkData.equals("!new!")) {
            BQuery qForm = new BQuery(this.db, fView, formlink, null);
            qForm.movePos(1);
            qForm.recDelete();
            qForm.close();
            if (vds > 2) {
                this.dataItem = this.viewData.get(vds - 2);
                this.view = this.views.get(vds - 2);
                this.views.remove(vds - 1);
                this.viewData.remove(vds - 1);
                this.viewKeys.remove(vds - 1);
                this.viewKey = this.viewKey.substring(0, this.viewKey.lastIndexOf(":"));
                this.webSession.setAttribute("viewkey", (Object)this.viewKey);
            } else {
                this.dataItem = "!new!";
            }
            this.saveMsg = "<div style='color:#00FF00'>Record deleted.</div>";
        }
    }

    public String getFieldTitles() {
        String fieldTitles = null;
        if (this.view == null) {
            return "";
        }
        BElement sview = null;
        if (this.comboField != null) {
            sview = this.view.getElement(this.comboField).getElement(0);
        }
        if (this.view.getName().equals("GRID") && this.view.getAttribute("display", "grid").equals("grid")) {
            fieldTitles = "<select class='fnctcombobox form-control' name='filtername' id='filtername'>";
            for (BElement el : this.view.getElements()) {
                if (el.getValue().equals("")) continue;
                fieldTitles = fieldTitles + "<option value='" + el.getValue() + "'>" + el.getAttribute("title") + "</option>\n";
            }
            fieldTitles = fieldTitles + "</select>";
        } else if (this.comboField != null) {
            fieldTitles = "<select class='fnctcombobox form-control' name='filtername' id='filtername'>";
            for (BElement el : sview.getElements()) {
                if (el.getValue().equals("")) continue;
                fieldTitles = fieldTitles + "<option value='" + el.getValue() + "'>" + el.getAttribute("title") + "</option>\n";
            }
            fieldTitles = fieldTitles + "</select>";
        }
        return fieldTitles;
    }

    public String getFieldTitles(HttpServletRequest request) {
        String fieldTitles = null;
        String field = request.getParameter("field");
        if (this.view.getName().equals("GRID")) {
            fieldTitles = "<select class='fnctcombobox form-control' name='filtername' id='filtername'>";
            for (BElement el : this.view.getElements()) {
                if (el.getValue().equals("")) continue;
                fieldTitles = fieldTitles + "<option value='" + el.getValue() + "'>" + el.getAttribute("title") + "</option>\n";
            }
            fieldTitles = fieldTitles + "</select>";
        } else if (this.view.getName().equals("FORM") && field != null) {
            BElement sview = this.view.getElement(field).getElement(0);
            fieldTitles = "<select class='fnctcombobox form-control' name='filtername' id='filtername'>";
            for (BElement el : sview.getElements()) {
                if (el.getValue().equals("")) continue;
                fieldTitles = fieldTitles + "<option value='" + el.getValue() + "'>" + el.getAttribute("title") + "</option>\n";
            }
            fieldTitles = fieldTitles + "</select>";
        }
        return fieldTitles;
    }

    public String getEntityName() {
        BUser user = this.db.getUser();
        return user.getEntityName();
    }

    public String getOrgName() {
        BUser user = this.db.getUser();
        return user.getUserOrgName();
    }

    public String getOrgID() {
        return this.db.getOrgID();
    }

    public String getUserOrg() {
        return this.db.getUserOrg();
    }

    public String getHiddenValues() {
        String HiddenValues = "";
        if (this.view == null) {
            return HiddenValues;
        }
        if (!this.view.getName().equals("FILTER")) {
            HiddenValues = "<input type='hidden' name='view' value='" + this.viewKey + "'/>\n";
            HiddenValues = HiddenValues + "<input type='hidden' name='data' value='" + this.dataItem + "'/>\n";
        }
        return HiddenValues;
    }

    public String getHiddenValues(HttpServletRequest request) {
        String HiddenValues = "";
        String field = request.getParameter("field");
        String formlinkdata = request.getParameter("formlinkdata");
        if (field != null) {
            HiddenValues = "<input type='hidden' name='field' value='" + field + "'/>\n";
            HiddenValues = HiddenValues + "<input type='hidden' name='formlinkdata' value='" + formlinkdata + "'/>\n";
        }
        return HiddenValues;
    }

    public String submitGrid(HttpServletRequest request) {
        String responce = "";
        String tbName = this.view.getAttribute("updatetable");
        String editKey = this.view.getAttribute("keyfield");
        for (BElement el : this.view.getElements()) {
            String[] paps;
            String name;
            String prms;
            if (!el.getName().equals("EDITFIELD") || (prms = request.getParameter(name = el.getValue())) == null) continue;
            for (String pap : paps = prms.split(":")) {
                String mysql = "UPDATE " + tbName + " SET " + name + " = '" + pap + "'";
                if (this.view.getAttribute("auditid") != null) {
                    String autoKeyID = this.db.insAudit(tbName, pap, "EDIT");
                    mysql = mysql + ", " + this.view.getAttribute("auditid") + " = " + autoKeyID;
                }
                mysql = mysql + " WHERE " + editKey + " = '" + pap + "'";
                this.log.severe("BASE : " + mysql);
            }
        }
        return responce;
    }

    public void getReport(HttpServletResponse response) {
        StringBuffer csvhtml = new StringBuffer();
        boolean fs = true;
        for (BElement bElement : this.view.getElements()) {
            if (bElement.getValue().equals("")) continue;
            if (fs) {
                fs = false;
            } else {
                csvhtml.append(",");
            }
            csvhtml.append(this.csvFormat(bElement.getAttribute("title")));
        }
        csvhtml.append("\n");
        BQuery rs = new BQuery(this.db, this.view, null, null);
        rs.reset();
        while (rs.moveNext()) {
            fs = true;
            for (BElement el : this.view.getElements()) {
                if (el.getValue().equals("")) continue;
                if (fs) {
                    fs = false;
                } else {
                    csvhtml.append(",");
                }
                csvhtml.append(this.csvFormat(rs.getString(el.getValue())));
            }
            csvhtml.append("\n");
        }
        response.setContentType("text/x-csv");
        response.setHeader("Content-Disposition", "attachment; filename=report.csv");
        try {
            PrintWriter printWriter = response.getWriter();
            printWriter.println(csvhtml.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            this.log.severe("IO Error : " + iOException);
        }
    }

    public String getExport(HttpServletRequest request, HttpServletResponse response) {
        String body = "";
        if (this.view.getName().equals("GRID")) {
            if (this.view.getAttribute("export", "csv").equals("csv")) {
                body = this.getCsv(request, response);
            } else if (this.view.getAttribute("export", "csv").equals("xml")) {
                body = this.getXml(request, response);
            }
        } else if (this.view.getName().equals("CROSSTAB")) {
            body = this.getCsv(request, response);
        }
        return body;
    }

    public String getCsv(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        String body = "";
        this.wheresql = null;
        this.sortby = null;
        Map<String, String> whereParams = this.getWhere(request);
        this.wheresql = whereParams.get("wheresql");
        BElement sview = null;
        this.comboField = request.getParameter("field");
        if (this.comboField != null) {
            sview = this.view.getElement(this.comboField).getElement(0);
        }
        response.setContentType("text/x-csv");
        response.setHeader("Content-Disposition", "attachment; filename=report.csv");
        if (this.view.getName().equals("GRID")) {
            BQuery csvData = new BQuery(this.db, this.view, this.wheresql, this.sortby);
            body = csvData.getCsv();
            csvData.close();
        } else if (this.view.getName().equals("CROSSTAB")) {
            BCrossTab ct = new BCrossTab(this.db, this.view, this.wheresql, this.sortby);
            body = ct.getCsv();
            ct.close();
        }
        return body;
    }

    public String getXml(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        String body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        this.wheresql = null;
        this.sortby = null;
        Map<String, String> whereParams = this.getWhere(request);
        this.wheresql = whereParams.get("wheresql");
        response.setContentType("text/xml");
        response.setHeader("Content-Disposition", "attachment; filename=report.xml");
        BElement tableXml = new BElement(this.view.getAttribute("name"));
        this.getXmlTable(tableXml, this.view, this.wheresql, this.sortby);
        if (tableXml.getNodeNumber() == 1) {
            if ((tableXml = tableXml.getFirst()) != null) {
                body = body + tableXml.toString();
            }
        } else {
            body = body + tableXml.toString();
        }
        return body;
    }

    public BElement getXmlTable(BElement tableXml, BElement tView, String tWhere, String tSortby) {
        BQuery xmlData = new BQuery(this.db, tView, tWhere, tSortby, false);
        String ifNull = this.view.getAttribute("ifnull", "");
        while (xmlData.moveNext()) {
            BElement rowXml = new BElement(tView.getAttribute("name"));
            for (BElement el : tView.getElements()) {
                if (el.getName().equals("GRID")) {
                    String sWhere = el.getAttribute("linkfield") + " = '" + xmlData.getKeyField() + "'";
                    this.getXmlTable(rowXml, el, sWhere, null);
                    continue;
                }
                if (el.getAttribute("hide") != null) continue;
                String nodeName = el.getAttribute("title");
                if (el.getAttribute("xml.node") != null) {
                    nodeName = xmlData.getString(el.getAttribute("xml.node"));
                }
                BElement xel = new BElement(nodeName);
                String elValue = xmlData.getString(el.getValue());
                if (elValue == null) {
                    elValue = ifNull;
                }
                xel.setValue(elValue);
                if (tView.getAttribute("xml.intable") == null) {
                    rowXml.addNode(xel);
                    continue;
                }
                tableXml.addNode(xel);
            }
            if (tView.getAttribute("xml.intable") != null) continue;
            tableXml.addNode(rowXml);
        }
        xmlData.close();
        return tableXml;
    }

    public String csvFormat(String lans) {
        String ans = "";
        if (lans != null) {
            ans = lans.indexOf(",") >= 0 ? "\"" + lans + "\"" : lans;
        }
        return ans;
    }

    public String getSearchReturn() {
        String searchReturn = this.view.getAttribute("return");
        if (searchReturn == null) {
            searchReturn = this.view.getAttribute("keyfield");
        }
        return searchReturn;
    }

    public void setSelectAll() {
        this.selectAll = true;
    }

    public String getAudit() {
        int vds = this.viewKeys.size();
        String linkData = null;
        String myaudit = null;
        if (vds > 2) {
            linkData = this.viewData.get(vds - 1);
        }
        if (linkData != null) {
            String mysql = "SELECT entitys.entity_name, sys_audit_trail.user_id, sys_audit_trail.change_date, ";
            mysql = mysql + "sys_audit_trail.change_type, sys_audit_trail.user_ip ";
            mysql = this.db.getDBType() == 1 ? mysql + "FROM sys_audit_trail LEFT JOIN entitys ON sys_audit_trail.user_id  = CAST(entitys.entity_id as varchar) " : mysql + "FROM sys_audit_trail LEFT JOIN entitys ON sys_audit_trail.user_id  = entitys.entity_id ";
            mysql = mysql + "WHERE (sys_audit_trail.table_name = '" + this.view.getAttribute("table") + "') ";
            mysql = mysql + "AND (sys_audit_trail.record_id = '" + linkData + "')";
            String[] mytitles = new String[]{"Done By", "ID", "Done On", "Change", "Source"};
            BQuery auditQuery = new BQuery(this.db, mysql, -1);
            auditQuery.setTitles(mytitles);
            auditQuery.readData(-1);
            myaudit = auditQuery.readDocument(true, false);
        }
        return myaudit;
    }

    public String showFooter() {
        String lblFt = "";
        int kl = this.views.size();
        if (kl > 2) {
            lblFt = "\n<ul class='breadcrumb' data-disabled='true'>";
            for (int j = 1; j < kl - 1; ++j) {
                String keyField = this.views.get(j).getAttribute("keyfield", "");
                String key = this.viewData.get(j + 1);
                if ("!new!".equals(key) || this.views.get(j).getName().equals("FILTER")) continue;
                BQuery ft = new BQuery(this.db, this.views.get(j), keyField + " = '" + key + "'", null);
                lblFt = lblFt + "\n<li><a href='#'><b>" + ft.getFooter() + "</b></a></li>";
                ft.close();
            }
            lblFt = lblFt + "\n</ul>";
        }
        return lblFt;
    }

    public String getCalendar() {
        String events = "";
        events = events + this.getEvents(this.view);
        for (BElement el : this.view.getElements()) {
            String event;
            if (!el.getName().equals("DIARY") || (event = this.getEvents(el)).equals("")) continue;
            if (events.equals("")) {
                events = events + this.getEvents(el);
                continue;
            }
            events = events + ", " + this.getEvents(el);
        }
        events = " events: [" + events + "]\n";
        return events;
    }

    public String getEvents(BElement eventView) {
        String events = "";
        String wherefilter = null;
        if (eventView.getAttribute("linkfield") != null && this.dataItem != null) {
            wherefilter = eventView.getAttribute("linkfield") + "='" + this.dataItem + "'";
        }
        BQuery crs = new BQuery(this.db, eventView, wherefilter, null, false);
        boolean isFf = true;
        while (crs.moveNext()) {
            if (isFf) {
                isFf = false;
            } else {
                events = events + ",\n";
            }
            events = events + "{";
            events = events + "id: " + crs.readField(1);
            String calTitle = crs.readField(2);
            if (calTitle == null) {
                calTitle = "";
            }
            events = events + ", title: '" + calTitle.replace("'", "");
            events = events + "', start: '" + crs.readField(3) + " " + crs.readField(4);
            events = events + "', end: '" + crs.readField(5) + " " + crs.readField(6);
            events = events + "', allDay: " + crs.readField(7);
            if (eventView.getAttribute("color") != null) {
                events = events + ", backgroundColor: Metronic.getBrandColor('" + eventView.getAttribute("color") + "') ";
            } else if (eventView.getAttribute("color.field") != null) {
                String colorField = crs.readField(eventView.getAttribute("color.field"));
                events = events + ", backgroundColor: Metronic.getBrandColor('" + colorField + "') ";
            } else {
                events = events + ", backgroundColor: Metronic.getBrandColor('silver') ";
            }
            events = events + "}";
        }
        return events;
    }

    public String receivePhoto(HttpServletRequest request, String tmpPath) {
        String pictureFile = "";
        int yourMaxMemorySize = 262144;
        File yourTempDirectory = new File(tmpPath);
        DiskFileItemFactory factory = new DiskFileItemFactory(yourMaxMemorySize, yourTempDirectory);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (!item.isFormField() || !item.getFieldName().equals("field")) continue;
                this.pictureField = item.getString();
            }
            BElement el = this.view.getElement(this.pictureField);
            long maxfs = Long.valueOf(el.getAttribute("maxfilesize", "2097152"));
            if (el.getAttribute("h") != null) {
                this.pictureURL = "<img height='" + el.getAttribute("h") + "' width='auto' ";
            }
            this.pictureURL = this.pictureURL + "src='" + el.getAttribute("pictures") + "?access=" + el.getAttribute("access");
            String repository = el.getAttribute("repository");
            String username = el.getAttribute("username");
            String password = el.getAttribute("password");
            BWebdav webdav = new BWebdav(repository, username, password);
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                String contentType = item.getContentType();
                String fieldName = item.getFieldName();
                String fileName = item.getName();
                long fs = item.getSize();
                String ext = null;
                int i = fileName.lastIndexOf(46);
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                if (ext == null) {
                    ext = "NAI";
                }
                pictureFile = this.db.executeFunction("SELECT nextval('picture_id_seq')");
                pictureFile = pictureFile + "pic." + ext;
                this.pictureURL = this.pictureURL + "&picture=" + pictureFile + "'>";
                Object[] imageTypes = new String[]{"JPEG", "JPG", "JFIF", "TIFF", "TIF", "GIF", "BMP", "PNG"};
                if (Arrays.binarySearch(imageTypes, ext = ext.toUpperCase().trim()) >= 0) {
                    if (fs < maxfs) {
                        webdav.saveFile(item.getInputStream(), pictureFile);
                        continue;
                    }
                    pictureFile = "";
                    continue;
                }
                pictureFile = "";
            }
        }
        catch (FileUploadException ex) {
            pictureFile = "";
            System.out.println("File upload exception " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            pictureFile = "";
            System.out.println("File saving failed Exception " + ex);
        }
        if (pictureFile == null) {
            this.pictureURL = "";
        }
        return pictureFile;
    }

    public String getSaveMsg() {
        String sMsg = "";
        if (this.saveMsg != null && !this.saveMsg.equals("")) {
            sMsg = "<div style='color:#FF0000; font-size:14px; font-weight:bold;'>" + this.saveMsg + "</div>";
        }
        return sMsg;
    }

    public String getMenuMsg(String xmlFile) {
        String mySql = "SELECT msg FROM sys_menu_msg WHERE (menu_id = '" + this.viewKey + "') AND (xml_file = '" + xmlFile + "')";
        String sMsg = this.db.executeFunction(mySql);
        sMsg = sMsg == null ? "" : "<div style='color:#0000FF; font-size:12px; font-weight:bold;'>" + sMsg + "</div>";
        return sMsg;
    }

    public String getJSONForm(HttpServletRequest request) {
        String linkData = request.getParameter("linkdata");
        String viewKey = request.getParameter("view");
        return this.getJSONForm(linkData, viewKey);
    }

    public String getJSONForm(String linkData, String viewKey) {
        JSONObject jResp = new JSONObject();
        JSONArray jTable = new JSONArray();
        if (!this.view.getName().equals("FORM")) {
            return "{}";
        }
        for (BElement el : this.view.getElements()) {
            if (!BWebUtils.canDisplayField(el.getName())) continue;
            int fieldType = BWebUtils.getFieldType(el.getName());
            JSONObject jField = new JSONObject();
            jField.put("type", fieldType);
            jField.put("name", (Object)el.getValue());
            if (el.getAttribute("title") != null) {
                jField.put("title", (Object)el.getAttribute("title"));
            }
            if (el.getAttribute("tab") != null) {
                jField.put("tab", (Object)el.getAttribute("tab"));
            }
            if (el.getName().equals("COMBOBOX")) {
                String comboboxSQL = BWebUtils.comboboxSQL(el, this.db.getUser(), this.db.getOrgID(), linkData);
                BQuery cmbrs = new BQuery(this.db, comboboxSQL);
                jField.put("list", (Object)cmbrs.getJSON());
                cmbrs.close();
            } else if (el.getName().equals("COMBOLIST")) {
                JSONArray jComboList = new JSONArray();
                for (BElement ell : el.getElements()) {
                    String mykey = ell.getAttribute("key", ell.getValue());
                    JSONObject jItem = new JSONObject();
                    jItem.put("id", (Object)mykey);
                    jItem.put("value", (Object)ell.getValue());
                    jComboList.put((Object)jItem);
                }
                jField.put("list", (Object)jComboList);
            }
            jTable.put((Object)jField);
        }
        jResp.put("form", (Object)jTable);
        return jResp.toString();
    }

    public String getJSONHeader() {
        JsonObjectBuilder jshd = Json.createObjectBuilder();
        JsonArrayBuilder jsColNames = Json.createArrayBuilder();
        JsonArrayBuilder jsColModel = Json.createArrayBuilder();
        if (this.view.getAttribute("superuser", "false").equals("true") && !this.db.getUser().getSuperUser()) {
            return "";
        }
        boolean hasAction = false;
        boolean hasSubs = false;
        boolean hasTitle = false;
        boolean hasFilter = false;
        boolean col = false;
        for (BElement el : this.view.getElements()) {
            if (!el.getValue().equals("")) {
                JsonObjectBuilder jsColEl = Json.createObjectBuilder();
                String mydn = el.getValue();
                if (!el.getValue().equals("")) {
                    jsColNames.add(el.getAttribute("title", ""));
                }
                jsColEl.add("name", mydn);
                jsColEl.add("width", Integer.valueOf(el.getAttribute("w", "50")).intValue());
                if (el.getName().equals("EDITFIELD")) {
                    jsColEl.add("editable", true);
                    if (el.getAttribute("edittype") != null) {
                        jsColEl.add("edittype", el.getAttribute("edittype"));
                    }
                    if (el.getAttribute("editoptions") != null) {
                        JsonObjectBuilder jsColElVal = Json.createObjectBuilder();
                        jsColElVal.add("value", el.getAttribute("editoptions"));
                        jsColEl.add("editoptions", jsColElVal);
                    }
                }
                jsColModel.add(jsColEl);
            }
            if (el.getName().equals("ACTIONS")) {
                hasAction = true;
            }
            if (el.getName().equals("GRID") || el.getName().equals("FORM") || el.getName().equals("JASPER")) {
                hasSubs = true;
            }
            if (el.getName().equals("ACCORDION") || el.getName().equals("FILES") || el.getName().equals("DIARY")) {
                hasSubs = true;
            }
            if (el.getName().equals("COLFIELD") || el.getName().equals("TITLEFIELD")) {
                hasTitle = true;
            }
            if (!el.getName().equals("FILTERGRID")) continue;
            hasFilter = true;
        }
        JsonObjectBuilder jsColEl = Json.createObjectBuilder();
        jsColNames.add("CL");
        jsColEl.add("name", "CL");
        jsColEl.add("width", 5);
        jsColEl.add("hidden", true);
        jsColModel.add(jsColEl);
        JsonObjectBuilder jsColKF = Json.createObjectBuilder();
        jsColNames.add("KF");
        jsColKF.add("name", "KF");
        jsColKF.add("width", 5);
        jsColKF.add("hidden", true);
        jsColModel.add(jsColKF);
        String jUrl = this.view.getAttribute("url", "jsondata");
        jshd.add("url", jUrl);
        jshd.add("datatype", "json");
        jshd.add("mtype", "GET");
        jshd.add("colNames", jsColNames);
        jshd.add("colModel", jsColModel);
        jshd.add("pager", "#jqpager");
        jshd.add("viewrecords", true);
        jshd.add("gridview", true);
        jshd.add("autoencode", true);
        jshd.add("autowidth", true);
        jshd.add("sortable", true);
        if (this.view.getAttribute("ssort") == null) {
            jshd.add("loadonce", true);
        } else {
            jshd.add("loadonce", false);
        }
        JsonObject jsObj = jshd.build();
        return jsObj.toString();
    }

    public String getJSONGridData(String linkData, String viewKey) {
        Integer pageStart = new Integer(0);
        Integer pageSize = new Integer(0);
        BJSONQuery JSONQuery = new BJSONQuery(this.db, this.view, this.wheresql, this.sortby, pageStart, pageSize);
        String JSONStr = JSONQuery.getJSONData(viewKey, false);
        return JSONStr;
    }

    public String getViewName() {
        if (this.view == null) {
            return "";
        }
        return this.view.getAttribute("name", "");
    }

    public String getViewType() {
        if (this.view == null) {
            return "";
        }
        return this.view.getName();
    }

    public String getViewColour() {
        String viewColor = "purple";
        if (this.root == null) {
            return viewColor;
        }
        viewColor = this.root.getAttribute("color", "purple");
        if (this.view == null) {
            return viewColor;
        }
        return this.view.getAttribute("color", viewColor);
    }

    public String getViewIcon() {
        String viewIcon = "icon-list";
        if (this.root == null) {
            return viewIcon;
        }
        if (this.view == null) {
            return viewIcon;
        }
        if (this.view.getName().equals("GRID")) {
            viewIcon = "icon-list";
        }
        if (this.view.getName().equals("FORM")) {
            viewIcon = "icon-note";
        }
        if (this.view.getName().equals("JASPER")) {
            viewIcon = "icon-doc";
        }
        return this.view.getAttribute("icon", viewIcon);
    }

    public String getButtonNav() {
        if (this.root == null) {
            return null;
        }
        if (this.view == null) {
            return null;
        }
        return this.view.getAttribute("button.nav");
    }

    public boolean hasPasswordChange() {
        if (this.root == null) {
            return false;
        }
        return this.root.getAttribute("password") != null;
    }

    public String getEncType() {
        if (this.view == null) {
            return "";
        }
        if (!this.view.getName().equals("FORM")) {
            return "";
        }
        if (this.view.getElementByName("PICTURE") == null) {
            return "";
        }
        return " enctype=\"multipart/form-data\" ";
    }

    public boolean hasChildren() {
        boolean hasSubs = false;
        for (BElement el : this.view.getElements()) {
            if (el.getName().equals("GRID") || el.getName().equals("FORM") || el.getName().equals("JASPER")) {
                hasSubs = true;
            }
            if (el.getName().equals("FILES") || el.getName().equals("DIARY") || el.getName().equals("FORMVIEW")) {
                hasSubs = true;
            }
            if (!el.getName().equals("ACCORDION") && !el.getName().equals("CROSSTAB")) continue;
            hasSubs = true;
        }
        return hasSubs;
    }

    public String getFilterStatus() {
        String filterStatus = "";
        String filterSN = "F" + this.viewKey;
        if (this.webSession.getAttribute(filterSN) != null) {
            String filterKSN = "";
            if (this.webSession.getAttribute("K" + filterSN) != null) {
                filterKSN = (String)this.webSession.getAttribute("K" + filterSN);
            }
            String wDataItem = "";
            if (this.dataItem != null) {
                wDataItem = this.dataItem;
            }
            if (filterKSN.equals(wDataItem)) {
                filterStatus = "Filtered";
            } else {
                this.webSession.removeAttribute(filterSN);
            }
        }
        return filterStatus;
    }

    public boolean isDiary() {
        boolean elDiary = false;
        if (this.view.getName().equals("DIARY")) {
            elDiary = true;
        }
        return elDiary;
    }

    public boolean isForm() {
        boolean elForm = false;
        if (this.view.getName().equals("FORM")) {
            elForm = true;
        }
        return elForm;
    }

    public boolean isEditField() {
        boolean editField = false;
        if (this.view.getElementByName("EDITFIELD") != null) {
            editField = true;
        }
        return editField;
    }

    public boolean isFileImport() {
        boolean fileImport = false;
        if (this.root == null) {
            return fileImport;
        }
        if (this.view == null) {
            return fileImport;
        }
        if (this.view.getAttribute("new", "true").equals("false")) {
            return fileImport;
        }
        if (this.view.getName().equals("FILES")) {
            fileImport = true;
        } else if (this.view.getName().equals("GRID") && this.view.getAttribute("import") != null) {
            fileImport = true;
        }
        return fileImport;
    }

    public boolean isMaterial() {
        if (this.root == null) {
            return false;
        }
        return this.root.getAttribute("material", "false").equals("true");
    }

    public boolean hasExpired() {
        return this.isExpired;
    }

    public boolean getLicense() {
        return this.isLicense;
    }

    public boolean hasLicense() {
        String dbName = this.db.getCatalogName();
        String dbID = this.db.executeFunction("SELECT datid FROM pg_stat_database WHERE datname = '" + dbName + "'");
        System.out.println("DB ID : " + dbName + " : " + dbID);
        String mysql = "SELECT org_id, org_name, system_identifier, MAC_address, public_key, license FROM orgs WHERE org_id = 0";
        BQuery lrs = new BQuery(this.db, mysql);
        lrs.moveFirst();
        if (lrs.getString("org_name") != null && lrs.getString("system_identifier") != null && lrs.getString("MAC_address") != null && lrs.getBytes("license") != null && lrs.getBytes("public_key") != null) {
            BLicense lic = new BLicense();
            this.isLicense = lic.verifyLicense(lrs.getString("org_name"), lrs.getString("system_identifier"), lrs.getString("MAC_address"), dbID, lrs.getBytes("license"), lrs.getBytes("public_key"));
        } else {
            this.isLicense = false;
        }
        lrs.close();
        return this.isLicense;
    }

    public String getAccordionJs() {
        return this.accordionJs;
    }

    public boolean isGrid() {
        return this.view.getName().equals("GRID");
    }

    public String getPictureField() {
        return this.pictureField;
    }

    public String getPictureURL() {
        return this.pictureURL;
    }

    public BDB getDB() {
        return this.db;
    }

    public String executeFunction(String mysql) {
        return this.db.executeFunction(mysql);
    }

    public String getUserID() {
        return this.db.getUserID();
    }

    public BUser getUser() {
        return this.db.getUser();
    }

    public String getWebLogos() {
        return this.db.getWebLogos();
    }

    public void setReadOnly(boolean readOnly) {
        this.db.setReadOnly(readOnly);
    }

    public String executeQuery(String mysql) {
        return this.db.executeQuery(mysql);
    }

    public BQuery getQuery(String mysql) {
        return new BQuery(this.db, mysql);
    }

    public boolean hasDashboardItem(String dashboardItem) {
        return this.dashboardItems.containsKey(dashboardItem);
    }

    public String getDashboardItem(String dashboardItem) {
        if (!this.dashboardItems.containsKey(dashboardItem)) {
            return "{}";
        }
        return this.dashboardItems.get(dashboardItem);
    }

    public BElement getRoot() {
        return this.root;
    }

    public BElement getView() {
        return this.view;
    }

    public String getViewKey() {
        return this.viewKey;
    }

    public List<String> getViewData() {
        return this.viewData;
    }

    public String getDataItem() {
        return this.dataItem;
    }

    public void close() {
        this.db.close();
    }
}

