/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class Bio {
    Logger log = Logger.getLogger(Bio.class.getName());

    public boolean create(String configDir, String path, String xmlfile, String projectName, String dbName) {
        String ps = System.getProperty("file.separator");
        String projectDir = configDir + path;
        boolean success = this.mkdir(projectDir);
        if (success) {
            projectDir = projectDir + ps;
            this.mkdir(projectDir + "configs");
            this.mkdir(projectDir + "database");
            this.mkdir(projectDir + "database" + ps + "setup");
            this.mkdir(projectDir + "reports");
            this.mkdir(projectDir + "docs");
            String barazaDir = this.getParent(projectDir) + ps + "baraza";
            String xmldata = this.loadFile(barazaDir + ps + "configs" + ps + "baraza.xml");
            xmldata = xmldata.replaceAll("Baraza", projectName);
            this.saveFile(projectDir + "configs" + ps + xmlfile, xmldata);
            xmldata = this.loadFile(barazaDir + ps + "configs" + ps + "context.xml");
            xmldata = xmldata.replaceAll("//localhost/baraza", "//localhost/" + dbName);
            this.saveFile(projectDir + "configs" + ps + "context.xml", xmldata);
            this.saveFile(projectDir + "database" + ps + "10." + path + ".sql", "---Project Database File");
            this.saveFile(projectDir + "docs" + ps + "TODO", "TODO");
        }
        return success;
    }

    public String getCurrentDir() {
        File directory = new File(".");
        String dirName = null;
        try {
            dirName = directory.getCanonicalPath();
        }
        catch (IOException ex) {
            this.log.severe("Current directory get error : " + ex);
        }
        return dirName;
    }

    public String getParent(String dirName) {
        File dir = new File(dirName);
        return dir.getParent();
    }

    public boolean mkdir(String dirName) {
        File dir = new File(dirName);
        return dir.mkdirs();
    }

    public boolean FileExists(String fileName) {
        File fl = new File(fileName);
        boolean flExists = fl.exists();
        return flExists;
    }

    public String loadFile(File file) {
        String fileContent = "";
        try {
            FileReader fr = new FileReader(file);
            fileContent = this.loadFile(fr);
            fr.close();
        }
        catch (IOException ex) {
            this.log.severe("File Read error : " + ex);
        }
        return fileContent;
    }

    public String loadFile(String fileName) {
        String fileContent = "";
        try {
            FileReader fr = new FileReader(fileName);
            fileContent = this.loadFile(fr);
            fr.close();
        }
        catch (IOException ex) {
            this.log.severe("File Read error : " + ex);
        }
        return fileContent;
    }

    public String loadFile(FileReader fr) {
        String fileContent = "";
        try {
            String s;
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                fileContent = fileContent + s + "\n";
            }
            br.close();
            fr.close();
        }
        catch (IOException ex) {
            this.log.severe("File Read error : " + ex);
        }
        return fileContent;
    }

    public void saveFile(String fileName, String mystr, boolean append) {
        try {
            FileWriter output = new FileWriter(fileName, append);
            output.write(mystr);
            output.close();
        }
        catch (IOException ex) {
            this.log.severe("File Write error : " + ex);
        }
    }

    public void saveFile(String fileName, String mystr) {
        this.saveFile(fileName, mystr, false);
    }

    public void saveFile(File file, String mystr) {
        try {
            FileWriter output = new FileWriter(file);
            output.write(mystr);
            output.close();
        }
        catch (IOException ex) {
            this.log.severe("File Write error : " + ex);
        }
    }

    public void saveFile(File file, InputStream in) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            this.log.severe("File Write error : " + ex);
        }
    }

    public BufferedImage loadImage(String path) {
        URL imgURL = Bio.class.getResource(path);
        if (imgURL != null) {
            try {
                return ImageIO.read(imgURL);
            }
            catch (IOException ex) {
                this.log.severe("Icon loading error : " + ex);
            }
        } else {
            this.log.severe("Couldn't find file : " + path);
        }
        return null;
    }
}

