/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.baraza.utils.Bio;

public class BWebdav {
    Logger log = Logger.getLogger(Bio.class.getName());
    Sardine sardine = null;
    String basePath = null;

    public BWebdav(String path, String userName, String passWord) {
        if (path == null || userName == null) {
            return;
        }
        this.basePath = path;
        try {
            this.sardine = SardineFactory.begin((String)userName, (String)passWord);
            List list = this.sardine.list(this.basePath);
        }
        catch (IOException ex) {
            this.sardine = null;
            this.log.severe("File list error : " + ex);
        }
        catch (Exception ex) {
            this.sardine = null;
            this.log.severe("webdav error : " + ex);
        }
    }

    public void setPath(String path) {
        this.basePath = path;
    }

    public List<DavResource> listDir(String path) {
        List<Object> resources = new ArrayList<DavResource>();
        if (this.sardine == null) {
            return resources;
        }
        try {
            resources = this.sardine.list(this.basePath + path);
            for (DavResource davResource : resources) {
                System.out.println(davResource);
            }
        }
        catch (IOException ex) {
            this.log.severe("File list error : " + ex);
        }
        return resources;
    }

    public InputStream getFile(String fileName) {
        InputStream is = null;
        if (this.sardine == null) {
            return is;
        }
        try {
            is = this.sardine.get(this.basePath + fileName);
        }
        catch (IOException ex) {
            this.log.severe("File read error : " + ex);
        }
        return is;
    }

    public boolean saveFile(File file, String saveName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            FileInputStream fis = new FileInputStream(file);
            this.sardine.put(this.basePath + saveName, (InputStream)fis);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("File write error : " + ex);
        }
        return isv;
    }

    public boolean saveFile(InputStream fis, String saveName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            this.sardine.put(this.basePath + saveName, fis);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("File write error : " + ex);
        }
        return isv;
    }

    public boolean delFile(String fileName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            this.sardine.delete(this.basePath + fileName);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("File delete error : " + ex);
        }
        return isv;
    }

    public boolean createDir(String dirName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            this.sardine.createDirectory(this.basePath + dirName);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("Directory create error : " + ex);
        }
        return isv;
    }

    public boolean fileMove(String srcName, String dstName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            this.sardine.move(this.basePath + srcName, this.basePath + dstName);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("File move error : " + ex);
        }
        return isv;
    }

    public boolean fileCopy(String srcName, String dstName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            this.sardine.copy(this.basePath + srcName, this.basePath + dstName);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("File copy error : " + ex);
        }
        return isv;
    }

    public boolean fileExists(String fileName) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            isv = this.sardine.exists(this.basePath + fileName);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("File Exists error : " + ex);
        }
        return isv;
    }

    public boolean setProperties(String fileName, Map<QName, String> addProps, List<QName> removeProps) {
        if (this.sardine == null) {
            return false;
        }
        boolean isv = true;
        try {
            this.sardine.patch(this.basePath + fileName, addProps, removeProps);
        }
        catch (IOException ex) {
            isv = false;
            this.log.severe("Set properties error : " + ex);
        }
        return isv;
    }

    public boolean isConnected() {
        return this.sardine != null;
    }

    public Map<String, String> getProperties(DavResource resource) {
        Map customProps = resource.getCustomProps();
        return customProps;
    }
}

