/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class BCipher {
    public static String encrypt(String secret, String plainText) {
        String codedText = "";
        try {
            SecretKeySpec key = new SecretKeySpec(secret.getBytes(), "DES");
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            byte[] cipherText = cipher.doFinal(plainText.getBytes());
            codedText = Base64.getEncoder().encodeToString(cipherText);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Error; No such Algorithim : " + ex);
        }
        catch (NoSuchPaddingException ex) {
            System.out.println("Error; no such padding : " + ex);
        }
        catch (InvalidKeyException ex) {
            System.out.println("Error; invalid key : " + ex);
        }
        catch (IllegalBlockSizeException ex) {
            System.out.println("Error; Illegal block : " + ex);
        }
        catch (BadPaddingException ex) {
            System.out.println("Error; Bad padding : " + ex);
        }
        return codedText;
    }

    public static String decrypt(String secret, String codedText) {
        String decodedText = "";
        try {
            SecretKeySpec key = new SecretKeySpec(secret.getBytes(), "DES");
            Cipher cipher = Cipher.getInstance("DES");
            byte[] encypted = Base64.getDecoder().decode(codedText.getBytes());
            cipher.init(2, key);
            byte[] decrypted = cipher.doFinal(encypted);
            decodedText = new String(decrypted);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Error; No such Algorithim : " + ex);
        }
        catch (NoSuchPaddingException ex) {
            System.out.println("Error; no such padding : " + ex);
        }
        catch (InvalidKeyException ex) {
            System.out.println("Error; invalid key : " + ex);
        }
        catch (IllegalBlockSizeException ex) {
            System.out.println("Error; Illegal block : " + ex);
        }
        catch (BadPaddingException ex) {
            System.out.println("Error; Bad padding : " + ex);
        }
        return decodedText;
    }

    public static String MD5(String planpw) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(planpw.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String password(String planpw) {
        String hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(planpw.getBytes("UTF-8"));
            byte[] raw = md.digest();
            hash = Base64.getEncoder().encodeToString(raw);
            hash = hash.replace("\n", "");
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("No algorithim : " + ex.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("Unsupported Encoding : " + ex.getMessage());
        }
        return hash;
    }

    public static String applySha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hash.length; ++i) {
                String hex = Integer.toHexString(0xFF & hash[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] applyECDSASig(PrivateKey privateKey, String input) {
        byte[] output = new byte[]{};
        try {
            Signature dsa = Signature.getInstance("ECDSA", "BC");
            dsa.initSign(privateKey);
            byte[] strByte = input.getBytes();
            dsa.update(strByte);
            byte[] realSig = dsa.sign();
            output = realSig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return output;
    }

    public static boolean verifyECDSASig(PublicKey publicKey, String data, byte[] signature) {
        try {
            Signature ecdsaVerify = Signature.getInstance("ECDSA", "BC");
            ecdsaVerify.initVerify(publicKey);
            ecdsaVerify.update(data.getBytes());
            return ecdsaVerify.verify(signature);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateKeyPair() {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", "BC");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            ECGenParameterSpec ecSpec = new ECGenParameterSpec("prime192v1");
            keyGen.initialize(ecSpec, random);
            keyPair = keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return keyPair;
    }

    public static String getStringFromKey(Key key) {
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }
}

