/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.swing;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.baraza.xml.BTreeNode;

public class BTreeDropTarget
implements DropTargetListener {
    DropTarget target;
    JTree targetTree;

    public BTreeDropTarget(JTree tree) {
        this.targetTree = tree;
        this.target = new DropTarget(this.targetTree, this);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
        BTreeNode parent = (BTreeNode)parentpath.getLastPathComponent();
        try {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!tr.isDataFlavorSupported(flavors[i])) continue;
                dtde.acceptDrop(dtde.getDropAction());
                TreePath p = (TreePath)tr.getTransferData(flavors[i]);
                BTreeNode node = (BTreeNode)p.getLastPathComponent();
                DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                model.insertNodeInto(node, parent, 0);
                dtde.dropComplete(true);
                return;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        BTreeNode node = this.getNodeForEvent(dtde);
        dtde.acceptDrag(dtde.getDropAction());
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        BTreeNode node = this.getNodeForEvent(dtde);
        dtde.acceptDrag(dtde.getDropAction());
    }

    private BTreeNode getNodeForEvent(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        return (BTreeNode)path.getLastPathComponent();
    }
}

