/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.swing;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class BTextIcon
implements Icon,
PropertyChangeListener {
    String fLabel;
    String[] fCharStrings;
    int[] fCharWidths;
    int fWidth;
    int fHeight;
    int fCharHeight;
    int fDescent;
    int fRotation;
    Component fComponent;
    static final int POSITION_NORMAL = 0;
    static final int POSITION_TOP_RIGHT = 1;
    static final int POSITION_FAR_TOP_RIGHT = 2;
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 4;
    static final int DEFAULT_CJK = 1;
    static final int LEGAL_ROMAN = 7;
    static final int DEFAULT_ROMAN = 4;
    static final int LEGAL_MUST_ROTATE = 6;
    static final int DEFAULT_MUST_ROTATE = 2;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int kBufferSpace = 5;

    public BTextIcon(Component component, String label, int rotateHint) {
        this.fComponent = component;
        this.fLabel = label;
        this.fRotation = rotateHint;
        this.calcDimensions();
        this.fComponent.addPropertyChangeListener(this);
    }

    public void setLabel(String label) {
        this.fLabel = label;
        this.recalcDimensions();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("font".equals(prop)) {
            this.recalcDimensions();
        }
    }

    void recalcDimensions() {
        int wOld = this.getIconWidth();
        int hOld = this.getIconHeight();
        this.calcDimensions();
        if (wOld != this.getIconWidth() || hOld != this.getIconHeight()) {
            this.fComponent.invalidate();
        }
    }

    void calcDimensions() {
        FontMetrics fm = this.fComponent.getFontMetrics(this.fComponent.getFont());
        this.fCharHeight = fm.getAscent() + fm.getDescent();
        this.fDescent = fm.getDescent();
        if (this.fRotation == 1) {
            int len = this.fLabel.length();
            char[] data = new char[len];
            this.fLabel.getChars(0, len, data, 0);
            this.fWidth = 0;
            this.fCharStrings = new String[len];
            this.fCharWidths = new int[len];
            for (int i = 0; i < len; ++i) {
                char ch = data[i];
                this.fCharWidths[i] = fm.charWidth(ch);
                if (this.fCharWidths[i] > this.fWidth) {
                    this.fWidth = this.fCharWidths[i];
                }
                this.fCharStrings[i] = new String(data, i, 1);
            }
            this.fHeight = this.fCharHeight * len + this.fDescent;
        } else {
            this.fWidth = this.fCharHeight;
            this.fHeight = fm.stringWidth(this.fLabel) + 10;
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(c.getForeground());
        g.setFont(c.getFont());
        if (this.fRotation == 1) {
            int yPos = y + this.fCharHeight;
            for (int i = 0; i < this.fCharStrings.length; ++i) {
                g.drawString(this.fCharStrings[i], x + (this.fWidth - this.fCharWidths[i]) / 2, yPos);
                yPos += this.fCharHeight;
            }
        } else if (this.fRotation == 2) {
            g.translate(x + this.fWidth, y + this.fHeight);
            ((Graphics2D)g).rotate(-NINETY_DEGREES);
            g.drawString(this.fLabel, 5, -this.fDescent);
            ((Graphics2D)g).rotate(NINETY_DEGREES);
            g.translate(-(x + this.fWidth), -(y + this.fHeight));
        } else if (this.fRotation == 4) {
            g.translate(x, y);
            ((Graphics2D)g).rotate(NINETY_DEGREES);
            g.drawString(this.fLabel, 5, -this.fDescent);
            ((Graphics2D)g).rotate(-NINETY_DEGREES);
            g.translate(-x, -y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.fWidth;
    }

    @Override
    public int getIconHeight() {
        return this.fHeight;
    }
}

