/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import gnu.io.SerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.server.comm.BComm;
import org.baraza.server.sms.BSMSCommands;
import org.baraza.server.sms.BSMSConnection;
import org.baraza.server.sms.BSMSEng;
import org.baraza.server.sms.BSMSOut;
import org.baraza.server.sms.BSMSend;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BSMS
extends Thread {
    Logger log = Logger.getLogger(BSMS.class.getName());
    SerialPort port = null;
    BSMSConnection smsconn = null;
    BDB db = null;
    BSMSEng smseng = null;
    BSMSend smsend = null;
    BSMSCommands smscomm = null;
    BElement root = null;
    BLogHandle logHandle;
    List<BComm> qcomms;
    boolean listening = false;
    boolean connected = false;
    boolean readonly = false;

    public BSMS(BDB db, BElement root, BLogHandle logHandle) {
        this.db = db;
        this.root = root;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.qcomms = new ArrayList<BComm>();
        for (BElement node : root.getElements()) {
            if (!node.getName().equals("COMM")) continue;
            this.qcomms.add(new BComm(db, node, logHandle));
        }
        if (root.getAttribute("readonly", "false").equals("true")) {
            this.readonly = true;
        }
        int portcount = Integer.valueOf(root.getAttribute("portcount", "0"));
        int duration = Integer.valueOf(root.getAttribute("duration", "10000"));
        if (portcount == 0) {
            this.connected = this.connect(root.getAttribute("port"));
        } else {
            for (int p = 0; p <= portcount; ++p) {
                if (this.connected) continue;
                this.connected = this.connect(root.getAttribute("port") + Integer.toString(p));
            }
        }
        if (this.connected) {
            this.start();
        }
    }

    public int getDelay() {
        int duration = Integer.valueOf(this.root.getAttribute("duration", "10000"));
        return duration;
    }

    public boolean connect(String commPort) {
        try {
            this.port = null;
            this.smsconn = new BSMSConnection(commPort, this.root.getAttribute("datarate"), this.logHandle);
            this.port = this.smsconn.getPort();
        }
        catch (IOException ex) {
            this.log.severe("COMM connection error : " + ex);
        }
        catch (RuntimeException ex) {
            this.log.severe("Runtime connection error : " + ex);
        }
        catch (Exception ex) {
            this.log.severe("Exception connection error : " + ex);
        }
        if (this.port != null) {
            this.log.info("Connected to " + commPort + ". Attempting AT");
            this.smsend = new BSMSend(this.port, this.logHandle);
            this.smseng = new BSMSEng(this.port, this.logHandle);
            this.smseng.start();
            this.smsend.sendMessage("AT\r");
            String resp = this.smseng.getMessage();
            this.smsend.sendMessage("AT\r");
            resp = this.smseng.getMessage();
            if ("AT".equals(resp)) {
                this.connected = true;
                this.listening = true;
                this.smscomm = new BSMSCommands(this.smseng, this.smsend, this.db, this.logHandle);
                this.smscomm.initPhone(this.root.getAttribute("store"), this.root.getAttribute("nmi"));
            } else {
                this.smseng.close();
                this.smsconn.close();
                this.smsend.close();
                this.smseng = null;
            }
        }
        return this.connected;
    }

    @Override
    public void run() {
        int duration = Integer.valueOf(this.root.getAttribute("duration", "10000"));
        while (this.listening) {
            int i = this.isActive();
            this.smsend.close();
            this.smsend = new BSMSend(this.port, this.logHandle);
            boolean dbValid = this.db.isValid();
            if (!dbValid) {
                this.db.reconnect();
            }
            if (i != this.smsend.OK) {
                this.smseng.close();
                this.smsconn.close();
                this.smsend.close();
                this.listening = false;
                duration = 1;
                this.log.severe("COMM Device Error.");
            }
            if (this.listening) {
                this.log.info("The Device is connected.");
                this.listening = this.readMessages();
                if (this.listening) {
                    if (dbValid) {
                        for (BComm qcomm : this.qcomms) {
                            qcomm.process();
                        }
                        if (!this.readonly) {
                            this.sendMessage();
                        }
                    }
                } else {
                    duration = 1;
                }
            }
            try {
                BSMS.sleep(duration);
            }
            catch (InterruptedException ex) {
                if (this.listening) {
                    this.log.severe("Sleep Interrupted : " + ex);
                    continue;
                }
                this.log.severe("Stopping SMS Engine");
            }
        }
        this.close();
    }

    public boolean readMessages() {
        boolean isreadsms = true;
        if (this.smseng != null) {
            this.smscomm.CheckStorage();
            int msglist = this.smscomm.getMessagesList();
            int msgMAX = this.smscomm.getMessageMAX();
            if (msglist > 0) {
                this.smscomm.delSMS(this.db);
            }
            this.smscomm.CheckStorage();
            msglist = this.smscomm.getMessagesList();
            msgMAX = this.smscomm.getMessageMAX();
            if (msglist > 0) {
                isreadsms = this.smscomm.readSMS(msglist, msgMAX);
            }
        }
        return isreadsms;
    }

    public void sendMessage() {
        String mysql = "SELECT sms_id, sms_number, message, folder_id, sent FROM sms ";
        mysql = mysql + "WHERE (folder_id = 0) AND (message_ready = true) AND (sent = false)";
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            boolean isSent = true;
            String number = rs.getString("sms_number");
            if (number == null) {
                number = "";
            }
            if (number.length() > 2) {
                isSent = this.sendMessage(number.trim(), rs.getString("message"));
            }
            mysql = "SELECT sms_address.sms_address_id, address.mobile ";
            mysql = mysql + "FROM address INNER JOIN sms_address ON address.address_id = sms_address.address_id ";
            mysql = mysql + "WHERE (sms_address.sms_id\t= " + rs.getString("sms_id") + ")";
            BQuery rsa = new BQuery(this.db, mysql);
            while (rsa.moveNext()) {
                number = rsa.getString("mobile");
                if (number == null) {
                    number = "";
                }
                if (number.length() <= 2) continue;
                isSent = this.sendMessage(number.trim(), rs.getString("message"));
            }
            rsa.close();
            mysql = "SELECT sms_groups.sms_groups_id, address.mobile ";
            mysql = mysql + "FROM address INNER JOIN entity_subscriptions ON address.table_id = entity_subscriptions.entity_id ";
            mysql = mysql + "INNER JOIN sms_groups ON sms_groups.entity_type_id = entity_subscriptions.entity_type_id ";
            mysql = mysql + "WHERE (address.table_name = 'entitys') AND (sms_groups.sms_id = " + rs.getString("sms_id") + ") ";
            BQuery rsg = new BQuery(this.db, mysql);
            while (rsg.moveNext()) {
                number = rsg.getString("mobile");
                if (number == null) {
                    number = "";
                }
                if (number.length() <= 2) continue;
                isSent = this.sendMessage(number.trim(), rs.getString("message"));
            }
            rsg.close();
            if (!isSent) continue;
            rs.recEdit();
            rs.updateField("sent", "true");
            rs.updateField("folder_id", "2");
            rs.recSave();
        }
        rs.close();
    }

    public void sendMessage(String message) {
        String[] msg = message.split(" ");
        String mymsg = message.replace(msg[0].trim() + " " + msg[1].trim(), "");
        if (msg.length > 2) {
            this.sendMessage(msg[1], mymsg.trim());
        }
    }

    public boolean sendMessage(String number, String message) {
        if (message == null) {
            return true;
        }
        if (message.equals("null")) {
            return true;
        }
        if (number == null) {
            return true;
        }
        if (number.equals("null")) {
            return true;
        }
        this.log.info(number + " : " + message);
        return this.sendSMS(number, message);
    }

    public String sendMessage(String number, String message, String accesscode) {
        String st = "OK";
        if (accesscode.equals(this.root.getAttribute("accesscode"))) {
            st = !this.sendSMS(number, message) ? "ERROR SENDING" : "ERROR ACCESS";
        }
        return st;
    }

    public boolean sendSMS(String msgaddr, String msg) {
        char cntrlZ = '\u001a';
        int cr = 13;
        int lf = 10;
        int msglen = msg.length();
        int msgcount = (msglen - 1) / 154;
        int msgno = 0;
        this.smseng.bufferReset();
        this.smsend.sendMessage("AT\r");
        this.smseng.getMessage();
        if (this.smseng.getPortStatus() != this.smseng.OK) {
            this.log.info("System not ready to send message");
        } else if (msglen < 155) {
            BSMSOut smsout = new BSMSOut(msgaddr, msg, msgno, msgcount);
            this.log.fine(smsout.length() + " : " + smsout.toString());
            this.smseng.bufferReset();
            this.smsend.sendMessage("AT+CMGS=" + smsout.length() + "\r");
            this.smsend.sendMessage(smsout.toString() + cntrlZ);
            this.smseng.getMessage();
            for (int j = 0; j < 5; ++j) {
                try {
                    BSMS.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.smseng.getPortStatus() != this.smseng.OK) {
                    this.smseng.getMessage();
                    continue;
                }
                break;
            }
        } else {
            block5: for (int i = 0; i <= msgcount; ++i) {
                if (this.smseng.getPortStatus() != this.smseng.OK) continue;
                int sml = (i + 1) * 153;
                if (msglen < sml) {
                    sml = msglen;
                }
                String submsg = msg.substring(i * 153, sml);
                BSMSOut subout = new BSMSOut(msgaddr, msg.substring(i * 153, sml), i, msgcount);
                this.log.info(i + " : " + submsg);
                this.log.fine(subout.length() + " : " + subout.toString().length() + " : " + subout.toString());
                this.smseng.bufferReset();
                this.smsend.sendMessage("AT\r");
                this.smseng.getMessage();
                this.smsend.sendMessage("AT+CMGS=" + subout.length() + "\r");
                this.smsend.sendMessage(subout.toString() + cntrlZ);
                this.smseng.getMessage();
                for (int j = 0; j < 5; ++j) {
                    try {
                        BSMS.sleep(2500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.smseng.getPortStatus() == this.smseng.OK) continue block5;
                    this.smseng.getMessage();
                }
            }
        }
        boolean isSent = false;
        if (this.smseng.getPortStatus() == this.smseng.OK) {
            isSent = true;
        }
        return isSent;
    }

    public int isActive() {
        this.smseng.bufferReset();
        this.smsend.sendMessage("AT\r");
        this.smseng.getMessage();
        return this.smsend.getPortStatus();
    }

    public boolean isRunning() {
        return this.listening;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        this.listening = false;
        if (this.smseng != null) {
            this.smseng.close();
        }
        if (this.smsconn != null) {
            this.smsconn.close();
        }
        for (BComm qcomm : this.qcomms) {
            qcomm.close();
        }
        this.interrupt();
        this.connected = false;
        this.log.info("Closing SMS Server.");
    }
}

