/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.epp;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class BEPPClient {
    Logger log = Logger.getLogger(BEPPClient.class.getName());
    private BElement root;
    private BElement root2;
    List<BElement> children;
    private BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
    private SSLSocket socket;
    private DataInputStream dis;
    private DataOutputStream dos;
    public int intAvail = 0;
    public String strAvail = null;

    public static void main(String[] args) {
        BEPPClient client = new BEPPClient();
        client.domainCheck("example1.co.ke");
        client.close();
    }

    public BEPPClient() {
        String configFile = "/root/baraza/projects/baraza/configs/epp.xml";
        BXML xml = new BXML(configFile, false);
        this.root = xml.getRoot();
        String server = this.root.getAttribute("server");
        int port = Integer.valueOf(this.root.getAttribute("port", "700"));
        int timeout = Integer.valueOf(this.root.getAttribute("timeout", "3000"));
        try {
            SSLSocketFactory factory = null;
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, this.getTrustManagers(this.root), null);
            factory = ctx.getSocketFactory();
            this.socket = (SSLSocket)factory.createSocket();
            this.socket.setSoTimeout(timeout);
            InetSocketAddress addr = new InetSocketAddress(server, port);
            this.socket.connect(addr, timeout);
            System.out.println("Connected to " + this.socket.getRemoteSocketAddress());
            this.dis = new DataInputStream(this.socket.getInputStream());
            this.dos = new DataOutputStream(this.socket.getOutputStream());
            X509Certificate[] chain = this.socket.getSession().getPeerCertificateChain();
            for (int i = 0; i < chain.length; ++i) {
                System.out.println("peer-certificate " + i);
                System.out.println(" Subject : " + chain[i].getSubjectDN().getName());
                System.out.println(" Issuer  : " + chain[i].getIssuerDN().getName());
            }
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Algorithm Error : " + ex);
        }
        catch (IOException ex) {
            System.out.println("IO Error : " + ex);
        }
        catch (KeyManagementException ex) {
            System.out.println("Key Management Error : " + ex);
        }
        System.out.println("\n\n");
        this.readEppString();
        BElement login = this.root.getElementByName("LOGIN");
        this.writeEppString(login.getFirst().toString());
        this.readEppString();
    }

    public String domainCheck(String domainname) {
        BElement check = this.root.getElementByName("CHECK");
        System.out.println("BASE 100 ");
        BElement node = new BElement("domain:name");
        node.setValue(domainname);
        check.getFirst().getFirst().getFirst().getFirst().addNode(node);
        System.out.println("BASE 110 " + check.getFirst().getFirst().getFirst().getFirst().toString());
        System.out.println("BASE 120 ");
        this.writeEppString(check.getFirst().toString());
        String rtn = this.readEppString();
        BXML xml2 = new BXML(rtn, true);
        this.root2 = xml2.getRoot();
        BElement rst = this.root2.getFirst().getElementByName("result");
        System.out.println(rst);
        BElement resData = this.root2.getFirst().getElementByName("resData").getFirst();
        System.out.println(resData);
        String domName = null;
        for (BElement el1 : resData.getElements()) {
            BElement dname = el1.getElementByName("domain:name");
            System.out.println("Status for : " + dname.getValue() + " : " + dname.getAttribute("avail"));
            this.intAvail = Integer.parseInt(dname.getAttribute("avail"));
            domName = dname.getValue().toString();
            if (Integer.valueOf(dname.getAttribute("avail")) >= 1) continue;
            BElement dnameR = el1.getElementByName("domain:reason");
            this.strAvail = dnameR.getValue();
            System.out.println("Reason : " + dnameR.getValue());
        }
        return domName;
    }

    public int getAvailable() {
        return this.intAvail;
    }

    public String getReason() {
        return this.strAvail;
    }

    public String domainRegister(String domainname) {
        BElement regs = this.root.getElementByName("REGISTER");
        System.out.println("BASE 300 ");
        BElement node2 = new BElement("domain:name");
        node2.setValue(domainname);
        regs.getFirst().getFirst().getFirst().getFirst().addNode(node2);
        System.out.println("BASE 310 " + regs.getFirst().getFirst().getFirst().getFirst().toString());
        System.out.println("BASE 320 ");
        this.writeEppString(regs.getFirst().toString());
        String rtn = this.readEppString();
        return rtn;
    }

    public void close() {
        System.out.println("closing the connection");
        BElement logout = this.root.getElementByName("LOGOUT");
        this.writeEppString(logout.getFirst().toString());
        this.readEppString();
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            System.out.println("IO Error : " + ex);
        }
    }

    private TrustManager[] getTrustManagers(BElement node) {
        TrustManagerFactory tmf = null;
        String filename = node.getAttribute("keystore");
        String password = node.getAttribute("keypassword");
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(filename), password.toCharArray());
            tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(keyStore);
        }
        catch (KeyStoreException ex) {
            System.out.println("Key Store error " + ex);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Algorithim error " + ex);
        }
        catch (IOException ex) {
            System.out.println("IO error " + ex);
        }
        catch (CertificateException ex) {
            System.out.println("Certificate error " + ex);
        }
        return tmf.getTrustManagers();
    }

    private String readEppString() {
        String input = null;
        try {
            int len = this.dis.readInt();
            if (len > 4000) {
                throw new IOException("Indicated length is unlikely long: " + len);
            }
            byte[] bytes = new byte[len -= 4];
            this.dis.readFully(bytes, 0, len);
            input = new String(bytes, "UTF-8");
        }
        catch (IOException ex) {
            System.out.println("System error " + ex);
        }
        return input;
    }

    private void writeEppString(String output) {
        try {
            byte[] bytes = output.getBytes("UTF-8");
            int len = bytes.length + 4;
            System.out.println("===================================");
            System.out.println("sending " + len + " bytes");
            System.out.print(output);
            this.dos.writeInt(len);
            this.dos.write(bytes);
        }
        catch (IOException ex) {
            System.out.println("System error " + ex);
        }
    }
}

