/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.deploy;

import java.util.HashMap;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.BUnZip;
import org.baraza.xml.BElement;

public class BDeploy {
    Logger log = Logger.getLogger(BDeploy.class.getName());
    BDB db = null;
    BElement root = null;
    int delay = 10000;

    public BDeploy(BDB db, BElement root, BLogHandle logHandle) {
        this.root = root;
        this.db = db;
        logHandle.config(this.log);
    }

    public int process() {
        this.log.info("--------------- Starting Deployed.");
        String mysql = "";
        HashMap<String, String> attr = new HashMap<String, String>();
        for (BElement el : this.root.getElements()) {
            mysql = el.getAttribute("function") == null ? "SELECT " + el.getValue() : "SELECT " + el.getAttribute("function") + " as " + el.getValue();
            mysql = mysql + " FROM " + el.getAttribute("table");
            if (el.getAttribute("wheresql") != null) {
                mysql = mysql + " WHERE " + el.getAttribute("wheresql");
            }
            String atv = this.db.executeFunction(mysql);
            attr.put(el.getName(), atv);
        }
        this.delay = Integer.valueOf((String)attr.get("INCREMENT")) * 60 * 1000;
        String namedvar = this.root.getAttribute("namedvar");
        String owner = this.root.getAttribute("owner");
        BUnZip us = new BUnZip((String)attr.get("ZONEDIR") + (String)attr.get("GENERATION"), namedvar, owner);
        String command = this.root.getAttribute("command");
        if (command != null) {
            try {
                Runtime r = Runtime.getRuntime();
                Process process = r.exec(command);
            }
            catch (Exception ex) {
                this.log.severe("Command run error : " + ex.getMessage());
            }
        }
        this.log.info("---------- Deployed : " + (String)attr.get("GENERATION"));
        return this.delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void close() {
        this.db.close();
    }
}

