/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.logging.Logger;
import org.baraza.server.BServer;
import org.baraza.utils.BLogHandle;

public class BServerThread
extends Thread {
    Logger log = Logger.getLogger(BServerThread.class.getName());
    public BServer server;
    Socket socket = null;
    String greeting;
    boolean readFirst;
    String HTML_START = "<html>\n<title>Open Baraza Server</title>\n<body>\n";
    String HTML_END = "</body>\n</html>\n";

    public BServerThread(Socket socket, BServer server, String greeting, BLogHandle logHandle) {
        super("DServerThread");
        logHandle.config(this.log);
        this.socket = socket;
        this.server = server;
        this.greeting = greeting;
    }

    @Override
    public void run() {
        this.log.info("Accepted connection");
        try {
            PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            String inputLine = "";
            String outputLine = "";
            if (this.greeting != null) {
                outputLine = this.greeting;
                out.println(outputLine);
                this.log.info("Server : " + outputLine);
            }
            boolean stopserver = false;
            while ((inputLine = in.readLine()) != null) {
                this.log.info("Server : " + inputLine);
                if (inputLine.equals("stop")) {
                    out.println("stopping server");
                    this.log.info("Server : stopping server");
                    stopserver = true;
                    break;
                }
                if (inputLine.equals("close")) {
                    out.println("closing client connection");
                    this.log.info("Server : closing client connection");
                    break;
                }
                if (inputLine.equals("quit")) {
                    out.println("closing client connection");
                    this.log.info("Server : closing client connection");
                    break;
                }
                if (inputLine.toLowerCase().startsWith("get")) {
                    while (in.ready()) {
                        inputLine = in.readLine();
                        this.log.info(inputLine);
                    }
                    out.println(this.HTML_START);
                    out.println("Open Baraza Server");
                    out.println(this.HTML_END);
                    break;
                }
                if (inputLine.toLowerCase().startsWith("post")) {
                    while (in.ready()) {
                        inputLine = in.readLine();
                        this.log.info(inputLine);
                        if (inputLine.indexOf("Content-Length:") == -1) continue;
                    }
                    out.println(this.HTML_START);
                    out.println("Open Baraza Server");
                    out.println(this.HTML_END);
                    break;
                }
                out.println("OK");
                this.log.info("Server : OK");
            }
            out.close();
            in.close();
            this.socket.close();
            if (stopserver) {
                out.println("Stopping Server");
                this.server.close();
            }
        }
        catch (IOException ex) {
            this.log.severe("Could not listen on port: 4444 : " + ex);
        }
    }
}

