/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultTreeModel;
import org.baraza.DB.BDB;
import org.baraza.ide.BEdit;
import org.baraza.ide.BQBuilder;
import org.baraza.ide.BxmlViewer;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;

public class BDevelop
extends JInternalFrame
implements ActionListener {
    Logger log = Logger.getLogger(BDevelop.class.getName());
    JTabbedPane tabbedPane;
    JTabbedPane queryTabs;
    JPanel panel;
    JPanel loginPanel = null;
    BDB db = null;
    BElement root;
    BElement desk = null;
    BTreeNode top;
    BTreeNode node;
    DefaultTreeModel treemodel;
    String configDir;
    String[] dbStr = new String[]{"project", "path", "dbname", "dbpath", "xmlfile", "dbusername", "encryption", "key"};
    BEdit edit;
    BQBuilder qbuilder;
    BxmlViewer viewer;
    BLogHandle logHandle;
    JLabel[] label;
    JTextField[] textField;
    JLabel ldbClass;
    JLabel lUserName;
    JLabel lPassword;
    JLabel lDisable;
    JLabel lNoAudit;
    JLabel lOrg;
    JTextField ftUserName;
    JPasswordField pwPassword;
    JComboBox<String> dbClassList;
    JCheckBox cbDisable;
    JCheckBox cbNoAudit;
    JCheckBox cbOrg;
    JButton btLogin;
    JButton btEdit;
    JButton btOkay;
    JButton btCancel;
    JButton btCreateDB;
    JButton btDropDB;
    JButton btSetup;
    JButton btDemo;

    public BDevelop(BElement root, BTreeNode top, DefaultTreeModel treemodel, String configDir, BLogHandle logHandle) {
        super("Create a new Project", false, true);
        this.root = root;
        this.top = top;
        this.treemodel = treemodel;
        this.configDir = configDir;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.makeNodePanel();
    }

    public BDevelop(BElement desk, BElement root, BTreeNode node, DefaultTreeModel treemodel, String configDir, BLogHandle logHandle) {
        super(desk.getValue(), true, true, true, true);
        this.desk = desk;
        this.root = root;
        this.node = node;
        this.treemodel = treemodel;
        this.configDir = configDir;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        String dbpassword = desk.getAttribute("dbpassword");
        String dbusername = desk.getAttribute("dbusername");
        this.makeLogin(dbusername, dbpassword);
    }

    public void makeNodePanel() {
        this.panel = new JPanel(new GridLayout(0, 2, 2, 2));
        String[] dbClasses = new String[]{"org.postgresql.Driver", "org.apache.derby.jdbc.EmbeddedDriver", "org.apache.derby.jdbc.ClientDriver", "oracle.jdbc.driver.OracleDriver", "org.hsqldb.jdbc.JDBCDriver", "com.mysql.jdbc.Driver", "sun.jdbc.odbc.JdbcOdbcDriver"};
        this.ldbClass = new JLabel("  Database Class :");
        this.dbClassList = new JComboBox<String>(dbClasses);
        this.dbClassList.setEditable(true);
        this.panel.add(this.ldbClass);
        this.panel.add(this.dbClassList);
        String[] str = new String[]{"Project Name", "Project Path", "Database Name", "Database Path", "XML File", "User Name", "Encryption", "Key"};
        this.label = new JLabel[str.length];
        this.textField = new JTextField[str.length];
        for (int i = 0; i < str.length; ++i) {
            this.label[i] = new JLabel("  " + str[i] + " :");
            this.textField[i] = new JTextField(50);
            this.panel.add(this.label[i]);
            this.panel.add(this.textField[i]);
            if (this.desk == null) continue;
            this.textField[i].setText(this.desk.getAttribute(this.dbStr[i], ""));
            this.textField[i].setCaretPosition(0);
        }
        this.textField[0].setActionCommand("Project Name");
        this.textField[0].addActionListener(this);
        if (this.desk != null) {
            this.textField[0].setText(this.desk.getValue());
            this.dbClassList.setSelectedItem(this.desk.getAttribute("dbclass", ""));
        }
        this.lPassword = new JLabel("  Password : ");
        this.pwPassword = new JPasswordField(10);
        if (this.desk != null) {
            this.pwPassword.setText(this.desk.getAttribute("dbpassword", ""));
        }
        this.panel.add(this.lPassword);
        this.panel.add(this.pwPassword);
        this.lDisable = new JLabel("  Disable : ");
        this.cbDisable = new JCheckBox();
        this.cbDisable.setSelected(false);
        this.panel.add(this.lDisable);
        this.panel.add(this.cbDisable);
        this.lNoAudit = new JLabel("  No Audit : ");
        this.cbNoAudit = new JCheckBox();
        this.cbNoAudit.setSelected(false);
        this.panel.add(this.lNoAudit);
        this.panel.add(this.cbNoAudit);
        this.lOrg = new JLabel("  Org : ");
        this.cbOrg = new JCheckBox();
        this.cbOrg.setSelected(false);
        this.panel.add(this.lOrg);
        this.panel.add(this.cbOrg);
        if (this.desk != null) {
            if (this.desk.getAttribute("disable", "false").equals("true")) {
                this.cbDisable.setSelected(true);
            }
            if (this.desk.getAttribute("noaudit", "false").equals("true")) {
                this.cbNoAudit.setSelected(true);
            }
            if (this.desk.getAttribute("org") != null) {
                this.cbOrg.setSelected(true);
            }
        }
        this.btSetup = new JButton("New Setup");
        this.panel.add(this.btSetup);
        this.btSetup.addActionListener(this);
        this.btDemo = new JButton("Demo Setup");
        this.panel.add(this.btDemo);
        this.btDemo.addActionListener(this);
        this.btCreateDB = new JButton("Create Database");
        this.btCreateDB.addActionListener(this);
        this.panel.add(this.btCreateDB);
        this.btDropDB = new JButton("Drop Database");
        this.btDropDB.addActionListener(this);
        this.panel.add(this.btDropDB);
        this.btCancel = new JButton("Template Database");
        this.panel.add(this.btCancel);
        this.btCancel.addActionListener(this);
        this.btOkay = new JButton("Save Project");
        this.panel.add(this.btOkay);
        this.btOkay.addActionListener(this);
        this.add(this.panel);
        this.setSize(100, 100, 500, 400);
    }

    public void makeLogin(String dbusername, String dbpassword) {
        this.loginPanel = new JPanel(new GridLayout(1, 7, 2, 2));
        this.lUserName = new JLabel("User Name : ");
        this.loginPanel.add(this.lUserName);
        this.ftUserName = new JTextField(25);
        if (dbusername != null) {
            this.ftUserName.setText(dbusername);
        }
        this.loginPanel.add(this.ftUserName);
        this.lPassword = new JLabel("Password : ");
        this.loginPanel.add(this.lPassword);
        this.pwPassword = dbpassword == null ? new JPasswordField(10) : new JPasswordField(dbpassword, 10);
        this.loginPanel.add(this.pwPassword);
        this.btLogin = new JButton("Login");
        this.btLogin.addActionListener(this);
        this.loginPanel.add(this.btLogin);
        this.btEdit = new JButton("Edit");
        this.btEdit.addActionListener(this);
        this.loginPanel.add(this.btEdit);
        this.add(this.loginPanel);
        this.setSize(100, 100, 700, 55);
    }

    public void makeDesk(String dbusername, String dbpassword) {
        this.db = new BDB(this.desk, dbusername, dbpassword);
        if (this.db.getDB() == null) {
            this.log.severe("Database Login in error");
            if (this.loginPanel == null) {
                this.makeLogin("", "");
            }
        } else {
            this.db.logConfig(this.logHandle);
            this.db.setUser("127.0.0.1", dbusername);
            if (this.loginPanel != null) {
                this.remove(this.loginPanel);
            }
            this.makeDeskItems();
        }
    }

    public void makeDeskItems() {
        String ps = System.getProperty("file.separator");
        String dbDirName = this.configDir + this.desk.getAttribute("path") + ps + "database" + ps;
        String configFile = this.configDir + this.desk.getAttribute("path") + ps + "configs" + ps + this.desk.getAttribute("xmlfile");
        String reportDir = this.configDir + this.desk.getAttribute("path") + ps + "reports" + ps;
        this.tabbedPane = new JTabbedPane(1);
        this.queryTabs = new JTabbedPane();
        this.qbuilder = new BQBuilder(this.logHandle, this.db, reportDir);
        this.viewer = new BxmlViewer(this.logHandle, this.db, configFile, this.desk.getValue());
        this.tabbedPane.add("Query Builder", this.queryTabs);
        this.tabbedPane.add("XML Viewer", this.viewer);
        this.queryTabs.add("Query", this.qbuilder);
        if (!dbDirName.startsWith("http")) {
            this.edit = new BEdit(dbDirName, this.db, this.logHandle);
            this.queryTabs.add("Database Files", this.edit.panel);
        }
        this.add(this.tabbedPane);
        this.setSize(10, 10, 800, 700);
    }

    public void saveProject() {
        String ps = System.getProperty("file.separator");
        String projectName = this.textField[0].getText().trim();
        String path = this.textField[1].getText().trim();
        String dbName = this.textField[2].getText().trim();
        String xmlfile = this.textField[4].getText().trim();
        String mypassword = new String(this.pwPassword.getPassword());
        boolean isNew = false;
        if (this.desk == null) {
            this.desk = new BElement("APP");
            isNew = true;
        }
        if (this.desk.getName().equals("APP")) {
            this.desk.setValue(projectName);
        }
        for (int i = 1; i < this.dbStr.length; ++i) {
            if (this.textField[i].getText().length() <= 0) continue;
            this.desk.setAttribute(this.dbStr[i], this.textField[i].getText());
        }
        this.desk.setAttribute("dbclass", this.dbClassList.getSelectedItem().toString());
        if (!"".equals(mypassword)) {
            this.desk.setAttribute("dbpassword", mypassword);
        }
        if (this.cbDisable.isSelected()) {
            this.desk.setAttribute("disable", "true");
        } else {
            this.desk.delAttribute("disable");
        }
        if (this.cbNoAudit.isSelected()) {
            this.desk.setAttribute("noaudit", "true");
        } else {
            this.desk.delAttribute("noaudit");
        }
        if (this.cbOrg.isSelected()) {
            this.desk.setAttribute("org", "org_id");
        } else {
            this.desk.delAttribute("org");
        }
        Bio fl = new Bio();
        if (isNew) {
            this.root.addNode(this.desk);
            this.top.add(new BTreeNode(this.desk, projectName));
            this.treemodel.reload(this.top);
            String projectPath = this.configDir + path.toLowerCase() + ps;
            BElement newtel = new BElement("APP");
            newtel.setAttribute("name", projectName);
            BElement newtelmn = new BElement("MENU");
            newtelmn.setAttribute("name", projectName);
            newtel.addNode(newtelmn);
            fl.create(this.configDir, path, xmlfile, projectName, dbName);
            this.dispose();
        } else {
            this.node.setUserObject(projectName);
            this.node.setKey(this.desk);
            this.treemodel.reload(this.node);
            this.remove(this.panel);
            String myusername = this.textField[5].getText().trim();
            this.makeLogin(myusername, mypassword);
        }
        fl.saveFile(this.configDir + "config.xml", this.root.getString());
    }

    public void setSize(int x, int y, int h, int w) {
        super.setLocation(x, y);
        super.setSize(h, w);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("Save Project".equals(aKey)) {
            this.saveProject();
        } else if ("Login".equals(aKey)) {
            String mypassword = new String(this.pwPassword.getPassword());
            this.makeDesk(this.ftUserName.getText(), mypassword);
        } else if ("Edit".equals(aKey)) {
            this.remove(this.loginPanel);
            this.makeNodePanel();
        } else if ("Create Database".equals(aKey)) {
            BDB rootDB = new BDB(this.root);
            rootDB.logConfig(this.logHandle);
            String mysql = "CREATE DATABASE " + this.textField[2].getText();
            String err = rootDB.executeQuery(mysql);
            rootDB.close();
            if (err == null) {
                if (this.desk != null) {
                    BDB deskDB = new BDB(this.desk);
                    deskDB.executeQuery("CREATE LANGUAGE plpgsql;");
                    deskDB.close();
                }
                this.log.info("Database Created");
            } else {
                this.log.severe(err);
            }
        } else if ("Template Database".equals(aKey)) {
            BDB rootDB = new BDB(this.root);
            rootDB.logConfig(this.logHandle);
            String mysql = "CREATE DATABASE " + this.textField[2].getText();
            if (this.root.getAttribute("dbtemplate") != null) {
                mysql = mysql + " TEMPLATE " + this.root.getAttribute("dbtemplate");
            }
            String err = rootDB.executeQuery(mysql);
            rootDB.close();
            if (err == null) {
                this.log.info("Database Created");
            } else {
                this.log.severe(err);
            }
        } else if ("Drop Database".equals(aKey)) {
            BDB rootDB = new BDB(this.root);
            rootDB.logConfig(this.logHandle);
            String mysql = "DROP DATABASE " + this.textField[2].getText();
            String err = rootDB.executeQuery(mysql);
            rootDB.close();
            if (err == null) {
                this.log.info("Database Dropped");
            } else {
                this.log.severe("Database is not Dropped : " + err);
            }
        } else if ("Project Name".equals(aKey)) {
            String[] dbPath = new String[]{"jdbc:postgresql://localhost/", "jdbc:derby:", "jdbc:derby:", "jdbc:oracle:thin:@localhost:1521:", "jdbc:hsqldb:file:", "jdbc:mysql://localhost/", "jdbc:odbc:"};
            String projectName = this.textField[0].getText().trim().toLowerCase().replace(" ", "");
            this.textField[1].setText(projectName);
            this.textField[2].setText(projectName);
            if (this.dbClassList.getSelectedIndex() > -1) {
                this.textField[3].setText(dbPath[this.dbClassList.getSelectedIndex()] + projectName);
            }
            this.textField[4].setText(projectName + ".xml");
            this.textField[5].setText("postgres");
            this.textField[7].setText(projectName);
        } else if ("New Setup".equals(aKey)) {
            this.log.info("Starting database setup");
            BDB rootDB = new BDB(this.root);
            rootDB.logConfig(this.logHandle);
            String mysql = "DROP DATABASE " + this.textField[2].getText();
            String err = rootDB.executeQuery(mysql);
            mysql = "CREATE DATABASE " + this.textField[2].getText();
            err = rootDB.executeQuery(mysql);
            rootDB.executeQuery("CREATE ROLE root LOGIN;");
            rootDB.close();
            if (err == null && this.desk != null) {
                String ps = System.getProperty("file.separator");
                String myfile = this.configDir + this.textField[1].getText().trim() + ps + "database" + ps + "setup" + ps + "setup.sql";
                Bio io = new Bio();
                BDB deskDB = new BDB(this.desk);
                deskDB.logConfig(this.logHandle);
                deskDB.executeQuery("CREATE LANGUAGE plpgsql;");
                mysql = io.loadFile(myfile);
                err = deskDB.executeQuery(mysql);
                deskDB.close();
            }
            if (err == null) {
                this.log.info("Database Setup Completed");
            } else {
                this.log.severe(err);
            }
        } else if ("Demo Setup".equals(aKey)) {
            this.log.info("Demo Database Setup Starting");
            BDB rootDB = new BDB(this.root);
            rootDB.logConfig(this.logHandle);
            String mysql = "DROP DATABASE " + this.textField[2].getText();
            String err = rootDB.executeQuery(mysql);
            mysql = "CREATE DATABASE " + this.textField[2].getText();
            err = rootDB.executeQuery(mysql);
            rootDB.executeQuery("CREATE ROLE root LOGIN;");
            rootDB.close();
            if (err == null && this.desk != null) {
                String ps = System.getProperty("file.separator");
                String myfile = this.configDir + this.textField[1].getText().trim() + ps + "database" + ps + "setup" + ps + "demo.sql";
                Bio io = new Bio();
                BDB deskDB = new BDB(this.desk);
                deskDB.logConfig(this.logHandle);
                deskDB.executeQuery("CREATE LANGUAGE plpgsql;");
                mysql = io.loadFile(myfile);
                err = deskDB.executeQuery(mysql);
                deskDB.close();
            }
            if (err == null) {
                this.log.info("Demo Database Setup Completed");
            } else {
                this.log.severe("Demo creation error : " + err);
            }
        }
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
        this.dispose();
    }
}

