/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.blockchain;

import java.util.Date;
import org.baraza.utils.BCipher;

public class BBlock {
    public String hash;
    public String previousHash;
    private String data;
    private long timeStamp;
    private int nonce;

    public BBlock(String data, String previousHash) {
        this.data = data;
        this.previousHash = previousHash;
        this.timeStamp = new Date().getTime();
        this.hash = this.calculateHash();
    }

    public String calculateHash() {
        String calculatedhash = BCipher.applySha256(this.previousHash + Long.toString(this.timeStamp) + this.data);
        return calculatedhash;
    }

    public void mineBlock(int difficulty) {
        String target = new String(new char[difficulty]).replace('\u0000', '0');
        while (!this.hash.substring(0, difficulty).equals(target)) {
            ++this.nonce;
            this.hash = this.calculateHash();
        }
        System.out.println("Block Mined!!! : " + this.hash);
    }
}

