/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.baraza.DB.BDB;
import org.baraza.swing.BFileDialogueFilter;
import org.baraza.utils.BPropeties;
import org.baraza.utils.BWebdav;
import org.baraza.xml.BElement;

public class BPicture
extends JLabel
implements MouseListener {
    Logger log = Logger.getLogger(BPicture.class.getName());
    String pictureFile = null;
    String pictureURL;
    String pictureAccess;
    BDB db = null;
    BWebdav webdav = null;

    public BPicture(BDB db, BElement el) {
        this.db = db;
        this.addMouseListener(this);
        this.pictureURL = BPropeties.getParam("pictures_url", "http://localhost:9090/repository/barazapictures");
        this.pictureAccess = BPropeties.getParam("photo_access", "ob");
        String repository = BPropeties.getParam("repository_url", "http://localhost:9090/repository/webdav/pictures/");
        String username = BPropeties.getParam("rep_username", "repository");
        String password = BPropeties.getParam("rep_password", "baraza");
        this.webdav = new BWebdav(repository, username, password);
    }

    public void setPicture(String value) {
        if (value == null) {
            this.setText("Double click to add image");
            return;
        }
        this.pictureFile = value;
        String mypic = this.pictureURL + "?access=" + this.pictureAccess + "&picture=" + this.pictureFile;
        String html = "<html>\n<body>\n<div style=\"text-align: center;\">\n";
        html = html + "<img src='" + mypic + "'>\n";
        html = html + "</div>\n</body>\n</html>";
        try {
            this.setText(html);
        }
        catch (Exception ex) {
            this.log.severe("html pucture diplay error " + ex);
        }
    }

    public String getPicture() {
        return this.pictureFile;
    }

    public void readimage() {
        if (this.webdav == null || !this.webdav.isConnected()) {
            JOptionPane.showMessageDialog(this, "The file repository is not connected");
            return;
        }
        JFileChooser fc = new JFileChooser();
        String[] ffa = new String[]{"jpg", "jpeg", "gif"};
        BFileDialogueFilter ff = new BFileDialogueFilter(ffa, "Picure Images");
        fc.setFileFilter(ff);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.pictureFile = this.db.executeFunction("SELECT nextval('picture_id_seq')");
            this.pictureFile = this.pictureFile + "pic." + ff.getExtension(file);
            if (this.webdav.isConnected()) {
                this.webdav.saveFile(file, this.pictureFile);
            }
            ImageIcon icon = new ImageIcon(file.getPath());
            this.setIcon(icon);
        }
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            this.readimage();
        }
    }
}

