/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import org.baraza.DB.BDB;
import org.baraza.DB.BTableModel;
import org.baraza.app.BFilter;
import org.baraza.app.BGridBox;
import org.baraza.swing.BDateTimeRenderer;
import org.baraza.swing.BTextIcon;
import org.baraza.swing.BTimeRenderer;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

class BGrid
extends JPanel
implements ActionListener,
MouseListener {
    Logger log = Logger.getLogger(BGrid.class.getName());
    BLogHandle logHandle;
    BTableModel tableModel;
    JTable table;
    JPanel mainPanel = new JPanel(new BorderLayout());
    JPanel filterPanel;
    JComboBox<String> fieldList;
    JComboBox<String> filterList;
    JCheckBox checkAnd;
    JCheckBox checkOr;
    JTextField filterData;
    JScrollPane scrollPane;
    JTabbedPane gridPane;
    JButton btPrintAll;
    List<BGrid> grids;
    BDB db;
    BElement view;
    String filterName = "filterid";
    String tableFilter = null;
    String linkValue = null;
    String linkField = null;
    String linkFnct = null;
    String update = null;

    public BGrid(BLogHandle logHandle, BDB db, BElement view, String reportDir) {
        super(new CardLayout());
        this.db = db;
        this.view = view;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.filterName = view.getAttribute("filter", "filterid");
        this.linkField = view.getAttribute("linkfield");
        this.linkFnct = view.getAttribute("linkfnct");
        this.update = view.getAttribute("update");
        this.tableFilter = null;
        if (this.linkField != null) {
            this.tableFilter = this.linkField + " = null";
        }
        this.tableModel = new BTableModel(db, view, this.tableFilter);
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(this);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.setDefaultRenderer(Timestamp.class, new BDateTimeRenderer());
        this.table.setDefaultRenderer(Time.class, new BTimeRenderer());
        this.scrollPane = new JScrollPane(this.table);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.filterPanel = new JPanel(new FlowLayout());
        if (view.getName().equals("FILTERGRID")) {
            this.btPrintAll = new JButton("Print All");
            this.filterPanel.add(this.btPrintAll);
        }
        this.filterData = new JTextField(25);
        this.filterData.setActionCommand("Filter");
        this.filterData.addActionListener(this);
        String[] filterstr = new String[]{"ILIKE", "LIKE", "=", ">", "<", "<=", ">="};
        this.fieldList = new JComboBox<String>(this.tableModel.getColumnNames());
        this.filterList = new JComboBox<String>(filterstr);
        this.checkAnd = new JCheckBox("And");
        this.checkOr = new JCheckBox("Or");
        this.filterPanel.add(this.fieldList);
        this.filterPanel.add(this.filterList);
        this.filterPanel.add(this.filterData);
        this.filterPanel.add(this.checkAnd);
        this.filterPanel.add(this.checkOr);
        this.mainPanel.add((Component)this.filterPanel, "Last");
        this.gridPane = new JTabbedPane(4);
        this.gridPane.addMouseListener(this);
        this.grids = new ArrayList<BGrid>();
        for (BElement el : view.getElements()) {
            if (!el.getName().equals("FILTERGRID")) continue;
            this.grids.add(new BGrid(logHandle, db, el, reportDir));
            String paneName = el.getAttribute("name");
            BTextIcon textIcon = new BTextIcon(this.gridPane, paneName, 4);
            this.gridPane.addTab("", textIcon, this.grids.get(this.grids.size() - 1));
        }
        super.add((Component)this.mainPanel, "main");
        super.add((Component)this.gridPane, "grid");
        this.adjustWidth();
    }

    public void adjustWidth() {
        int i = 0;
        for (BElement el : this.view.getElements()) {
            if (el.getValue().equals("")) continue;
            int w = Integer.valueOf(el.getAttribute("w", "40"));
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(w);
            ++i;
        }
    }

    public String getKey() {
        String key = null;
        if (this.grids.size() == 0) {
            int aRow = this.table.getSelectedRow();
            if (aRow != -1) {
                int index = this.table.convertRowIndexToModel(aRow) + 1;
                this.tableModel.movePos(index);
                key = this.tableModel.getKeyField();
            }
        } else {
            int i = this.gridPane.getSelectedIndex();
            key = this.grids.get(i).getKey();
        }
        return key;
    }

    public String readField(String fieldName) {
        return this.tableModel.readField(fieldName);
    }

    public Vector<String> getKeys() {
        Vector<String> keys = new Vector();
        if (this.grids.size() == 0) {
            keys = this.tableModel.getKeyFieldData();
        } else {
            int i = this.gridPane.getSelectedIndex();
            keys = this.grids.get(i).getKeys();
        }
        return keys;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getUpdate() {
        return this.update;
    }

    public void refresh() {
        if (this.linkField != null && this.linkValue != null) {
            if (this.linkFnct == null) {
                this.tableFilter = this.linkField + " = '" + this.linkValue + "'";
            } else {
                String updSQL = "SELECT " + this.linkFnct + "('" + this.linkValue + "')";
                this.tableFilter = this.linkField + " = '" + this.db.executeFunction(updSQL) + "'";
            }
        }
        this.tableModel.filter(this.tableFilter, null);
        this.adjustWidth();
    }

    public void setLinkData(String lkdata) {
        this.linkValue = lkdata;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String wheresql = null;
        wheresql = this.tableFilter == null ? "" : (this.checkAnd.isSelected() ? this.tableFilter + " AND " : (this.checkOr.isSelected() ? this.tableFilter + " OR " : ""));
        wheresql = wheresql + this.tableModel.getFieldName(this.fieldList.getSelectedIndex());
        wheresql = wheresql + " " + this.filterList.getSelectedItem();
        wheresql = this.filterList.getSelectedIndex() < 2 ? wheresql + " '%" + this.filterData.getText() + "%'" : wheresql + " '" + this.filterData.getText() + "'";
        this.tableFilter = wheresql;
        wheresql = null;
        if (this.linkField != null && this.linkValue != null) {
            if (this.linkFnct == null) {
                wheresql = this.linkField + " = '" + this.linkValue + "'";
            } else {
                String updSQL = "SELECT " + this.linkFnct + "('" + this.linkValue + "')";
                wheresql = this.linkField + " = '" + this.db.executeFunction(updSQL) + "'";
            }
        }
        wheresql = wheresql == null ? this.tableFilter : "(" + wheresql + ") AND " + this.tableFilter;
        this.tableModel.filter(wheresql, null);
        this.adjustWidth();
    }

    public void link(String linkValue) {
        this.tableModel.filter(this.linkField + " = '" + linkValue + "'", null);
        this.linkValue = linkValue;
    }

    public void showMain() {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, "main");
    }

    public void setListener(BFilter flt) {
        this.table.addMouseListener(flt);
        for (BGrid grid : this.grids) {
            grid.setListener(flt);
        }
        this.btPrintAll.addActionListener(flt);
    }

    public void setListener(BGridBox bgb) {
        this.table.addMouseListener(bgb);
        for (BGrid grid : this.grids) {
            grid.setListener(bgb);
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.getComponent().equals(this.table)) {
            int aRow = this.table.getSelectedRow();
            if (aRow != -1 && ev.getClickCount() == 2 && this.grids.size() > 0) {
                int index = this.table.convertRowIndexToModel(aRow) + 1;
                this.tableModel.movePos(index);
                String key = this.tableModel.getKeyField();
                if (key != null) {
                    for (BGrid grid : this.grids) {
                        grid.link(key);
                    }
                    CardLayout cl = (CardLayout)this.getLayout();
                    cl.show(this, "grid");
                }
            }
        } else if (ev.getComponent().equals(this.gridPane)) {
            this.showMain();
        }
    }
}

