/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.xml.BElement;

public class BComboBox
extends JComboBox<String> {
    BQuery query;
    String sql;
    String name;
    String cmb_fnct;
    String lptable;
    String lpfield;
    String lpkey;
    String wheresql;
    String ordersql;
    String defaultValue;
    String linkCombo;
    String linkField;
    String linkFnct;
    String linkValue = null;
    List<String> lplist = new ArrayList<String>();

    public BComboBox(BDB db, BElement el) {
        this.name = el.getValue();
        this.lpkey = el.getAttribute("lpkey", "");
        if (this.lpkey.equals("")) {
            this.lpkey = this.name;
        }
        this.cmb_fnct = el.getAttribute("cmb_fnct");
        this.lptable = el.getAttribute("lptable");
        this.lpfield = el.getAttribute("lpfield");
        this.wheresql = el.getAttribute("where");
        this.ordersql = el.getAttribute("orderby");
        this.linkField = el.getAttribute("linkfield");
        this.linkFnct = el.getAttribute("linkfnct");
        this.defaultValue = el.getAttribute("default");
        this.linkCombo = el.getAttribute("linkcombo");
        this.sql = this.lpkey.equals(this.lpfield) ? "SELECT " + this.lpfield + " FROM " + this.lptable : (this.cmb_fnct == null ? "SELECT " + this.lpkey + ", " + this.lpfield + " FROM " + this.lptable : "SELECT " + this.lpkey + ", (" + this.cmb_fnct + ") as " + this.lpfield + " FROM " + this.lptable);
        if (el.getAttribute("noorg") == null) {
            String orgID = db.getOrgID();
            String userOrg = db.getUserOrg();
            if (orgID != null && userOrg != null) {
                this.wheresql = this.wheresql == null ? "(" : this.wheresql + " AND (";
                this.wheresql = this.wheresql + orgID + "=" + userOrg + ")";
            }
        }
        if (el.getAttribute("user") != null) {
            String userFilter = "(" + el.getAttribute("user") + " = '" + db.getUserID() + "')";
            this.wheresql = this.wheresql == null ? userFilter : this.wheresql + " AND " + userFilter;
        }
        if (this.wheresql != null) {
            this.sql = this.sql + " WHERE " + this.wheresql;
        }
        this.sql = this.ordersql != null ? this.sql + " ORDER BY " + this.ordersql : this.sql + " ORDER BY " + this.lpfield;
        this.query = new BQuery(db, this.sql);
        this.getList();
        if (el.getAttribute("editable") != null) {
            super.setEditable(true);
        }
        if (el.getAttribute("disabled") != null) {
            super.setEnabled(false);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    public void setLinkData(String lkdata) {
        this.sql = this.lpkey.equals(this.lpfield) ? "SELECT " + this.lpfield + " FROM " + this.lptable : (this.cmb_fnct == null ? "SELECT " + this.lpkey + ", " + this.lpfield + " FROM " + this.lptable : "SELECT " + this.lpkey + ", (" + this.cmb_fnct + ") as " + this.lpfield + " FROM " + this.lptable);
        String tableFilter = null;
        this.linkValue = lkdata;
        if (this.linkField != null && this.linkValue != null) {
            tableFilter = this.linkFnct == null ? this.linkField + " = '" + this.linkValue + "'" : this.linkField + " = " + this.linkFnct + "('" + this.linkValue + "')";
        }
        if (this.wheresql != null) {
            this.sql = this.sql + " WHERE (" + this.wheresql + ")";
            if (tableFilter != null) {
                this.sql = this.sql + " AND (" + tableFilter + ")";
            }
        } else if (tableFilter != null) {
            this.sql = this.sql + " WHERE (" + tableFilter + ")";
        }
        this.sql = this.ordersql != null ? this.sql + " ORDER BY " + this.ordersql : this.sql + " ORDER BY " + this.lpfield;
        this.query.setSQL(this.sql);
        this.getList();
    }

    public void getList() {
        super.removeAllItems();
        this.lplist.clear();
        this.query.refresh();
        while (this.query.moveNext()) {
            this.lplist.add(this.query.getString(this.lpkey));
            super.addItem(this.query.getString(this.lpfield));
        }
        if (this.defaultValue != null) {
            this.setText(this.defaultValue);
        }
    }

    public void setText(String ldata) {
        if (ldata == null) {
            ldata = "";
        }
        if (super.isEditable()) {
            super.setSelectedItem(ldata);
        } else {
            int lp = this.lplist.indexOf(ldata);
            super.setSelectedIndex(lp);
        }
    }

    public String getText() {
        String combovalue = "";
        if (super.getSelectedIndex() == -1) {
            combovalue = "";
        } else if (super.isEditable()) {
            combovalue = super.getSelectedItem().toString();
        } else {
            int lp = super.getSelectedIndex();
            combovalue = this.lplist.get(lp);
        }
        return combovalue;
    }

    public boolean hadListener() {
        boolean isListener = false;
        if (this.linkCombo != null) {
            isListener = true;
        }
        return isListener;
    }

    public String getComboLink() {
        return this.linkCombo;
    }
}

