/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.baraza.app.BFilter;
import org.baraza.xml.BElement;

public class BCalendar
extends JPanel
implements ActionListener {
    JButton prevYear;
    JButton prevMonth;
    JButton theMonth;
    JButton nextMonth;
    JSplitPane sp;
    JTable table;
    JScrollPane scrollPane;
    JPanel topPanel;
    JPanel prevPanel;
    String filterName;
    GregorianCalendar calendar;
    String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    String[] columnNames = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    String[][] data;

    public BCalendar(BElement fieldDef) {
        super(new BorderLayout());
        String[] calendardays;
        this.calendar = new GregorianCalendar();
        if (this.calendar.getFirstDayOfWeek() == 2) {
            calendardays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
            this.columnNames = calendardays;
        } else {
            calendardays = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
            this.columnNames = calendardays;
        }
        this.data = new String[6][7];
        for (int j = 0; j < 6; ++j) {
            for (int i = 0; i < 7; ++i) {
                this.data[j][i] = "";
            }
        }
        this.filterName = fieldDef.getAttribute("filtername", "filterid");
        this.prevYear = new JButton("<<");
        this.prevMonth = new JButton("<");
        this.theMonth = new JButton(">>");
        this.nextMonth = new JButton(">");
        this.table = new JTable(this.data, this.columnNames);
        this.table.setCellSelectionEnabled(true);
        this.table.setRowHeight(21);
        this.table.setShowGrid(false);
        this.scrollPane = new JScrollPane(this.table);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setVerticalAlignment(0);
        renderer.setHorizontalAlignment(0);
        this.table.setDefaultRenderer(Object.class, renderer);
        this.prevPanel = new JPanel(new GridLayout(0, 2));
        this.prevPanel.add(this.prevYear);
        this.prevPanel.add(this.prevMonth);
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)this.prevPanel, "Before");
        this.topPanel.add((Component)this.theMonth, "Center");
        this.topPanel.add((Component)this.nextMonth, "After");
        this.prevYear.setOpaque(true);
        this.prevMonth.setOpaque(true);
        this.theMonth.setOpaque(true);
        this.nextMonth.setOpaque(true);
        this.topPanel.setOpaque(true);
        this.prevYear.addActionListener(this);
        this.prevMonth.addActionListener(this);
        this.nextMonth.addActionListener(this);
        this.theMonth.addActionListener(this);
        super.add((Component)this.topPanel, "First");
        super.add((Component)this.scrollPane, "Center");
        this.showCalendar();
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    public void showCalendar(String strdate) {
        if (strdate == null) {
            this.showCalendar();
        }
        if (strdate.length() > 0) {
            try {
                Date mydate = new Date();
                SimpleDateFormat dateparse = new SimpleDateFormat("yyyy-MM-dd");
                mydate = dateparse.parse(strdate);
                this.calendar.setTime(mydate);
                this.showCalendar();
            }
            catch (ParseException ex) {
                System.out.println("String to date conversion problem : " + ex);
            }
        }
    }

    public void showCalendar() {
        int i;
        this.calendar.set(5, 1);
        this.theMonth.setText(this.calendar.get(1) + " " + this.monthNames[this.calendar.get(2)]);
        int maxdays = this.calendar.getActualMaximum(5);
        for (int j = 0; j < 6; ++j) {
            for (i = 0; i < 7; ++i) {
                this.table.setValueAt("", j, i);
            }
        }
        int addvalue = 0;
        for (i = 1; i <= maxdays; ++i) {
            int row = this.calendar.get(4) - 1;
            int col = this.calendar.get(7) - 1;
            if (this.calendar.getFirstDayOfWeek() == 2) {
                --col;
            }
            if (row < 0) {
                addvalue = 1;
            }
            row += addvalue;
            if (col < 0) {
                col = 6;
            }
            String myday = Integer.toString(i);
            this.table.setValueAt(myday, row, col);
            this.calendar.add(5, 1);
        }
        this.calendar.add(5, -1);
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getKey() {
        int row = this.table.getSelectedRow();
        int col = this.table.getSelectedColumn();
        String mydate = "";
        String value = "";
        if (row >= 0 && col >= 0) {
            value = (String)this.table.getValueAt(row, col);
        }
        SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd");
        if (!value.equals("")) {
            int day = Integer.valueOf(value);
            this.calendar.set(5, day);
            mydate = dateformatter.format(this.calendar.getTime());
        } else {
            GregorianCalendar tmpcalendar = new GregorianCalendar();
            mydate = dateformatter.format(tmpcalendar.getTime());
        }
        return mydate;
    }

    public void setListener(BFilter flt) {
        this.table.addMouseListener(flt);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("<<")) {
            this.calendar.add(1, -1);
        } else if (e.getActionCommand().equals("<")) {
            this.calendar.add(2, -1);
        } else if (e.getActionCommand().equals(">")) {
            this.calendar.add(2, 1);
        } else {
            this.calendar.add(1, 1);
        }
        this.showCalendar();
    }
}

