/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.baraza.utils.BCipher;
import org.baraza.xml.BElement;

public class BBrowser
extends JPanel
implements HyperlinkListener {
    JEditorPane editorPane;
    HTMLEditorKit kit;
    CookieManager cm;
    String baseURL;
    String linkfield;
    String blankpage;
    String disabled;
    String access_cipher;
    URL myurl;
    JScrollPane editorScrollPane;

    public BBrowser(BElement view) {
        super(new BorderLayout());
        this.baseURL = view.getAttribute("baseurl");
        this.blankpage = view.getAttribute("blankpage");
        this.disabled = view.getAttribute("disabled");
        this.linkfield = view.getAttribute("linkfield", "actionvalue");
        this.access_cipher = view.getAttribute("access_cipher");
        if (this.access_cipher != null) {
            this.access_cipher = BCipher.encrypt("ToWeRs20", this.access_cipher);
        }
        this.cm = new CookieManager();
        this.cm.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(this.cm);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.editorPane.setEditorKit(this.kit);
        this.editorPane.addHyperlinkListener(this);
        this.editorScrollPane = new JScrollPane(this.editorPane);
        this.editorScrollPane.setVerticalScrollBarPolicy(22);
        super.add((Component)this.editorScrollPane, "Center");
    }

    public void setPage(String key) {
        String myws = this.baseURL + "&" + this.linkfield + "=" + key;
        if (this.blankpage != null) {
            myws = myws + "&blankpage=" + this.blankpage;
        }
        if (this.disabled != null) {
            myws = myws + "&disabled=" + this.disabled;
        }
        if (this.access_cipher != null) {
            myws = myws + "&_access_cipher=" + this.access_cipher;
        }
        this.setURL(myws);
    }

    public void setURL(String strURL) {
        try {
            URL lURL = new URL(strURL);
            this.setURL(lURL);
        }
        catch (MalformedURLException ex) {
            System.err.println("Attempted to read a bad URL: " + ex);
        }
    }

    public void setURL(URL myurl) {
        try {
            if (myurl != null) {
                this.editorPane.setPage(myurl);
            } else {
                System.err.println("Couldn't find file: mhealth");
            }
        }
        catch (IOException ex) {
            System.err.println("Attempted to read a bad URL: " + ex);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            System.out.println(ev.getURL());
            this.setURL(ev.getURL());
        }
    }
}

