/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTranslations;
import org.baraza.DB.BUser;
import org.baraza.xml.BElement;

public class BWebBody
extends BQuery {
    boolean selectAll = false;
    Integer languageId = null;
    Integer orgId = null;
    BTranslations translations = null;

    public BWebBody(BDB db, BElement view, String wheresql, String orderby, BTranslations translations) {
        super(db, view, wheresql, orderby, false);
        BUser user = db.getUser();
        if (user != null) {
            this.orgId = user.getUserOrgId();
            this.languageId = user.getLanguageId();
        }
        this.translations = translations;
    }

    public String getGrid(List<String> viewKeys, List<String> viewData, boolean addJSc, String viewKey, boolean sfield) {
        StringBuffer myhtml = new StringBuffer();
        String viewTab = viewKeys.get(1);
        String dispStr = "";
        String colWidths = null;
        String groupTable = null;
        boolean hasAction = false;
        boolean hasSubs = false;
        boolean hasTitle = false;
        boolean hasFilter = false;
        int colNums = 0;
        String filterName = this.view.getAttribute("filter", "filterid");
        for (BElement el : this.view.getElements()) {
            if (el.getName().equals("ACTIONS")) {
                hasAction = true;
            }
            if (el.getName().equals("GRID") || el.getName().equals("FORM") || el.getName().equals("JASPER")) {
                hasSubs = true;
            }
            if (el.getName().equals("TABLEVIEW") || el.getName().equals("FILES") || el.getName().equals("DIARY")) {
                hasSubs = true;
            }
            if (el.getName().equals("COLFIELD") || el.getName().equals("TITLEFIELD")) {
                hasTitle = true;
            }
            if (!el.getName().equals("FILTERGRID")) continue;
            hasFilter = true;
        }
        if (this.view.getName().equals("FORMVIEW")) {
            myhtml.append("<div class='table-scrollable'>\n");
            myhtml.append("<table class='table table-striped table-hover'>\n");
            myhtml.append("\n<thead>\n<tr>");
            myhtml.append("\n<th width='150'></th>");
            myhtml.append("\n<th width='350'></th>");
            addJSc = false;
        } else {
            myhtml.append("<div class='table-scrollable'>\n");
            myhtml.append("<table class='table table-bordered table-striped table-condensed flip-content'>\n");
            myhtml.append("\n<thead>\n<tr>");
            if (hasAction && this.keyField != null) {
                myhtml.append("\n<th data-field='ID'>ID</th>");
                colWidths = ",\ncolumns: [ { field: 'ID', width: '50px', sortable: false, filterable: false }";
            }
            for (BElement el : this.view.getElements()) {
                if (el.getName().equals("BROWSER")) {
                    myhtml.append("\n<th data-field='BROWSER'");
                    myhtml.append(">" + el.getAttribute("title") + "</th>");
                    ++colNums;
                    colWidths = colWidths == null ? ",\ncolumns: [ " : colWidths + ", \n";
                    colWidths = colWidths + "{ field: 'BROWSER', width: '75px', sortable: false, filterable: false }";
                    continue;
                }
                if (el.getValue().equals("")) continue;
                String colw = el.getAttribute("w", "100");
                myhtml.append("\n<th data-field='" + el.getValue() + "'");
                myhtml.append(">" + el.getAttribute("title") + "</th>");
                ++colNums;
                if (el.getName().equals("COLFIELD") || el.getName().equals("TITLEFIELD")) {
                    groupTable = groupTable == null ? " group: {field: '" + el.getValue() + "'" : groupTable + ", field: '" + el.getValue() + "' ";
                }
                colWidths = colWidths == null ? ",\ncolumns: [ " : colWidths + ", \n";
                colWidths = colWidths + "{ field: '" + el.getValue() + "', width: '" + colw + "px'";
                colWidths = colWidths + ", title: '" + el.getAttribute("title") + "', sortable: true, filterable: true}";
            }
            boolean hasGo = false;
            if (sfield) {
                hasGo = true;
            }
            if (hasSubs && this.keyField != null) {
                hasGo = true;
            }
            if (this.view.getName().equals("FILTERGRID") && this.keyField != null) {
                hasGo = true;
                if (hasFilter) {
                    hasSubs = true;
                }
            }
            if (hasGo) {
                myhtml.append("\n<th data-field='GO'>Go</th>");
                colWidths = colWidths + ", \n{ field: 'GO', width: '75px', sortable: false, filterable: false }";
            }
            if (this.view.getName().equals("FILES")) {
                if (this.view.getAttribute("edit", "true").equals("true")) {
                    myhtml.append("\n<th data-field='DELETE'>Delete</th>");
                    colWidths = colWidths + ", \n{ field: 'DELETE', width: '75px', sortable: false, filterable: false }";
                }
                myhtml.append("\n<th data-field='VIEW'>View</th>");
                colWidths = colWidths + ", \n{ field: 'VIEW', width: '75px', sortable: false, filterable: false }";
            }
            myhtml.append("\n</tr>");
            myhtml.append("\n</thead>");
        }
        myhtml.append("\n<tbody>");
        if (this.rs == null) {
            myhtml.append("\n</tbody>");
            myhtml.append("\n<tr><td colspan='" + Integer.toString(colNums) + "'>Data error</td></tr>");
            myhtml.append("\n</table>");
            return myhtml.toString();
        }
        try {
            this.rs.beforeFirst();
            int row = 0;
            boolean plain = false;
            String titlefield = "";
            String[] colspanfield = new String[colNums];
            for (int k = 0; k < colNums; ++k) {
                colspanfield[k] = "";
            }
            while (this.rs.next()) {
                if (this.view.getName().equals("FORMVIEW")) {
                    myhtml.append("\n<tr bgcolor='#000077'><td></td><td></td></tr>");
                } else {
                    myhtml.append("\n<tr>");
                }
                ++row;
                if (!hasTitle && hasAction && this.keyField != null) {
                    myhtml.append("\n<td>");
                    myhtml.append("<input type='checkbox' name='keyfield' ");
                    if (this.selectAll) {
                        myhtml.append("checked ");
                    }
                    myhtml.append("size='10' value='" + this.rs.getString(this.keyField) + "'/>");
                    myhtml.append("</td>");
                }
                int col = 0;
                dispStr = "";
                for (BElement el : this.view.getElements()) {
                    if (this.view.getName().equals("FORMVIEW") && !el.getValue().equals("")) {
                        if (col != 0) {
                            myhtml.append("\n<tr>");
                        }
                        myhtml.append("<td>" + el.getAttribute("title") + "</td>");
                    }
                    if (hasTitle && col == 1 && hasAction && this.keyField != null) {
                        myhtml.append("\n<td>");
                        myhtml.append("<input type='checkbox' name='keyfield' ");
                        if (this.selectAll) {
                            myhtml.append("checked ");
                        }
                        myhtml.append("size='10' value='" + this.rs.getString(this.keyField) + "'>");
                        myhtml.append("</td>");
                    }
                    if (el.getValue().equals("")) continue;
                    String cellData = this.formatData(el);
                    if (sfield) {
                        dispStr = dispStr + ", " + cellData;
                    }
                    if (el.getName().equals("COLFIELD")) {
                        myhtml.append("<td>" + cellData);
                    } else if (el.getName().equals("TITLEFIELD")) {
                        myhtml.append("<td>" + cellData);
                    } else if (el.getName().equals("EDITFIELD")) {
                        String editkey = el.getAttribute("editkey");
                        if (editkey == null) {
                            editkey = this.view.getAttribute("keyfield");
                        }
                        myhtml.append("\n<td><input type='text' name='" + el.getValue() + ":" + this.rs.getString(editkey) + "'");
                        myhtml.append(" value='" + cellData + "'");
                        myhtml.append(" class='w_50' size='" + el.getAttribute("w", "25") + "'>");
                    } else if (el.getName().equals("ACTION")) {
                        String myAction = el.getAttribute("action");
                        if (myAction == null) {
                            myAction = el.getAttribute("title");
                        }
                        myhtml.append("\n<td>");
                        myhtml.append("<input type='hidden' name='actionkey' value='" + cellData + "'/>\n");
                        myhtml.append("<button type='submit' name='actionprocess' value='" + cellData + "' class='i_cog icon small'/>\n");
                        myhtml.append(myAction + "</button>");
                    } else if (el.getName().equals("SEARCH")) {
                        String js = el.getAttribute("js", "updateForm");
                        myhtml.append("<td><input type='button' VALUE='Select' ");
                        myhtml.append("onClick=\"" + js + "('" + this.getString(this.keyField) + "', '");
                        myhtml.append(cellData + "')\">");
                    } else if (el.getName().equals("WEBDAV")) {
                        myhtml.append("\n<td><a href='webdavfiles?view=" + viewKey + "&filename=" + cellData);
                        myhtml.append("' target='_blank'>View</a>");
                    } else if (el.getName().equals("PICTURE")) {
                        String mypic = this.getString(el.getValue());
                        myhtml.append("\n<td>");
                        if (mypic != null) {
                            myhtml.append("<div style='width:" + el.getAttribute("w") + "px; height:" + el.getAttribute("h") + "px;'>");
                            myhtml.append("<img style='width:100%; height:100%' src='");
                            myhtml.append(el.getAttribute("pictures") + "?access=" + el.getAttribute("access"));
                            myhtml.append("&picture=" + mypic + "'></div>\n");
                        }
                    } else if (el.getName().equals("COMBOBOX")) {
                        String fieldValue = this.getString(el.getValue());
                        String defaultvalue = el.getAttribute("default", "");
                        String linkData = this.rs.getString(this.keyField);
                        String jsFunction = " onchange=\"readComboValue('" + el.getValue() + "','" + linkData + "', this);\" ";
                        if (el.getAttribute("linksource") != null) {
                            linkData = this.rs.getString(el.getAttribute("linksource"));
                        }
                        myhtml.append("\n<td>");
                        myhtml.append(this.getComboBox(el, linkData, true, fieldValue, defaultvalue, jsFunction));
                    } else if (el.getName().equals("BROWSER")) {
                        myhtml.append("\n<td>");
                        if (el.getAttribute("path") != null) {
                            myhtml.append("<a href='" + el.getAttribute("path"));
                        } else {
                            myhtml.append("<a href='form.jsp");
                        }
                        myhtml.append("?action=" + el.getAttribute("action"));
                        myhtml.append("&actionvalue=" + cellData);
                        if (el.getAttribute("disabled") != null) {
                            myhtml.append("&disabled=yes");
                        }
                        if (el.getAttribute("blankpage") != null) {
                            myhtml.append("&blankpage=yes' target='_blank'");
                        } else {
                            myhtml.append("'");
                        }
                        if (el.getAttribute("hint") != null) {
                            myhtml.append(" title='" + this.getString(el.getAttribute("hint")) + "'");
                        }
                        myhtml.append("><img src='assets/images/form.png'></a>");
                        myhtml.append("</td>");
                        if (this.view.getName().equals("FORMVIEW") && col != 0) {
                            myhtml.append("\n<tr>");
                        }
                        ++col;
                    } else if (el.getAttribute("details", "false").equals("true")) {
                        myhtml.append("\n<td>");
                        myhtml.append("<a href='?view=" + viewKey + ":" + this.getSelectKey() + "&data=" + this.rs.getString(this.keyField) + "' ");
                        if (el.getAttribute("hint") != null) {
                            myhtml.append(" title='" + el.getAttribute("hint") + "'");
                        }
                        myhtml.append(">" + cellData + "</a>");
                    } else if (!el.getAttribute("display", "show").equals("hide")) {
                        myhtml.append("\n<td>");
                        myhtml.append(cellData);
                    }
                    if (el.getAttribute("display", "show").equals("show")) {
                        myhtml.append("</td>");
                    }
                    if (this.view.getName().equals("FORMVIEW") && col != 0) {
                        myhtml.append("\n<tr>");
                    }
                    ++col;
                }
                if (this.view.getName().equals("FILES")) {
                    if (this.view.getAttribute("edit", "true").equals("true")) {
                        myhtml.append("\n<td><a href='delbarazafiles?view=" + viewKey + "&fileid=" + this.getString(this.keyField));
                        myhtml.append("' onclick=\"return confirm('Are you sure you want delete the file?');\"");
                        myhtml.append(" target='_blank'>Delete</a></td>");
                    }
                    myhtml.append("\n<td><a href='barazafiles?view=" + viewKey + "&fileid=" + this.getString(this.keyField));
                    myhtml.append("' target='_blank'>View</a></td>");
                }
                if (hasSubs && this.keyField != null) {
                    if (this.view.getName().equals("FORMVIEW")) {
                        if (this.view.getAttribute("gohint") != null) {
                            myhtml.append("\n<td>" + this.view.getAttribute("gohint") + "</td>");
                        } else {
                            myhtml.append("\n<td>GO</td>");
                        }
                    }
                    myhtml.append("\n<td>");
                    String sk = this.getSelectKey();
                    if (sk != null) {
                        myhtml.append("<a href='?view=" + viewKey + ":" + sk + "&data=" + this.rs.getString(this.keyField));
                        if (hasFilter) {
                            myhtml.append("&gridfilter=true");
                        }
                        myhtml.append("'");
                        if (this.view.getAttribute("gohint") != null) {
                            myhtml.append(" title='" + this.view.getAttribute("gohint") + "'");
                        }
                        myhtml.append("><img src='assets/images/go.png'></a>");
                    }
                    myhtml.append("</td>");
                }
                if (this.view.getName().equals("FILTERGRID") && this.keyField != null && !hasFilter) {
                    myhtml.append("\n<td><a href='#' OnClick=\"updateField('");
                    myhtml.append(filterName + "', '" + this.getString(this.keyField) + "')\">");
                    myhtml.append("<img src='assets/images/go.png'></a></td>");
                }
                if (sfield) {
                    myhtml.append("\n<td><input type='button' VALUE='Select' ");
                    myhtml.append("onClick=\"updateForm('" + this.getString(this.keyField) + "', '");
                    myhtml.append(dispStr + "')\"></td>");
                }
                myhtml.append("\n</tr>");
                if (this.tableLimit <= 0 || this.tableLimit >= row) continue;
                break;
            }
        }
        catch (SQLException ex) {
            this.log.severe("Web data body reading error : " + ex);
        }
        myhtml.append("\n</tbody>");
        myhtml.append("\n</table>");
        myhtml.append("</div>\n");
        String htmlBody = "";
        if (this.view.getName().equals("FILTERGRID")) {
            htmlBody = htmlBody + "\n<input type='hidden' name='" + filterName + "' id='" + filterName + "' value='0'/>";
        }
        htmlBody = htmlBody + myhtml.toString();
        return htmlBody;
    }

    public String getSelectKey() {
        Integer i = 0;
        for (BElement sview : this.view.getElements()) {
            String sviewName = sview.getName();
            if (!sviewName.equals("DIARY") && !sviewName.equals("FILES") && !sviewName.equals("FORM") && !sviewName.equals("GRID") && !sviewName.equals("JASPER") && !sviewName.equals("ACTIONS")) continue;
            String viewFilter = sview.getAttribute("viewfilter");
            if (viewFilter == null) {
                return i.toString();
            }
            String[] viewFilters = viewFilter.split(",");
            boolean show = true;
            for (String vfs : viewFilters) {
                String[] vsp = vfs.split("=");
                if (vsp[1].equals(this.getString(vsp[0]))) continue;
                show = false;
            }
            if (show) {
                return i.toString();
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return null;
    }

    public String getForm(boolean isNew, String formLinkData, HttpServletRequest request) {
        boolean eof = false;
        boolean isTabs = false;
        StringBuilder response = new StringBuilder();
        StringBuilder tabs = new StringBuilder();
        String formname = this.view.getAttribute("name");
        String canedit = this.view.getAttribute("canedit");
        String currentTab = "";
        if (!isNew && this.rs != null) {
            this.beforeFirst();
            eof = this.moveNext();
        }
        String tab = "";
        boolean hasTabs = false;
        tabs.append("<div class='row'>\n");
        tabs.append("\t<div class='col-md-12'>\n");
        tabs.append("\t\t<div class='tabbable portlet-tabs'>\n");
        tabs.append("\t\t\t<ul class='nav nav-tabs'>\n");
        for (BElement el : this.view.getElements()) {
            if (el.getAttribute("tab") == null) continue;
            if (!tab.equals(el.getAttribute("tab"))) {
                tab = el.getAttribute("tab");
                if (!hasTabs) {
                    tabs.append("<li class='active'>");
                } else {
                    tabs.append("<li>");
                }
                tabs.append("<a href='#" + tab.replace(" ", "") + "' data-toggle='tab'>" + tab + " </a></li>\n");
            }
            hasTabs = true;
        }
        tabs.append("\t\t\t</ul>\n");
        tabs.append("\t\t</div>\n");
        tabs.append("\t</div>\n");
        tabs.append("</div>\n");
        tabs.append("<div class='tab-content'>\n");
        boolean i = false;
        response.append("<div class='form-body'>\n");
        boolean noSpan = true;
        boolean tabNotDone = true;
        Integer formCols = new Integer(this.view.getAttribute("cols", "1"));
        tab = "";
        for (BElement el : this.view.getElements()) {
            if (el.getAttribute("tab") != null) {
                if (!tabNotDone && !tab.equals(el.getAttribute("tab"))) {
                    response.append("</div>");
                }
                if (tabNotDone && hasTabs) {
                    response.append((CharSequence)tabs);
                }
                if (!tab.equals(el.getAttribute("tab"))) {
                    tab = el.getAttribute("tab");
                    if (tabNotDone) {
                        response.append("<div class='tab-pane active' id='" + tab.replace(" ", "") + "'>\n");
                    } else {
                        response.append("<div class='tab-pane' id='" + tab.replace(" ", "") + "'>\n");
                    }
                }
                if (tabNotDone && hasTabs) {
                    tabNotDone = false;
                }
            } else if (!tabNotDone) {
                response.append("</div>\n</div>\n");
                tabNotDone = true;
            }
            boolean forForm = true;
            String elName = el.getName();
            if (elName.equals("USERFIELD") || elName.equals("USERNAME") || elName.equals("REMOTEIP") || elName.equals("DEFAULT") || elName.equals("FUNCTION")) {
                forForm = false;
            }
            if (noSpan) {
                response.append("<div class='row'>\n");
            }
            if (forForm) {
                response.append(this.getField(el, formLinkData, eof, formCols));
            }
            if (el.getAttribute("span") == null) {
                response.append("</div>\n");
                noSpan = true;
                continue;
            }
            noSpan = false;
        }
        if (!noSpan) {
            response.append("</div>\n");
        }
        if (!tabNotDone && tab.equals("")) {
            response.append("</div>\n");
        }
        if (!tabNotDone) {
            response.append("</div>\n");
        }
        response.append("</div>\n");
        return response.toString();
    }

    public String getField(BElement el, String formLinkData, boolean eof, Integer formCols) {
        StringBuilder response = new StringBuilder();
        String defaultvalue = el.getAttribute("default", "");
        String default_fnct = el.getAttribute("default_fnct");
        String default_org_fnct = el.getAttribute("default_org_fnct");
        String default_user = el.getAttribute("default_user");
        if (default_fnct != null) {
            if (default_fnct.indexOf("(") > 1) {
                this.db.executeFunction("SELECT " + default_fnct + ", '" + this.db.getUserID() + "')");
            } else {
                defaultvalue = this.db.executeFunction("SELECT " + default_fnct + "('" + this.db.getUserID() + "')");
            }
        } else if (default_org_fnct != null) {
            defaultvalue = default_org_fnct.indexOf("(") > 1 ? this.db.executeFunction("SELECT " + default_org_fnct + ", " + this.userOrg + ")") : this.db.executeFunction("SELECT " + default_org_fnct + "(" + this.userOrg + ")");
        } else if (default_user != null) {
            defaultvalue = this.db.getUserID();
        }
        Integer w = new Integer(el.getAttribute("w", "150"));
        if (formCols > 1 && w < 400) {
            response.append("  <div class='col-md-6'>\n");
        }
        response.append("\t<div class='form-group'>\n");
        String fieldTitle = el.getAttribute("title", "");
        if (el.getAttribute("lang") != null) {
            fieldTitle = this.translations.getTitle(this.orgId, this.languageId, el.getAttribute("lang"), fieldTitle);
        }
        if (el.getAttribute("tab") == null) {
            response.append("\t\t<label class='control-label col-md-3'>" + fieldTitle + "</label>\n");
        } else if (el.getAttribute("title") != null) {
            response.append("\t\t<label class='control-label col-md-3'>" + fieldTitle + "</label>\n");
        }
        response.append("\t\t<div class='col-md-9'>\n");
        if (el.getName().equals("HTML")) {
            response.append(el.getAttribute("html", ""));
        } else if (el.getName().equals("TEXTFIELD")) {
            response.append("<input name='" + el.getValue() + "'");
            if (el.getAttribute("type") == null) {
                response.append(" type='text'");
            } else {
                response.append(" type='" + el.getAttribute("type") + "'");
            }
            if (el.getAttribute("class") == null) {
                response.append(" class='form-control'");
            } else {
                response.append(" class='" + el.getAttribute("class") + "'");
            }
            if (el.getAttribute("w") != null) {
                response.append(" size='" + el.getAttribute("w") + "'");
            } else {
                response.append(" size='50'");
            }
            if (el.getAttribute("style") != null) {
                response.append(" style='" + el.getAttribute("style") + "'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("tooltip") != null) {
                response.append(" title='" + el.getAttribute("tooltip") + "'");
            }
            if (el.getAttribute("placeholder") != null) {
                response.append(" placeholder='" + el.getAttribute("placeholder") + "'");
            }
            if (el.getAttribute("maxlength") != null) {
                response.append(" maxlength='" + el.getAttribute("maxlength") + "'");
            }
            if (el.getAttribute("data-instant") != null) {
                response.append(" data-instant='" + el.getAttribute("data-instant") + "'");
            }
            if (el.getAttribute("data-min") != null) {
                response.append(" data-min='" + el.getAttribute("data-min") + "'");
            }
            if (el.getAttribute("data-max") != null) {
                response.append(" data-max='" + el.getAttribute("data-max") + "'");
            }
            if (el.getAttribute("data-step") != null) {
                response.append(" data-step='" + el.getAttribute("data-step") + "'");
            }
            if (el.getAttribute("data-start") != null) {
                response.append(" data-start='" + el.getAttribute("data-start") + "'");
            }
            if (el.getAttribute("data-regex") != null) {
                response.append(" data-regex='" + el.getAttribute("data-regex") + "'");
            }
            if (el.getAttribute("data-timeformat") != null) {
                response.append(" data-timeformat='" + el.getAttribute("data-timeformat") + "'");
            }
            if (el.getAttribute("data-errortext") != null) {
                response.append(" data-errortext='" + el.getAttribute("data-errortext") + "'");
            }
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true' ");
            }
            if (el.getAttribute("js_function") != null) {
                String tgt = el.getAttribute("target", "");
                response.append(" onblur=\"custom_javascript(this,'" + el.getAttribute("js_function") + "','" + tgt + "')\" ");
            }
            if (el.getAttribute("ajaxfunction") != null) {
                String ajx_fxn = el.getAttribute("ajaxfunction");
                response.append(" onBlur=\"javascript:callServer('" + ajx_fxn + "',this.value,'" + el.getValue() + "','" + el.getAttribute("from") + "')\"");
            }
            if (eof) {
                response.append(" value='" + this.formatData(el).replace("'", "&#39;") + "'");
            } else {
                response.append(" value='" + defaultvalue + "'");
            }
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            response.append("/>\n");
        } else if (el.getName().equals("TEXTAREA")) {
            String fieldValue = "";
            fieldValue = eof ? this.formatData(el).replace("'", "&#39;") : defaultvalue;
            response.append("<textarea name='" + el.getValue() + "'");
            if (el.getAttribute("class") == null) {
                response.append(" class='form-control'");
            } else {
                response.append(" class='" + el.getAttribute("class") + "'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("placeholder") != null) {
                response.append(" placeholder='" + el.getAttribute("placeholder") + "'");
            }
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true' ");
            }
            response.append(" cols='" + el.getAttribute("cols", "50"));
            response.append("' rows='" + el.getAttribute("rows", "10") + "'>");
            response.append(fieldValue);
            response.append("</textarea>\n");
        } else if (el.getName().equals("EDITOR")) {
            String fieldValue = "";
            fieldValue = eof ? this.formatData(el).replace("'", "&#39;") : el.getAttribute("default", "");
            response.append("<textarea class='ckeditor form-control' name='" + el.getValue() + "'");
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("placeholder") != null) {
                response.append(" placeholder='" + el.getAttribute("placeholder") + "'");
            }
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            response.append(" cols='" + el.getAttribute("cols", "50"));
            response.append("' rows='" + el.getAttribute("rows", "10") + "'>");
            response.append(fieldValue);
            response.append("</textarea>");
        } else if (el.getName().equals("PASSWORD")) {
            response.append("<input type='password' name='" + el.getValue() + "' class='form-control' size='50'/>\n");
        } else if (el.getName().equals("GRIDBOX")) {
            String fieldValue = null;
            if (eof) {
                fieldValue = this.getString(el.getValue());
            }
            response.append(this.getComboBox(el, formLinkData, eof, fieldValue, defaultvalue, null));
        } else if (el.getName().equals("COMBOBOX")) {
            String fieldValue = null;
            if (eof) {
                fieldValue = this.getString(el.getValue());
            }
            response.append(this.getComboBox(el, formLinkData, eof, fieldValue, defaultvalue, null));
        } else if (el.getName().equals("MULTISELECT")) {
            String orderBySql;
            response.append("<select name='" + el.getValue() + "' multiple='multiple' ");
            if (el.getAttribute("class") == null) {
                response.append(" class='multi-select form-control'");
            } else {
                response.append(" class='" + el.getAttribute("class") + "'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true' ");
            }
            response.append(">");
            String nodefault = el.getAttribute("nodefault");
            String lptable = el.getAttribute("lptable");
            String lpfield = el.getAttribute("lpfield");
            String lpkey = el.getAttribute("lpkey");
            String cmb_fnct = el.getAttribute("cmb_fnct");
            if (lpkey == null) {
                lpkey = el.getValue();
            }
            String mysql = "";
            mysql = lpkey.equals(lpfield) ? "SELECT " + lpfield + " FROM " + lptable : (cmb_fnct == null ? "SELECT " + lpkey + ", " + lpfield + " FROM " + lptable : "SELECT " + lpkey + ", (" + cmb_fnct + ") as " + lpfield + " FROM " + lptable);
            String cmbWhereSql = el.getAttribute("where");
            if (el.getAttribute("noorg") == null && this.orgID != null && this.userOrg != null) {
                cmbWhereSql = cmbWhereSql == null ? "(" : cmbWhereSql + " AND (";
                cmbWhereSql = cmbWhereSql + this.orgID + "=" + this.userOrg + ")";
            }
            if (el.getAttribute("user") != null) {
                String userFilter = "(" + el.getAttribute("user") + " = '" + this.db.getUserID() + "')";
                cmbWhereSql = cmbWhereSql == null ? userFilter : cmbWhereSql + " AND " + userFilter;
            }
            String tableFilter = null;
            String linkField = el.getAttribute("linkfield");
            if (linkField != null && formLinkData != null) {
                tableFilter = el.getAttribute("linkfnct") == null ? linkField + " = '" + formLinkData + "'" : linkField + " = " + el.getAttribute("linkfnct") + "('" + formLinkData + "')";
                cmbWhereSql = cmbWhereSql == null ? "(" + tableFilter + ")" : cmbWhereSql + " AND (" + tableFilter + ")";
            }
            if (cmbWhereSql != null) {
                mysql = mysql + " WHERE " + cmbWhereSql;
            }
            mysql = (orderBySql = el.getAttribute("orderby")) == null ? mysql + " ORDER BY " + lpfield : mysql + " ORDER BY " + orderBySql;
            if (nodefault != null) {
                response.append("<option></option>");
            }
            BQuery cmbrs = new BQuery(this.db, mysql);
            while (cmbrs.moveNext()) {
                response.append("<option");
                if (eof) {
                    if (this.getString(el.getValue()) != null && this.getString(el.getValue()).equals(cmbrs.getString(lpkey))) {
                        response.append(" selected='selected'");
                    }
                } else if (cmbrs.getString(lpkey).equals(defaultvalue)) {
                    response.append(" selected='selected'");
                }
                response.append(" value='" + cmbrs.getString(lpkey));
                response.append("'>" + cmbrs.getString(lpfield) + "</option>\n");
            }
            cmbrs.close();
            response.append("</select>\n");
        } else if (el.getName().equals("COMBOLIST")) {
            response.append("<select name='" + el.getValue() + "'");
            if (el.getAttribute("class") == null) {
                response.append(" class='form-control'");
            } else {
                response.append(" class='" + el.getAttribute("class") + "'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true' ");
            }
            response.append(">");
            String myval = null;
            String mykey = "";
            myval = eof ? this.getString(el.getValue()) : defaultvalue;
            for (BElement ell : el.getElements()) {
                mykey = ell.getAttribute("key", ell.getValue());
                response.append("<option");
                if (ell.getAttribute("key") != null) {
                    response.append(" value='" + mykey + "'");
                }
                if (mykey.equals(myval)) {
                    response.append(" selected='selected'");
                }
                response.append(">" + ell.getValue() + "</option>");
            }
            response.append("</select>\n");
        } else if (el.getName().equals("CHECKBOX")) {
            response.append("<input type='checkbox' name='" + el.getValue() + "'");
            response.append(" value='true'");
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (eof) {
                if (this.getBoolean(el.getValue()).booleanValue()) {
                    response.append(" checked");
                }
            } else if (el.getAttribute("default", "").equals("true")) {
                response.append(" checked");
            }
            response.append("/>\n");
        } else if (el.getName().equals("FILE")) {
            response.append("<input class='form-control' type='file' name='" + el.getValue() + "' size='50'/></td>\n");
        } else if (el.getName().equals("TEXTDATE")) {
            if (el.getAttribute("type", "1").equals("2")) {
                response.append("<div class='input-group input-medium date date-picker2' data-date-format='dd-mm-yyyy' data-date-viewmode='years'>\n");
            } else {
                response.append("<div class='input-group input-medium date date-picker' data-date-format='dd-mm-yyyy' data-date-viewmode='years'>\n");
            }
            response.append("<input class='form-control' name='" + el.getValue() + "'");
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true' ");
            }
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("placeholder") != null) {
                response.append(" placeholder='" + el.getAttribute("placeholder") + "'");
            }
            if (eof) {
                SimpleDateFormat dateformatter = new SimpleDateFormat("dd/MM/yyyy");
                if (this.getString(el.getValue()) != null) {
                    String mydate = dateformatter.format(this.getDate(el.getValue()));
                    response.append(" value='" + mydate + "'");
                }
            } else if (el.getAttribute("default", "").equals("now")) {
                SimpleDateFormat dateParse = new SimpleDateFormat("dd/MM/yyyy");
                response.append(" value='" + dateParse.format(new Date()) + "'");
            } else if (el.getAttribute("default", "").equals("today")) {
                SimpleDateFormat dateParse = new SimpleDateFormat("dd/MM/yyyy");
                response.append(" value='" + dateParse.format(new Date()) + "'");
            } else if (!defaultvalue.equals("")) {
                response.append(" value='" + defaultvalue + "'");
            }
            response.append(" size='50'/>");
            response.append("<span class='input-group-btn'>");
            response.append("<button class='btn default' type='button'><i class='fa fa-calendar'></i></button>");
            response.append("</span>\n");
            response.append("</div>\n");
        } else if (el.getName().equals("TEXTDECIMAL")) {
            response.append("<input class='form-control mask_currency' type='text' name='" + el.getValue() + "'");
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = true ");
            }
            if (el.getAttribute("placeholder") != null) {
                response.append(" placeholder='" + el.getAttribute("placeholder") + "'");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (el.getAttribute("js_function") != null) {
                String tgt = el.getAttribute("target", "");
                response.append(" onblur=\"custom_javascript(this,'" + el.getAttribute("js_function") + "','" + tgt + "')\" ");
            }
            if (el.getAttribute("ajaxfunction") != null) {
                String ajx_fxn = el.getAttribute("ajaxfunction");
                response.append(" onBlur=\"javascript:callServer('" + ajx_fxn + "',this.value,'" + el.getValue() + "','" + el.getAttribute("from") + "')\"");
            }
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            if (eof) {
                response.append(" value=\"" + this.formatData(el) + "\"");
            } else {
                response.append(" value='" + el.getAttribute("default", "") + "'");
            }
            response.append(" size='50'/>\n");
        } else if (el.getName().equals("TEXTTIMESTAMP")) {
            response.append("<input class='form-control' type='text' name='" + el.getValue() + "'");
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true' ");
            }
            if (el.getAttribute("id") != null) {
                response.append(" id='" + el.getAttribute("id") + "'");
            }
            if (eof) {
                SimpleDateFormat dateformatter = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
                if (this.getString(el.getValue()) != null) {
                    String mydate = dateformatter.format(this.getDate(el.getValue()));
                    response.append(" value=\"" + mydate + "\"");
                }
            }
            response.append(" size='50'/>\n");
        } else if (el.getName().equals("SPINTIME")) {
            response.append("<div class='input-group input-medium '>\n");
            if (el.getAttribute("type", "2").equals("1")) {
                response.append("\t<input type='text' class='form-control clockface'");
            } else if (el.getAttribute("type", "2").equals("2")) {
                response.append("\t<input type='text' class='form-control timepicker timepicker-no-seconds'");
            } else if (el.getAttribute("type", "2").equals("3")) {
                response.append("\t<input type='text' class='form-control timepicker timepicker-24'");
            } else {
                response.append("\t<input type='text' class='form-control timepicker timepicker-24'");
            }
            response.append(" readonly='' name='" + el.getValue() + "' id='" + el.getValue() + "'");
            if (el.getAttribute("enabled", "true").equals("false")) {
                response.append(" disabled='true'");
            }
            if (el.getAttribute("required", "false").equals("true")) {
                response.append(" required = 'true'");
            }
            if (eof) {
                SimpleDateFormat dateformatter = new SimpleDateFormat("hh:mm a");
                if (this.getString(el.getValue()) != null) {
                    String mydate = dateformatter.format(this.getTime(el.getValue()));
                    response.append(" value='" + mydate + "'");
                }
            } else if (el.getAttribute("default", "").equals("now")) {
                SimpleDateFormat dateParse = new SimpleDateFormat("hh:mm a");
                response.append(" value='" + dateParse.format(new Date()) + "'");
            } else if (el.getAttribute("default") != null) {
                response.append(" value='" + el.getAttribute("default") + "'");
            }
            response.append("/>\n");
            response.append("\t<span class='input-group-btn'>\n");
            if (el.getAttribute("type", "2").equals("1")) {
                response.append("\t\t<button class='btn default clockface-toggle' data-target='" + el.getValue() + "' type='button'>");
                response.append("<i class='fa fa-clock-o'></i></button>\n");
            } else {
                response.append("\t\t<button class='btn default' type='button'></button>\n");
            }
            response.append("\t</span>\n");
            response.append("</div>\n");
        } else if (el.getName().equals("PICTURE")) {
            String mypic = null;
            String mypiclink = "\t<div class='fileinput-preview thumbnail' data-trigger='fileinput' style='width: 200px; height: 150px;'></div>";
            if (eof && (mypic = this.getString(el.getValue())) != null) {
                mypiclink = "\t<div><img height='" + el.getAttribute("h") + "px' width='auto' src='";
                mypiclink = mypiclink + "barazapictures?access=" + el.getAttribute("access");
                mypiclink = mypiclink + "&picture=" + mypic + "'></div>";
            }
            response.append("<div class='fileinput fileinput-new' data-provides='fileinput'>");
            response.append(mypiclink);
            response.append("\t<div>");
            response.append("\t\t<span class='btn default btn-file'>");
            response.append("\t\t<span class='fileinput-new'> Select image </span>");
            response.append("\t\t<span class='fileinput-exists'> Change </span> <input type='file' name='" + el.getValue() + "'> </span>");
            response.append("\t\t<a href='javascript:;' class='btn red fileinput-exists' data-dismiss='fileinput'> Remove </a>");
            response.append("\t</div>");
            response.append("</div>");
        } else if (el.getName().equals("USERFIELD") || el.getName().equals("DEFAULT") || el.getName().equals("FUNCTION")) {
            // empty if block
        }
        response.append("\t\t</div>\n");
        response.append("\t</div>\n");
        if (formCols > 1 && w < 400) {
            response.append("  </div>\n");
        }
        return response.toString();
    }

    public String getComboBox(BElement el, String formLinkData, boolean eof, String fieldValue, String defaultvalue, String jsFunction) {
        String orderBySql;
        StringBuilder response = new StringBuilder();
        response.append("<select name='" + el.getValue() + "'");
        if (el.getAttribute("id") != null) {
            response.append(" id='" + el.getAttribute("id") + "'");
        }
        if (el.getAttribute("required", "false").equals("true")) {
            response.append(" required = 'true' ");
        }
        if (jsFunction != null) {
            response.append(jsFunction);
        }
        if (el.getAttribute("class") == null) {
            response.append(" class='select2me form-control");
        } else {
            response.append(" class='" + el.getAttribute("class"));
        }
        if (el.getAttribute("select.detail") != null) {
            response.append(" detailed-select ");
        }
        response.append("'>\n");
        String selectDetail = el.getAttribute("select.detail");
        String selectNone = el.getAttribute("select.none");
        String nodefault = el.getAttribute("nodefault");
        String defaultSelect = el.getAttribute("default.select");
        String lptable = el.getAttribute("lptable");
        String lpfield = el.getAttribute("lpfield");
        String lpkey = el.getAttribute("lpkey");
        String cmb_fnct = el.getAttribute("cmb_fnct");
        if (lpkey == null) {
            lpkey = el.getValue();
        }
        String mysql = "";
        mysql = lpkey.equals(lpfield) ? "SELECT " + lpfield : (cmb_fnct == null ? "SELECT " + lpkey + ", " + lpfield : "SELECT " + lpkey + ", (" + cmb_fnct + ") as " + lpfield);
        if (selectDetail != null) {
            mysql = mysql + ", " + selectDetail;
        }
        mysql = mysql + " FROM " + lptable;
        String cmbWhereSql = el.getAttribute("where");
        if (el.getAttribute("noorg") == null && this.orgID != null && this.userOrg != null) {
            cmbWhereSql = cmbWhereSql == null ? "(" : cmbWhereSql + " AND (";
            cmbWhereSql = el.getAttribute("org.id") == null ? cmbWhereSql + this.orgID + "=" + this.userOrg + ")" : cmbWhereSql + el.getAttribute("org.id") + "=" + this.userOrg + ")";
        }
        if (el.getAttribute("user") != null) {
            String userFilter = "(" + el.getAttribute("user") + " = '" + this.db.getUserID() + "')";
            cmbWhereSql = cmbWhereSql == null ? userFilter : cmbWhereSql + " AND " + userFilter;
        }
        String tableFilter = null;
        String linkField = el.getAttribute("linkfield");
        if (linkField != null && formLinkData != null) {
            tableFilter = el.getAttribute("linkfnct") == null ? linkField + " = '" + formLinkData + "'" : linkField + " = " + el.getAttribute("linkfnct") + "('" + formLinkData + "')";
            cmbWhereSql = cmbWhereSql == null ? "(" + tableFilter + ")" : cmbWhereSql + " AND (" + tableFilter + ")";
        }
        if (cmbWhereSql != null) {
            mysql = mysql + " WHERE " + cmbWhereSql;
        }
        mysql = (orderBySql = el.getAttribute("orderby")) == null ? mysql + " ORDER BY " + lpfield : mysql + " ORDER BY " + orderBySql;
        if (selectNone != null && !eof) {
            response.append("<option disabled selected value>Select</option>");
        }
        if (nodefault != null && !eof) {
            response.append("<option></option>");
        }
        if (defaultSelect != null) {
            if (!eof) {
                response.append("<option>" + defaultSelect + "</option>");
            }
            if (eof && fieldValue == null) {
                response.append("<option>" + defaultSelect + "</option>");
            }
            if (el.getAttribute("default.value") != null && el.getAttribute("default.value").equals(fieldValue)) {
                response.append("<option>" + defaultSelect + "</option>");
            }
        }
        BQuery cmbrs = new BQuery(this.db, mysql);
        while (cmbrs.moveNext()) {
            String sdc;
            String lpKeyValue = cmbrs.getString(lpkey);
            if (lpKeyValue == null) {
                lpKeyValue = "";
            }
            response.append("<option");
            if (eof) {
                if (fieldValue != null && fieldValue.equals(lpKeyValue)) {
                    response.append(" selected='selected'");
                }
            } else if (lpKeyValue.equals(defaultvalue)) {
                response.append(" selected='selected'");
            }
            if (selectDetail != null && (sdc = cmbrs.getString(selectDetail)) != null) {
                response.append(" data-detail='" + sdc.replaceAll("'", "&#39;") + "'");
            }
            response.append(" value='" + lpKeyValue);
            response.append("'>" + cmbrs.getString(lpfield) + "</option>\n");
        }
        cmbrs.close();
        response.append("</select>\n");
        return response.toString();
    }

    public void setSelectAll() {
        this.selectAll = true;
    }
}

