/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;

public class BUser {
    Integer orgID = null;
    String orgName = "";
    String webLogos = "";
    Integer languageId = null;
    String userIP = null;
    String userName = null;
    String userID = null;
    String groupID = null;
    String entityName = null;
    String entityType = null;
    String startView = null;
    String groupIDs = null;
    List<String> groupRole;
    List<String> userRole;
    List<String> accessLevels;
    boolean nullUser = false;
    boolean superUser = false;

    public BUser(BDB db, String userIP, String userName, boolean newUser) {
        this.userIP = userIP;
        this.userName = userName;
        this.groupRole = new ArrayList<String>();
        this.userRole = new ArrayList<String>();
        this.accessLevels = new ArrayList<String>();
        this.userID = "0";
        this.entityName = "root";
        this.entityType = "0";
        this.nullUser = true;
        this.orgID = new Integer(0);
        this.orgName = "default";
        this.webLogos = "";
    }

    public BUser(BDB db, String userIP, String userName, String userId) {
        this.makeUser(db, userIP, userName);
        String insSql = "INSERT INTO sys_logins (entity_id, login_ip) VALUES ('" + userId + "', '" + userIP + "')";
        db.executeQuery(insSql);
    }

    public BUser(BDB db, String userIP, String userName) {
        this.makeUser(db, userIP, userName);
    }

    public void makeUser(BDB db, String userIP, String userName) {
        this.userIP = userIP;
        this.userName = userName;
        this.groupRole = new ArrayList<String>();
        this.userRole = new ArrayList<String>();
        this.accessLevels = new ArrayList<String>();
        String mySql = "SELECT entity_id, entity_type_id, org_id, sys_language_id, no_org, entity_name, super_user, entity_leader, function_role FROM entitys WHERE User_name = '" + userName + "'";
        BQuery rs = new BQuery(db, mySql);
        if (rs.moveNext()) {
            this.entityName = rs.readField("entity_name");
            this.entityType = rs.readField("entity_type_id");
            this.userID = rs.readField("entity_id");
            this.groupID = rs.readField("entity_type_id");
            this.orgID = rs.getInt("org_id");
            if (rs.getBoolean("no_org").booleanValue()) {
                this.orgID = null;
            }
            this.languageId = rs.readField("sys_language_id") == null ? new Integer(0) : new Integer(rs.getInt("sys_language_id"));
            this.superUser = rs.getBoolean("super_user");
            String functionRole = rs.readField("function_role");
            if (functionRole != null) {
                String[] functionRoles = functionRole.split(",");
                this.userRole = Arrays.asList(functionRoles);
            }
            mySql = "SELECT sys_access_levels.sys_access_level_name, sys_access_levels.access_tag FROM sys_access_levels INNER JOIN sys_access_entitys ON sys_access_levels.sys_access_level_id = sys_access_entitys.sys_access_level_id WHERE sys_access_entitys.entity_id = " + this.userID + " AND sys_access_entitys.org_id = " + this.orgID;
            BQuery alRs = new BQuery(db, mySql);
            while (alRs.moveNext()) {
                this.accessLevels.add(alRs.readField("access_tag").trim());
            }
            alRs.close();
        } else {
            this.userID = "0";
        }
        rs.close();
        this.startView = db.executeFunction("SELECT start_view FROM entity_types WHERE entity_type_id = " + this.entityType);
        if (this.startView == null) {
            this.startView = "1:0";
        }
        if (this.orgID != null) {
            String wlSql = "SELECT org_name, (CASE WHEN web_logos = true THEN '/' || org_id::text ELSE '' END) AS logo_path FROM orgs WHERE org_id = " + this.orgID;
            BQuery rsOrg = new BQuery(db, wlSql);
            if (rsOrg.moveNext()) {
                this.orgName = rsOrg.getString("org_name");
                this.webLogos = rsOrg.getString("logo_path");
            }
            rsOrg.close();
        }
        if (this.userID != null) {
            mySql = "SELECT entity_types.entity_type_id, entity_types.entity_role FROM entity_types INNER JOIN Entity_subscriptions ON entity_types.entity_type_id = Entity_subscriptions.entity_type_id WHERE Entity_subscriptions.entity_id = '" + this.userID + "'";
            rs = new BQuery(db, mySql);
            while (rs.moveNext()) {
                this.groupRole.add(rs.readField("entity_role"));
                if (this.groupIDs == null) {
                    this.groupIDs = rs.readField("entity_type_id");
                    continue;
                }
                this.groupIDs = this.groupIDs + "," + rs.readField("entity_type_id");
            }
            rs.close();
        }
        if (this.groupIDs == null) {
            this.groupIDs = "";
        }
        if (this.userID == null) {
            this.userID = "0";
        }
    }

    public boolean checkAccess(String role, String access) {
        if (role == null && access == null) {
            return true;
        }
        boolean hasAccess = false;
        if (this.superUser) {
            hasAccess = true;
        } else if (role != null) {
            String[] mRoles;
            for (String mRole : mRoles = role.split(",")) {
                if (!this.userRole.contains(mRole)) continue;
                hasAccess = true;
            }
        } else if (access != null && this.accessLevels.contains(access)) {
            hasAccess = true;
        }
        return hasAccess;
    }

    public String insAudit(String tableName, String recordID, String functionType) {
        String inssql = "INSERT INTO sys_audit_trail (user_id, user_ip, table_name, record_id, change_type) VALUES('";
        inssql = inssql + this.getUserID() + "', '" + this.getUserIP() + "', '" + tableName + "', '" + recordID + "', '" + functionType + "')";
        return inssql;
    }

    public void setUser(BDB db, String tableName, String idCol, String nameCol, String userName) {
        String mysql = "SELECT " + idCol + " FROM " + tableName;
        BQuery rs = new BQuery(db, mysql = mysql + " WHERE " + nameCol + " = '" + userName + "'");
        if (rs.moveNext()) {
            this.userID = rs.readField(idCol);
        }
        if (this.userID == null) {
            this.userID = "0";
        }
    }

    public String getOrgWhere(String orgTable) {
        String ow = "";
        orgTable = orgTable == null ? "" : orgTable + ".";
        if (this.orgID != null) {
            ow = " WHERE (" + orgTable + "org_id = " + this.orgID + ")";
        }
        return ow;
    }

    public String getOrgAnd(String orgTable) {
        String ow = "";
        orgTable = orgTable == null ? "" : orgTable + ".";
        if (this.orgID != null) {
            ow = " AND (" + orgTable + "org_id = " + this.orgID + ")";
        }
        return ow;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getUserIP() {
        return this.userIP;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getStartView() {
        return this.startView;
    }

    public boolean getSuperUser() {
        return this.superUser;
    }

    public boolean getNullUser() {
        return this.nullUser;
    }

    public List<String> getUserRoles() {
        return this.userRole;
    }

    public List<String> getGroupRoles() {
        return this.groupRole;
    }

    public List<String> getAccessLevels() {
        return this.accessLevels;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public String getGroupIDs() {
        return this.groupIDs;
    }

    public Integer getUserOrgId() {
        return this.orgID;
    }

    public String getUserOrg() {
        return this.orgID.toString();
    }

    public String getUserOrgName() {
        return this.orgName;
    }

    public Integer getLanguageId() {
        return this.languageId;
    }

    public String getWebLogos() {
        return this.webLogos;
    }
}

