/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTableLinks;
import org.baraza.DB.BUser;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BDB {
    Logger log = Logger.getLogger(BDB.class.getName());
    static Logger log2 = Logger.getLogger(BDB.class.getName());
    Connection db = null;
    DatabaseMetaData dbmd = null;
    String dbTemplate = null;
    String dbschema = null;
    int dbType = 1;
    String orgID = null;
    BUser user = null;
    BLogHandle logHandle = null;
    List<String> fullAudit = new ArrayList<String>();
    Map<String, String> configs;
    private String lastErrorMsg = null;
    private String lDBclass;
    private String lDBpath;
    private String lDBuser;
    private String lDBpassword;
    private boolean readOnly = false;

    public BDB(BElement dbconfig) {
        String dbclass = dbconfig.getAttribute("dbclass", "");
        String dbpath = dbconfig.getAttribute("dbpath", "");
        String dbusername = dbconfig.getAttribute("dbusername", "");
        String dbpassword = dbconfig.getAttribute("dbpassword", "");
        this.dbTemplate = dbconfig.getAttribute("dbtemplate");
        this.dbschema = dbconfig.getAttribute("dbschema");
        this.orgID = dbconfig.getAttribute("org");
        if (dbconfig.getAttribute("readonly", "false").equals("true")) {
            this.readOnly = true;
        }
        this.connectDB(dbclass, dbpath, dbusername, dbpassword);
    }

    public BDB(BElement dbconfig, String dbuser, String dbpassword) {
        String dbclass = dbconfig.getAttribute("dbclass", "");
        String dbpath = dbconfig.getAttribute("dbpath", "");
        this.dbTemplate = dbconfig.getAttribute("dbtemplate");
        this.dbschema = dbconfig.getAttribute("dbschema");
        this.orgID = dbconfig.getAttribute("org");
        this.connectDB(dbclass, dbpath, dbuser, dbpassword);
    }

    public BDB(String dbclass, String dbpath, String dbuser, String dbpassword) {
        this.connectDB(dbclass, dbpath, dbuser, dbpassword);
    }

    public BDB(String datasource) {
        try {
            InitialContext cxt = new InitialContext();
            DataSource ds = (DataSource)cxt.lookup(datasource);
            this.db = ds.getConnection();
            this.dbmd = this.db.getMetaData();
            String dbtype = this.dbmd.getDatabaseProductName();
            if (dbtype.toLowerCase().indexOf("oracle") >= 0) {
                this.dbType = 2;
            }
            if (dbtype.toLowerCase().indexOf("mysql") >= 0) {
                this.dbType = 3;
            }
        }
        catch (SQLException ex) {
            this.log.severe("Cannot connect to this database : " + ex);
        }
        catch (NamingException ex) {
            this.log.severe("Cannot pick on the database name : " + ex);
        }
    }

    public void connectDB(String dbclass, String dbpath, String dbuser, String dbpassword) {
        if (dbclass.toLowerCase().indexOf("oracle") >= 0) {
            this.dbType = 2;
        }
        if (dbclass.toLowerCase().indexOf("mysql") >= 0) {
            this.dbType = 3;
        }
        this.lDBclass = dbclass;
        this.lDBpath = dbpath;
        this.lDBuser = dbuser;
        this.lDBpassword = dbpassword;
        try {
            Class.forName(dbclass);
            this.db = DriverManager.getConnection(dbpath, dbuser, dbpassword);
            this.dbmd = this.db.getMetaData();
            if (this.dbschema != null) {
                Statement exst = this.db.createStatement();
                exst.execute("ALTER session set current_schema=" + this.dbschema);
                exst.close();
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.severe("Cannot find the database driver classes. : " + ex);
        }
        catch (SQLException ex) {
            this.log.severe("Database connection SQL Error : " + ex);
        }
    }

    public void setSchema(String dbSchema) {
        this.dbschema = dbSchema;
        if (this.dbschema != null) {
            try {
                Statement exst = this.db.createStatement();
                exst.execute("ALTER session set current_schema=" + this.dbschema);
                exst.close();
            }
            catch (SQLException ex) {
                this.log.severe("Database connection SQL Error : " + ex);
            }
        }
    }

    public void reconnect() {
        this.close();
        this.connectDB(this.lDBclass, this.lDBpath, this.lDBuser, this.lDBpassword);
    }

    public void newUser(String userIP, String userName) {
        this.user = new BUser(this, userIP, userName, true);
    }

    public void setUser(String userIP, String userName) {
        this.user = new BUser(this, userIP, userName);
    }

    public void setUser(String userIP, String userName, String narrative) {
        this.user = new BUser(this, userIP, userName);
        String mysql = "INSERT INTO sys_logins (entity_id, login_ip, narrative) VALUES ('";
        mysql = mysql + this.user.getUserID() + "', '" + userIP + "', '" + narrative + "')";
        this.executeQuery(mysql);
    }

    public void setUser(String tableName, String idCol, String nameCol, String userName) {
        this.user.setUser(this, tableName, idCol, nameCol, userName);
    }

    public void logConfig(BLogHandle logHandle) {
        this.logHandle = logHandle;
        logHandle.config(this.log);
    }

    public BLogHandle getLogHandle() {
        return this.logHandle;
    }

    public ResultSet readQuery(String mysql) {
        return this.readQuery(mysql, -1);
    }

    public ResultSet readQuery(String mysql, int limit) {
        ResultSet rs = null;
        try {
            Statement st = this.db.createStatement(1005, 1008);
            if (limit > 0) {
                st.setFetchSize(limit);
            }
            rs = st.executeQuery(mysql);
        }
        catch (SQLException ex) {
            this.log.severe("Database readQuery error : " + ex);
        }
        return rs;
    }

    public String executeFunction(String mysql) {
        String ans = null;
        try {
            Statement st = this.db.createStatement(1005, 1008);
            ResultSet rs = st.executeQuery(mysql);
            if (rs.next()) {
                ans = rs.getString(1);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            ans = null;
            this.lastErrorMsg = ex.getMessage();
            this.log.severe("Database executeFunction error : " + ex);
        }
        return ans;
    }

    public String executeFunction(String mysql, boolean readOnly) {
        String ans = null;
        try {
            Statement st = this.db.createStatement(1003, 1007);
            ResultSet rs = st.executeQuery(mysql);
            if (rs.next()) {
                ans = rs.getString(1);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            ans = null;
            this.lastErrorMsg = ex.getMessage();
            this.log.severe("Database executeFunction error : " + ex);
        }
        return ans;
    }

    public String executeQuery(String mysql) {
        String rst = null;
        try {
            Statement st = this.db.createStatement();
            st.execute(mysql);
            st.close();
        }
        catch (SQLException ex) {
            rst = ex.toString();
            this.lastErrorMsg = ex.toString();
            this.log.severe("Database executeQuery error : " + ex);
        }
        return rst;
    }

    public String executeAutoKey(String mysql) {
        String rst = null;
        try {
            Statement st = this.db.createStatement();
            st.execute(mysql, 1);
            ResultSet rsa = st.getGeneratedKeys();
            if (rsa.next()) {
                rst = rsa.getString(1);
            }
            rsa.close();
            st.close();
        }
        catch (SQLException ex) {
            rst = null;
            this.lastErrorMsg = ex.toString();
            this.log.severe("Database executeAutoKey error : " + ex);
        }
        return rst;
    }

    public String executeUpdate(String updsql) {
        String rst = null;
        try {
            Statement stUP = this.db.createStatement();
            stUP.executeUpdate(updsql);
            stUP.close();
        }
        catch (SQLException ex) {
            rst = ex.toString();
            this.lastErrorMsg = ex.getMessage();
            System.err.println("Database transaction get data error : " + ex);
        }
        return rst;
    }

    public String executeBatch(String mysql) {
        String rst = null;
        try {
            String[] lines;
            Statement st = this.db.createStatement();
            for (String line : lines = mysql.split(";")) {
                if ("".equals(line.trim())) continue;
                st.addBatch(line);
            }
            st.executeBatch();
            st.close();
        }
        catch (SQLException ex) {
            rst = ex.toString();
            this.log.severe("Database executeBatch error : " + ex);
        }
        return rst;
    }

    public Clob createClob() {
        Clob clb = null;
        try {
            clb = this.db.createClob();
        }
        catch (SQLException ex) {
            this.log.severe("Clob Creation error : " + ex);
        }
        return clb;
    }

    public Map<String, String> getFieldsData(String[] fields, String mysql) {
        HashMap<String, String> ans = new HashMap<String, String>();
        try {
            Statement st = this.db.createStatement(1005, 1008);
            ResultSet rs = st.executeQuery(mysql);
            if (rs.next()) {
                for (String field : fields) {
                    ans.put(field.trim(), rs.getString(field.trim()));
                }
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            this.lastErrorMsg = ex.getMessage();
            this.log.severe("Database executeFunction error : " + ex);
        }
        return ans;
    }

    public Map<String, String> readFields(String myFields, String mysource) {
        String[] fields = myFields.split(",");
        Map<String, String> ans = this.getFieldsData(fields, "SELECT " + myFields + " FROM " + mysource);
        return ans;
    }

    public List<String> getTables() {
        ArrayList<String> tableList = new ArrayList<String>();
        try {
            String[] types = new String[]{"TABLE"};
            ResultSet rs = this.dbmd.getTables(null, this.dbschema, "%", types);
            while (rs.next()) {
                String tableName = rs.getString(3);
                if (tableName.indexOf("$") >= 0) continue;
                tableList.add(tableName);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table Listing error : " + ex);
        }
        return tableList;
    }

    public List<String> getViews() {
        ArrayList<String> viewList = new ArrayList<String>();
        try {
            String[] types = new String[]{"VIEW"};
            ResultSet rs = this.dbmd.getTables(null, this.dbschema, "%", types);
            while (rs.next()) {
                viewList.add(rs.getString(3));
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table Listing error : " + ex);
        }
        return viewList;
    }

    public List<BTableLinks> getForeignLinks(String tablename) {
        ArrayList<BTableLinks> fkList = new ArrayList<BTableLinks>();
        try {
            ResultSet tablemd = this.dbmd.getImportedKeys(null, null, tablename);
            while (tablemd.next()) {
                fkList.add(new BTableLinks(tablemd.getString(7), tablemd.getString(8), tablemd.getString(3), tablemd.getString(4)));
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table Listing error : " + ex);
        }
        return fkList;
    }

    public BElement getAppConfig(BElement root) {
        try {
            Integer n;
            String tableName;
            String[] types = new String[]{"TABLE"};
            ResultSet rs = this.dbmd.getTables(null, null, "%", types);
            Integer i = 1;
            BElement menu = new BElement("MENU");
            menu.setAttribute("name", root.getAttribute("name"));
            while (rs.next()) {
                tableName = rs.getString(3);
                if (tableName.toLowerCase().startsWith("sys_")) continue;
                BElement mel = new BElement("MENU");
                mel.setAttribute("name", this.initCap(tableName));
                Integer n2 = i;
                n = i = Integer.valueOf(i + 1);
                mel.setValue(n2.toString());
                menu.addNode(mel);
            }
            root.addNode(menu);
            i = 1;
            rs = this.dbmd.getTables(null, null, "%", types);
            while (rs.next()) {
                tableName = rs.getString(3);
                BQuery query = new BQuery(this, "*", tableName, 2);
                if (!tableName.toLowerCase().startsWith("sys_")) {
                    BElement del = new BElement("DESK");
                    del.setAttribute("h", "500");
                    del.setAttribute("w", "700");
                    del.setAttribute("name", this.initCap(tableName));
                    n = i;
                    Integer n3 = i = Integer.valueOf(i + 1);
                    del.setAttribute("key", n.toString());
                    del.addNode(query.getDeskConfig(0));
                    root.addNode(del);
                }
                query.close();
            }
        }
        catch (SQLException ex) {
            this.log.severe("App Config Creation error : " + ex);
        }
        return root;
    }

    public void createdb(String dbName) {
        String mysql = "CREATE DATABASE " + dbName;
        if (this.dbTemplate != null) {
            mysql = mysql + " TEMPLATE " + this.dbTemplate;
        }
        this.executeQuery(mysql);
    }

    public void dropdb(String dbName) {
        String mysql = "DROP DATABASE " + dbName;
        this.executeQuery(mysql);
    }

    public String getViewSQL() {
        String views = "";
        try {
            String[] tabletypes = new String[]{"TABLE"};
            ResultSet tablers = this.dbmd.getTables(null, this.dbschema, "%", tabletypes);
            while (tablers.next()) {
                String tableName = tablers.getString(3);
                views = views + this.getViewSQL(tableName);
            }
            tablers.close();
        }
        catch (SQLException ex) {
            this.log.severe("SQL Error : " + ex);
        }
        return views;
    }

    public String getViewSQL(String tablename) {
        String mystr = "\n\nCREATE VIEW vw_" + tablename + " AS";
        mystr = mystr + "\n\tSELECT ";
        try {
            String mysql = "SELECT * FROM " + tablename;
            ResultSet tablemd = this.dbmd.getImportedKeys(null, null, tablename);
            Statement st = this.db.createStatement();
            st.setFetchSize(50);
            ResultSet rs = st.executeQuery(mysql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int colnum = rsmd.getColumnCount();
            boolean linked = false;
            ArrayList<String> fieldNames = new ArrayList<String>();
            String strfrom = "\n\tFROM " + tablename;
            while (tablemd.next()) {
                if (linked) {
                    mystr = mystr + ", ";
                }
                mystr = mystr + tablemd.getString(3) + "." + tablemd.getString(4) + ", ";
                mystr = mystr + tablemd.getString(3) + "." + tablemd.getString(4).replaceFirst("id", "name");
                fieldNames.add(tablemd.getString(4));
                strfrom = strfrom + "\n\tINNER JOIN " + tablemd.getString(3);
                strfrom = strfrom + " ON " + tablename + "." + tablemd.getString(8);
                strfrom = strfrom + " = " + tablemd.getString(3) + "." + tablemd.getString(4);
                linked = true;
            }
            if (linked) {
                for (int column = 1; column <= colnum; ++column) {
                    if (fieldNames.contains(rsmd.getColumnLabel(column))) continue;
                    mystr = mystr + ", " + tablename + "." + rsmd.getColumnLabel(column);
                }
                mystr = mystr + strfrom + ";";
            } else {
                for (int column = 1; column <= colnum; ++column) {
                    if (column > 1) {
                        mystr = mystr + ", ";
                    }
                    mystr = mystr + tablename + "." + rsmd.getColumnLabel(column);
                }
                mystr = mystr + strfrom + ";";
            }
            rs.close();
            st.close();
            tablemd.close();
        }
        catch (SQLException ex) {
            this.log.severe("Function getViewSQL Error : " + ex);
        }
        return mystr;
    }

    public String initCap(String mystr) {
        if (mystr != null) {
            String[] mylines = mystr.toLowerCase().split("_");
            mystr = "";
            for (String myline : mylines) {
                if (myline.length() > 0) {
                    myline = myline.replaceFirst(myline.substring(0, 1), myline.substring(0, 1).toUpperCase());
                }
                mystr = mystr + myline + " ";
            }
            mystr = mystr.trim();
        }
        return mystr;
    }

    public String getCatalogName() {
        String catalogName = null;
        try {
            catalogName = this.db.getCatalog();
        }
        catch (SQLException ex) {
            this.log.severe("Database name : " + ex);
        }
        return catalogName;
    }

    public boolean isValid() {
        boolean dbv = false;
        try {
            if (this.db != null) {
                Statement tst = this.db.createStatement(1005, 1008);
                ResultSet trs = tst.executeQuery("SELECT 1;");
                trs.close();
                tst.close();
                dbv = true;
            }
        }
        catch (SQLException ex) {
            this.log.severe("DB Validation Error : " + ex);
        }
        return dbv;
    }

    public void setFullAudit(BElement audit) {
        for (BElement aTables : audit.getElements()) {
            this.fullAudit.add(aTables.getValue());
        }
    }

    public boolean isFullAudit(String tableName) {
        return this.fullAudit.contains(tableName);
    }

    public String insAudit(String tableName, String recordID, String functionType) {
        String insSql = "INSERT INTO sys_audit_trail (user_id, user_ip, table_name, record_id, change_type) VALUES('";
        insSql = insSql + this.getUserID() + "', '" + this.getUserIP() + "', '" + tableName + "', '" + recordID + "', '" + functionType + "')";
        String autoKeyID = this.executeAutoKey(insSql);
        return autoKeyID;
    }

    public void insAuditDetails(String auditId, String oldValues) {
        String inssql = "INSERT INTO sys_audit_details (sys_audit_trail_id, old_value) VALUES('";
        inssql = inssql + auditId + "', '" + oldValues + "')";
        this.executeQuery(inssql);
    }

    public static DataSource getDataSource(String datasource) {
        DataSource ds = null;
        try {
            InitialContext ctx = new InitialContext();
            ds = (DataSource)ctx.lookup(datasource);
        }
        catch (NamingException e) {
            log2.severe("Unable to create DataSource : " + e.toString());
        }
        return ds;
    }

    public static Connection getConnection(String datasource) {
        Connection con = null;
        try {
            con = BDB.getDataSource(datasource).getConnection();
        }
        catch (SQLException e) {
            log2.severe("Unable to get Connection : " + e.toString());
        }
        return con;
    }

    public static PreparedStatement getStatement(String datasource, String sql) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = BDB.getConnection(datasource).prepareStatement(sql);
        }
        catch (SQLException e) {
            log2.severe("Unable to Prepare Statement : " + e.toString());
        }
        catch (Exception ex) {
            log2.severe("Error Preparing Statement : " + ex.toString());
        }
        return preparedStatement;
    }

    public static PreparedStatement getStatement(Connection con, String sql) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = con.prepareStatement(sql);
        }
        catch (SQLException e) {
            log2.severe("Unable to Prepare Statement : " + e.toString());
        }
        catch (Exception ex) {
            log2.severe("Error Preparing Statement : " + ex.toString());
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer executeStatement(PreparedStatement preparedStatement) {
        Integer es = null;
        try {
            es = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            log2.severe("Error Executing Statement" + e.getMessage());
            es = null;
        }
        catch (Exception e1) {
            log2.severe("Error Executing Prepared Statement : " + e1.toString());
            es = null;
        }
        finally {
            if (preparedStatement != null) {
                Connection conn = null;
                try {
                    conn = preparedStatement.getConnection();
                    log2.info("Connection Retrievd");
                }
                catch (SQLException e) {
                    log2.severe("Failed To Retrieve Connection : " + e.toString());
                }
                try {
                    preparedStatement.close();
                    log2.info("Statement Closed");
                }
                catch (SQLException e) {
                    log2.severe("Error Closing Statement : " + e.toString());
                }
                if (conn != null) {
                    try {
                        conn.close();
                        log2.info("Connection Closed");
                    }
                    catch (SQLException e) {
                        log2.severe("Errot Closing Connection : " + e.toString());
                    }
                }
            }
        }
        return es;
    }

    public void makeConfigs() {
        this.configs = new HashMap<String, String>();
        try {
            String mySql = "SELECT config_name, config_value FROM sys_configs WHERE config_type_id = 1";
            Statement st = this.db.createStatement(1003, 1007);
            ResultSet rs = st.executeQuery(mySql);
            while (rs.next()) {
                this.configs.put(rs.getString("config_name"), rs.getString("config_value"));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            this.log.severe("Database connection SQL Error : " + ex);
        }
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public String getConfig(String configName) {
        return this.configs.get(configName);
    }

    public String getSqlOrgWhere(String noorg) {
        String whereSql = null;
        String userOrg = this.getUserOrg();
        if (noorg == null && this.orgID != null && userOrg != null) {
            whereSql = "(" + this.orgID + " = " + userOrg + ")";
        }
        return whereSql;
    }

    public String getSqlUserWhere(String userAttr) {
        String whereSql = null;
        if (userAttr != null) {
            whereSql = "(" + userAttr + " = '" + this.getUserID() + "')";
        }
        return whereSql;
    }

    public Connection getDB() {
        return this.db;
    }

    public DatabaseMetaData getDBMetaData() {
        return this.dbmd;
    }

    public int getDBType() {
        return this.dbType;
    }

    public BUser getUser() {
        return this.user;
    }

    public String getUserID() {
        return this.user.getUserID();
    }

    public String getUserIP() {
        return this.user.getUserIP();
    }

    public String getUserOrg() {
        return this.user.getUserOrg();
    }

    public String getUserName() {
        return this.user.getUserName();
    }

    public boolean getSuperUser() {
        return this.user.getSuperUser();
    }

    public List<String> getUserRoles() {
        return this.user.getUserRoles();
    }

    public List<String> getGroupRoles() {
        return this.user.getGroupRoles();
    }

    public String getGroupIDs() {
        return this.user.getGroupIDs();
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public String getOrgWhere(String orgTable) {
        return this.user.getOrgWhere(orgTable);
    }

    public String getOrgAnd(String orgTable) {
        return this.user.getOrgAnd(orgTable);
    }

    public String getDBSchema() {
        return this.dbschema;
    }

    public String getWebLogos() {
        if (this.user == null) {
            return "";
        }
        return this.user.getWebLogos();
    }

    public String getStartView() {
        return this.user.getStartView();
    }

    public String getLastErrorMsg() {
        return this.lastErrorMsg;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void close() {
        try {
            if (this.db != null) {
                this.db.close();
            }
            this.db = null;
        }
        catch (SQLException ex) {
            this.log.severe("SQL Error : " + ex);
        }
    }
}

